#ifndef __assert_h__
#define __assert_h__
/*============================================================================
=  Novell Software Development Kit
=
=  Copyright (C) 1999-2002 Novell, Inc. All Rights Reserved.
=
=  This work is subject to U.S. and international copyright laws and treaties.
=  Use and redistribution of this work is subject  to  the  license  agreement
=  accompanying  the  software  development kit (SDK) that contains this work.
=  However, no part of this work may be revised and/or  modified  without  the
=  prior  written consent of Novell, Inc. Any use or exploitation of this work
=  without authorization could subject the perpetrator to criminal  and  civil
=  liability. 
=
=  Source(s): ISO/IEC (ANSI) 9899:1990; Novell additions
=
=  assert.h
==============================================================================
*/
#include <stddef.h>

#ifdef __cplusplus
extern "C" {
#endif

void _assert( const char *, const char *, const char *, int );

#ifndef __ANSIC__
enum action_code    /* modifications to behavior of assert()       */
{
   __IGNORE   = -1, /* assert() prints but returns -1              */
   __NOERR    = 0,  /* (value returned for no assertion)           */
   __ABORT    = 1,  /* assert() aborts (normal, default action)    */
   __DEBUGGER = 2   /* assert() prints and drops into the debugger */
};

int  assert_action( enum action_code );
int  _assert_expr ( int, const char *, const char *, const char *, int );
#endif

#ifdef __cplusplus
}
#endif

#endif /* __assert_h__ */


#ifdef NDEBUG             /* assertions are null operations */

# undef  assert
# define assert(e) ((void) 0)

# ifndef __ANSIC__
#  undef assertf
#  undef assert_action
#  define ASSERT(e)        ((void) 0)
#  define ASSERTF(e)       ((void) 0)
#  define assertf(e)       ((void) 0)
#  define assert_action(c) ((void) 0)
# endif

#else

# ifdef __STDC_VERSION
#  if __STDC_VERSION >= 199901L
#   define FUNCNAME __func__
#  endif
# endif
# ifndef FUNCNAME
#  define FUNCNAME  (char *) NULL
# endif
# undef  assert
# define assert(e)  ((void) ((e)||(_assert(#e,FUNCNAME,__FILE__,__LINE__),0)))

# ifndef __ANSIC__
#  define ASSERT     assert
#  define ASSERTF    assertf
#  define assertf(e) _assert_expr((e),#e,FUNCNAME,__FILE__,__LINE__)
# endif

#endif /* NDEBUG */
