#ifndef __client_h__
#define __client_h__
/*============================================================================
=  Novell Software Development Kit
=
=  Copyright (C) 1999-2002 Novell, Inc. All Rights Reserved.
=
=  This work is subject to U.S. and international copyright laws and treaties.
=  Use and redistribution of this work is subject  to  the  license  agreement
=  accompanying  the  software  development kit (SDK) that contains this work.
=  However, no part of this work may be revised and/or  modified  without  the
=  prior  written consent of Novell, Inc. Any use or exploitation of this work
=  without authorization could subject the perpetrator to criminal  and  civil
=  liability.
=
=  Source(s): Novell Header
=
=  client.h
==============================================================================
*/
#include <stddef.h>
#include <stdbool.h>
#include <nks/fsio.h>

/* origin flags... */
#define ORIGIN_NAME     0x0010  /* interpret 'server' as string             */
#define ORIGIN_ADDRESS  0x0020  /* interpret 'server' as 'netaddr_t'        */

/* address type flags (used in combination with ORIGIN_ADDRESS)... */
#define ADDR_IPX        0x0100  /* address is IPX                           */
#define ADDR_IP         0x0200  /* address is Internet Protocol             */
#define ADDR_IPV6       0x0400  /* address is Internet Protocol version 6   */

/* transport type flags... */
#define XPORT_WILD      0x0000  /* transport type unspecified               */
#define XPORT_IPX       0x0001  /* prefer Novell IPX                        */
#define XPORT_TCP       0x0002  /* prefer TCP                               */

/* NMAS sequence passed... */
#define NMAS_SEQUENCE   0x8000  /* alternative authentication based on NMAS */

#include <pshpack1.h>

typedef struct
{
#define MAX_SESSION_ADDR_LEN 48
   int     reserved;
   size_t  length;
   uint8_t address[MAX_SESSION_ADDR_LEN];
} netaddr_t;

typedef struct
{
   void   *data;
   size_t  length;
} frag_t;

#include <poppack.h>

#ifdef __cplusplus
extern "C"
{
#endif

/* managing user identity... */
int  build_username( size_t max, unsigned long flags, char *username,
         const char *user, ... );
int  create_identity( const char *treename, const char *username,
         const char *password, const void *nmas_sequence, unsigned long flags,
         int *identity );
int  create_server_identity( int *identity );
bool is_valid_identity( int identity, int *error );
void delete_identity( int identity );

/* managing NCP sessions with a remote server... */
int open_ncp_session( int identity, unsigned long flags, const char *server,
         int *session );
int close_ncp_session( int session );
int send_ncp( int session, int requestCode, int sendFragCount,
         frag_t sendFrags[], int replyFragCount, frag_t replyFrags[],
         int *replyFragsUsed, int *ncp_error); 

#ifdef __cplusplus
}
#endif

#endif
