#ifndef __ctype_h__
#define __ctype_h__
/*============================================================================
=  Novell Software Development Kit
=
=  Copyright (C) 1999-2002 Novell, Inc. All Rights Reserved.
=
=  This work is subject to U.S. and international copyright laws and treaties.
=  Use and redistribution of this work is subject  to  the  license  agreement
=  accompanying  the  software  development kit (SDK) that contains this work.
=  However, no part of this work may be revised and/or  modified  without  the
=  prior  written consent of Novell, Inc. Any use or exploitation of this work
=  without authorization could subject the perpetrator to criminal  and  civil
=  liability. 
=
=  Source(s): ISO/IEC (ANSI) 9899:1990, ISO/IEC (ANSI) 9989:1999
=
=  ctype.h
==============================================================================
*/
#include <stddef.h>

#ifdef __cplusplus
extern "C"
{
#endif

#if defined(IAPX386)
extern unsigned char __ctype[];
#endif

/* standard prototypes... */
int isalnum ( int );
int isalpha ( int );
int isblank ( int );
int iscntrl ( int );
int isdigit ( int );
int isgraph ( int );
int islower ( int );
int isprint ( int );
int ispunct ( int );
int isspace ( int );
int isupper ( int );
int isxdigit( int );
int tolower ( int );
int toupper ( int );

#ifndef __ANSIC__
int isascii    ( int );
int toascii    ( int );
int ismultibyte( const char * );

int Lisalnum   ( const char * );
int Lisalpha   ( const char * );
int Lisblank   ( const char * );
int Liscntrl   ( const char * );
int Lisdigit   ( const char * );
int Lisgraph   ( const char * );
int Lislower   ( const char * );
int Lisprint   ( const char * );
int Lispunct   ( const char * );
int Lisspace   ( const char * );
int Lisupper   ( const char * );
int Lisxdigit  ( const char * );
#endif

#ifdef __cplusplus
}
#endif

#ifdef __cplusplus
static const int _UPPER_  = 0x01;
static const int _LOWER_  = 0x02;
static const int _DIGIT_  = 0x04;
static const int _SPACE_  = 0x08;
static const int _PUNCT_  = 0x10;
static const int _CNTRL_  = 0x20;
static const int _BLANK_  = 0x40;
static const int _XDIGIT_ = 0x80;
#else
# ifndef _UPPER_
#  define _UPPER_  0x01  /* upper case        */
#  define _LOWER_  0x02  /* lower case        */
#  define _DIGIT_  0x04  /* numeral (digit)   */
#  define _SPACE_  0x08  /* spacing character */
#  define _PUNCT_  0x10  /* punctuation       */
#  define _CNTRL_  0x20  /* control character */
#  define _BLANK_  0x40  /* blank             */
#  define _XDIGIT_ 0x80  /* hexadecimal digit */
# endif
#endif

#define __CTYPE1(c)        (__ctype+1)[(unsigned int) (c)]
#define _ALPHA_            (_UPPER_|_LOWER_)
#define _GRAPH_            (_PUNCT_|_ALPHA_|_DIGIT_)

#ifdef __cplusplus
# if defined(IAPX386)
inline int isalnum (int c) { return (__CTYPE1(c) & (_ALPHA_|_DIGIT_)); }
inline int isalpha (int c) { return (__CTYPE1(c) & _ALPHA_); }
inline int isblank (int c) { return (__CTYPE1(c) & _BLANK_); }
inline int iscntrl (int c) { return (__CTYPE1(c) & _CNTRL_); }
inline int isdigit (int c) { return (__CTYPE1(c) & _DIGIT_); }
inline int isxdigit(int c) { return (__CTYPE1(c) & _XDIGIT_); }
inline int isgraph (int c) { return (__CTYPE1(c) & _GRAPH_); }
inline int islower (int c) { return (__CTYPE1(c) & _LOWER_); }
inline int isupper (int c) { return (__CTYPE1(c) & _UPPER_); }
inline int isprint (int c) { return (__CTYPE1(c) & (_GRAPH_|_BLANK_)); }
inline int ispunct (int c) { return (__CTYPE1(c) & _PUNCT_); }
inline int isspace (int c) { return (__CTYPE1(c) & _SPACE_); }
# endif

# ifndef __ANSIC__
inline int isascii(int c)  { return !((c) & ~0x7f); }
inline int toascii(int c)  { return   (c) &  0x7f; }
# endif

#else
# if defined(IAPX386)
#  define isalnum(c)  (__CTYPE1(c) & (_ALPHA_|_DIGIT_))
#  define isalpha(c)  (__CTYPE1(c) &  _ALPHA_)
#  define isblank(c)  (__CTYPE1(c) &  _BLANK_)
#  define iscntrl(c)  (__CTYPE1(c) &  _CNTRL_)
#  define isdigit(c)  (__CTYPE1(c) &  _DIGIT_)
#  define isxdigit(c) (__CTYPE1(c) &  _XDIGIT_)
#  define isgraph(c)  (__CTYPE1(c) & (_PUNCT_|_ALPHA_|_DIGIT_))
#  define islower(c)  (__CTYPE1(c) &  _LOWER_)
#  define isupper(c)  (__CTYPE1(c) &  _UPPER_)
#  define isprint(c)  (__CTYPE1(c) & (_PUNCT_|_ALPHA_|_DIGIT_|_BLANK_))
#  define ispunct(c)  (__CTYPE1(c) &  _PUNCT_)
#  define isspace(c)  (__CTYPE1(c) &  _SPACE_)
# endif

# ifndef __ANSIC__
#  define isascii(c)   (!((c) & ~0x7f))
#  define toascii(c)   (  (c) &  0x7f)
# endif
#endif


#endif
