#ifndef __dirent_h__
#define __dirent_h__
/*============================================================================
=  Novell Software Development Kit
=
=  Copyright (C) 1999-2002 Novell, Inc. All Rights Reserved.
=
=  This work is subject to U.S. and international copyright laws and treaties.
=  Use and redistribution of this work is subject  to  the  license  agreement
=  accompanying  the  software  development kit (SDK) that contains this work.
=  However, no part of this work may be revised and/or  modified  without  the
=  prior  written consent of Novell, Inc. Any use or exploitation of this work
=  without authorization could subject the perpetrator to criminal  and  civil
=  liability. 
=
=  Source(s): ISO/IEC (POSIX) 9845:1996
=
=  dirent.h
==============================================================================
*/
#include <limits.h>
#include <stddef.h>
#include <sys/mode.h>

/* values for field 'd_type'... */
#define DT_UNKNOWN  0          /* unknown entry                         */
#define DT_TTY      1          /* console (won't occur)                 */
#define DT_REG      S_IFREG    /* normal file                           */
#define DT_DIR      S_IFDIR    /* subdirectory                          */
#define DT_FIFO     S_IFIFO    /* first-in/first-out (FIFO/pipe)        */
#define DT_SOCK     S_IFSOCK   /* socket (won't occur)                  */
#define DT_CHR      S_IFCHR    /* character-special file (unused)       */
#define DT_BLK      S_IFBLK    /* blocking device (unused)              */
#define DT_LNK      S_IFLNK    /* symbolic or hard link (won't occur)   */

#include <pshpack1.h>

typedef struct dirent
{
   uint32_t d_userspec;        /* untouched by readdir()                */
   uint32_t d_flags;           /* flags for this entry                  */
   mode_t   d_type;            /* type of entry                         */
   uint32_t d_spare1;
   ino_t    d_ino;             /* directory entry number of d_name      */
   off64_t  d_size;            /* size if file                          */
   uint32_t d_spare2[55];
   uint8_t  d_pad1;
   uint8_t  d_pad2;
   uint8_t  d_pad3;
   uint8_t  d_namelen;         /* len of following name:                */
   char     d_name[NAME_MAX+1];/* only portable field in this structure */
} DIR;                         /* sizeof(struct dirent) == 0x200 (512.) */

#include <poppack.h>

#ifdef __cplusplus
extern "C"
{
#endif

int   closedir ( DIR *dirp );
DIR  *opendir  ( const char *pathName );
DIR  *readdir  ( DIR *dirp );
int	readdir_r( DIR *dirp, struct dirent *entry, struct dirent **result);
void  rewinddir( DIR *dirp );


#ifdef __cplusplus
}
#endif

#define closedir64  closedir   /* same function does both         */
#define opendir64   opendir    /* same function does both         */
#define readdir64   readdir    /* same function does both         */
#define rewinddir64 rewinddir  /* same function does both         */
#define DIR64       DIR        /* same structure does both        */
#define dirent64    dirent     /* same structure does both        */

#define d_fileno    d_ino      /* backward compatibility some platforms */

#endif
