#ifndef __dlfcn_h__
#define __dlfcn_h__
/*============================================================================
=  Novell Software Development Kit
=
=  Copyright (C) 1999-2002 Novell, Inc. All Rights Reserved.
=
=  This work is subject to U.S. and international copyright laws and treaties.
=  Use and redistribution of this work is subject  to  the  license  agreement
=  accompanying  the  software  development kit (SDK) that contains this work.
=  However, no part of this work may be revised and/or  modified  without  the
=  prior  written consent of Novell, Inc. Any use or exploitation of this work
=  without authorization could subject the perpetrator to criminal  and  civil
=  liability.
=
=  Source(s): Open Group Header
=
=  dlfcn.h
==============================================================================
=  Interfaces from the Single UNIX Specification of the Open Group for the
=  management of imported symbols and shared (dynamic) libraries. The imple-
=  mentation on NetWare is narrower as noted by the number of features that
=  are ignored or unsupported.
==============================================================================
*/
#include <stddef.h>

/* mode flags for dlopen()... */
#define RTLD_LAZY          0x01  /* ignored                            */
#define RTLD_NOW           0x02  /* ignored                            */
#define RTLD_GLOBAL        0x04  /* ignored                            */
#define RTLD_LOCAL         0x08  /* ignored                            */
#define RTLD_MULTIPLE      0x10  /* NetWare: force-load multiple times */

/* special purpose value for 'handle' in dlsym()... */
#define RTLD_NEXT (void *) (-1)  /* unsupported                        */

/* maximim length of the actual NLM name within 'path' in dlopen()... */
#define MAX_DLL_NAME_LEN   8

/* maximim length of 'name' in dlsym()... */
#define MAX_SYMNAME_LEN    255


#ifdef __cplusplus
extern "C"
{
#endif

void  *dlopen ( const char *path, int mode );
void  *dlsym  ( void *handle, const char *name );
int    dlclose( void *handle );
char  *dlerror( void );

#ifdef __cplusplus
}
#endif

#endif
