#ifndef __esm_h__
#define __esm_h__
/*=============================================================================
=  Novell Software Development Kit
=
=  Copyright (C) 1999-2002 Novell, Inc. All Rights Reserved.
=
=  This work is subject to U.S. and international copyright laws and treaties.
=  Use and redistribution of this work is subject  to  the  license  agreement
=  accompanying  the  software  development kit (SDK) that contains this work.
=  However, no part of this work may be revised and/or  modified  without  the
=  prior  written consent of Novell, Inc. Any use or exploitation of this work
=  without authorization could subject the perpetrator to criminal  and  civil
=  liability. 
=
=  Source(s): Novell header
=
=  Consumption of NetWare 5 & 6 memory beyond 4 gigabytes.
=
=  esm.h
===============================================================================
*/
#include <stddef.h>

/* errors for extended memory...                                             */
#define ERR_ESM_AVAL         1 /* no registered memory above 4G           */
#define ERR_SIZE_ZERO        2 /* ESMAlloc size requested is zero         */
#define ERR_TABLE_FULL       3 /* allocation table is full                */
#define ERR_NOT_CONTIGUOUS   4 /* ESMAlloc request cannot be continguous  */
#define ERR_INVAL_ADDRESS    5 /* already free or out of range            */
#define ERR_INVAL_SRC_ADDR   6 /* bad source address (ESMCopy)            */
#define ERR_INVAL_DEST_ADDR  7 /* bad destination address(ESMCopy/ESMFill)*/
#define ERR_SRC_DEST_OVERLAP 8 /* buffer overlap (ESMCopy)                */

/* (will be obsolete when the overlapping buffer copy implemented...)        */
#define ERR_MAP_4M_PAGE      9 /* mapping particular 4M page failed       */
#define ERR_BUFFER_SIZE     10 /* buffer passed too small (ESMQuery)      */
#define ERR_LOGICAL_SPACE   11 /* adequate logical/window not available   */
#define ERR_ACQUIRING_LOCK  12 /* failed to acquire lock (please retry)   */

typedef uint64_t addr64_t;

typedef struct
{
   size64_t TotalExtendedMemory;
   size64_t RemainingExtendedMemory;
   size_t   TotalMemoryBelow4G;
} ESMQueryInfo_t;

#ifdef __cplusplus
extern "C" {
#endif

int ESMAlloc      (size64_t size, unsigned long options, addr64_t *esmAddress);
int ESMAllocWindow(size_t size, void **logicalAddress, void *callerID);
int ESMCopy       (addr64_t source, addr64_t destination, size64_t length);
int ESMFill       (uint32_t pattern, addr64_t destination, size64_t length);
int ESMFree       (addr64_t esmAddress);
int ESMFreeWindow (void *logicalAddress, void *callerID);
int ESMMapMemory  (void *windowAddress, addr64_t memoryAddress, size_t size);
int ESMQuery      (size_t bufferSize, ESMQueryInfo_t *buffer);

#ifdef __cplusplus
}
#endif

#endif
