#ifndef __event_h__
#define __event_h__
/*============================================================================
=  Novell Software Development Kit
=
=  Copyright (C) 1999-2002 Novell, Inc. All Rights Reserved.
=
=  This work is subject to U.S. and international copyright laws and treaties.
=  Use and redistribution of this work is subject  to  the  license  agreement
=  accompanying  the  software  development kit (SDK) that contains this work.
=  However, no part of this work may be revised and/or  modified  without  the
=  prior  written consent of Novell, Inc. Any use or exploitation of this work
=  without authorization could subject the perpetrator to criminal  and  civil
=  liability.
=
=  Source(s): Novell Header
=
=  Direct consumption of NetWare Event interfaces.
=
=  event.h
==============================================================================
*/
#include <stddef.h>
#include <stdint.h>

#ifndef __RTAG_T
# define __RTAG_T
typedef void *rtag_t;
#endif


#ifdef __cplusplus
extern "C" {
#endif

#include <pshpack1.h>

/* file server event notification interfaces... */
#define EVENT_VOL_SYS_MOUNT             0
#define EVENT_VOL_SYS_DISMOUNT          1
#define EVENT_ANY_VOL_MOUNT             2
#define EVENT_ANY_VOL_DISMOUNT          3
#define EVENT_DOWN_SERVER               4
#define EVENT_EXIT_TO_DOS               7
#define EVENT_MODULE_UNLOAD             8
#define EVENT_MODULE_UNLOAD_POST_EXIT 115
#define EVENT_CLEAR_CONNECTION          9
#define EVENT_LOGIN_USER               10
#define EVENT_CREATE_BINDERY_OBJ       11
#define EVENT_DELETE_BINDERY_OBJ       12
#define EVENT_CHANGE_SECURITY          13
               typedef struct
               {
                  uint32_t objectID;
                  uint32_t equivalentID;
                  uint32_t changeFlags;
#define                       EVENT_CHANGE_SECURITY_ADD_EQUIVALENCE     1
#define                       EVENT_CHANGE_SECURITY_REMOVE_EQUIVALENCE  2
               }  EventSecurityChange_t;

#define EVENT_ACTIVATE_SCREEN          14
#define EVENT_UPDATE_SCREEN            15
#define EVENT_UPDATE_CURSOR            16
#define EVENT_KEY_WAS_PRESSED          17
#define EVENT_DEACTIVATE_SCREEN        18
#define EVENT_TRUSTEE_CHANGE           19
               typedef struct
               {
                  uint32_t objectID;
                  uint32_t entryID;
                  int      volumeNumber;
                  uint32_t changeFlags;
#define                       EVENT_TRUSTEE_CHANGE_NEW      1
#define                       EVENT_TRUSTEE_CHANGE_REMOVE   2
                  uint32_t newRights;
               } EventTrusteeChange_t;

#define EVENT_OPEN_SCREEN              20
#define EVENT_CLOSE_SCREEN             21
#define EVENT_MODIFY_DIR_ENTRY         22
               typedef struct
               {
                  uint32_t primaryDirectoryEntry;
                  int      nameSpace;
                  uint32_t modifyBits;
                  void    *modifyVector;
                  int      volumeNumber;
                  uint32_t directoryEntry;
               } EventModifyDirEntry_t;

#define EVENT_NO_RELINQUISH_CONTROL    23
#define EVENT_THREAD_SWITCH            25
#define EVENT_MODULE_LOAD              27
#define EVENT_CREATE_PROCESS           28
#define EVENT_DESTROY_PROCESS          29
#define EVENT_NEW_PUBLIC               32
#define EVENT_PROTOCOL_BIND            33
#define EVENT_PROTOCOL_UNBIND          34
               typedef struct
               {
                  int   boardNumber;
                  int   protocolNumber;
               } EventProtocolBind_t;

#define EVENT_ALLOCATE_CONNECTION      37
#define EVENT_LOGOUT_CONNECTION        38
#define EVENT_MLID_REGISTER            39
#define EVENT_MLID_DEREGISTER          40
#define EVENT_DATA_MIGRATION           41
#define EVENT_DATA_DEMIGRATION         42
               typedef struct
               {
                  uint32_t FileSystemTypeID;
                  int      Volume;
                  uint32_t DOSDirEntry;
                  uint32_t OwnerDirEntry;
                  int      OwnerNameSpace;
                  char     OwnerFileName[1+255];
               } EventDateMigrationInfo_t;

#define EVENT_QUEUE_ACTION             43
               typedef struct
               {
                  int      QAction;
#define                       QUEUE_CREATED     0
#define                       QUEUE_DELETED     1
#define                       QUEUE_ACTIVATED   2
#define                       QUEUE_DEACTIVATED 3
                  uint32_t QID;
                  char     QName[49+1];
               } EventQueueNote_t;

#define EVENT_NETWARE_ALERT            44
               typedef struct
               {
                  uint32_t alertFlags;
                  uint32_t alertId;
                  uint32_t alertLocus;
                  uint32_t alertClass;
                  uint32_t alertSeverity;
                  int      targetStationCount;
                  uint32_t targetStationList[32];
                  uint32_t targetNotificationBits;
                  int      alertParmCount;
                  void    *alertDataPtr;
                  void    *NetWorkManagementAttributePointer;
                  uint32_t alertUnused[2];
                  int      alertControlStringMessageNumber;
                  char     alertControlString[256];
                  char     alertParameters[256+256];
                  char     alertModuleName[36];
                  int      alertModuleMajorVersion;
                  int      alertModuleMinorVersion;
                  int      alertModuleRevision;
               } EventNetWareAlert_t;

#define EVENT_CREATE_OBJECT            46
#define EVENT_DELETE_OBJECT            47
#define EVENT_RENAME_OBJECT            48
#define EVENT_VALUE_CHANGE             49
#define EVENT_MOVE_OBJECT              52
#define EVENT_VALUE_ADD                53
#define EVENT_VALUE_DEL                54
               typedef struct
               {
                  uint32_t EventObjectSignature;
#define                       EventBinderySignature 0X444E4942
                  uint32_t ObjectID;
                  uint32_t ObjectType;
               } EventBinderyObject_t;

#define EVENT_DS_EVENT                 58
               void  *DSAllocateEventTag( uint32_t signature );
               typedef struct
               {
                  uint32_t EventObjectSignature;
#define                       EventDSSignature 0x43565344
                  uint32_t EventType;
                  void    *entry;
               } EventDSObject_t;

#define EVENT_CLOSE_FILE               50
               typedef struct
               {
                  uint32_t fileHandle;
                  int      station;
                  int      task;
                  uint32_t fileHandleFlags;
#define                       ECNotReadableBit      0x00000001
#define                       ECNotWriteableBit     0x00000002
#define                       ECWrittenBit          0x00000004
#define                       ECDetachedBit         0x00000008
#define                       ECDirectFileSystemBit 0x00000020
#define                       ECFileWriteThroughBit 0x00000040
                  int      completionCode;
               } EventCloseFileInfo_t;

#define EVENT_CHANGE_TIME              51
#define EVENT_DM_KEY_MODIFIED          55
#define EVENT_MODULE_UNLOADED          56
#define EVENT_REMOVE_PUBLIC            57
#define EVENT_UNICODE                  59
#define EVENT_SFT3_SERVER_STATE        60
#define EVENT_SFT3_IMAGE_STATE         61
#define EVENT_SFT3_PRESYNC_STATE       62
#define EVENT_ALTERNATE_MOUNT_VOLUME   63
#define EVENT_CONSOLE_CONFIG_COMMAND   64
#define EVENT_CONSOLE_VERSION_COMMAND  65
#define EVENT_PRE_LOAD_NLM             66
#define EVENT_LOW_MEMORY               67

#define EVENT_PRIORITY_APPLICATION     20  /* (highest) */
#define EVENT_PRIORITY_DEVICE          40  /* (lowest)  */

/*
** A consumer registering for an event sets this flag in the event type to
** denote that the consumer is multiprocessor safe. This allows us to
** distinguish multiprocessor safe consumers from unsafe ones.
*/
#define EVENT_CONSUMER_MT_SAFE         0x40000000

/*
** Values for fields of EventNetWareAlertStruct_t.
*/
#define QueueThisAlertMask          0x00000001
#define AlertIDValidMask            0x00000002
#define AlertLocusValidMask         0x00000004
#define AlertEventNotifyOnlyMask    0x00000008
#define AlertNoEventNotifyMask      0x00000010
#define AlertMessageNumberValid     0x00010000
#define NoDisplayAlertUID           0x00200000
#define AlertNoRingBell             0x00400000
#define AlertIDNotUniqueBit         0x00800000
#define OldStyleSystemAlertMask     0x01000000
#define OldStyleINWSystemAlertMask  0x02000000
#define OverloadMessageNumFieldBit  0x04000000 /* can be pointer or number */ 
#define NoDisplayLocusBit           0x10000000
#define NoDisplayAlertIDBit         0x20000000
#define OverrideNotificationBits    0x40000000
#define TargetStationIsAPointer     0x80000000

#define Alert300Mask    (AlertIDValidMask | AlertLocusValidMask \
                           | OldStyleSystemAlertMask)
#define Alert311Mask    (AlertIDValidMask | OldStyleINWSystemAlertMask)
#define Alert320Mask    (AlertIDValidMask | AlertMessageNumberValid \
                           | AlertLocusValidMask | NoDisplayAlertIDBit)
#define QAlertMask      (AlertIDValidMask | AlertLocusValidMask \
                           | NoDisplayAlertIDBit | QueueThisAlertMask)
#define QAlert320Mask   (Alert320Mask | QueueThisAlertMask)

/*
** Values for 'alertID' in EventNetWareAlertStruct_t comprised of two parts,
** the ModuleNumber (upper 16 bits) and AlertNumber (lower 16 bits).
** AlertNumber is under the control of the module specified by ModuleNumber.
**
** ModuleNumber specifies which module is generating the alert and AlertNumber
** can then be used for a specific alert generated by that module.
**
** Any ModuleNumber in the range 0x8000xxxx to 0xFFFFxxxx. Range 0x0001xxxx
** through 0x7fffxxxx is reserved for Novell. Value 0x0000xxxx is considered
** invalid and is used for all legacy alerts.
*/

/* allotted ModuleNumbers for 'alertID' in EventNetWareAlertStruct_t... */
#define ALERT_BINDERY   0x01020000     /* Bindery Subject              */
#define ALERT_OS        0x01030000     /* OS Event Subject             */
#define ALERT_LLC       0x01040000     /* LLC                          */
#define ALERT_SDLC      0x01050000     /* SDLC Stack                   */
#define ALERT_REMOTE    0x01060000     /* RConsole                     */
#define ALERT_MLID      0x01070000     /* MLID LAN Drivers             */
#define ALERT_QLLC      0x01080000     /* QLLC                         */
#define ALERT_UPS       0x01090000     /* UPS Monitor                  */
#define ALERT_DS        0x010a0000     /* Directory Service            */
#define ALERT_RSPX      0x010c0000     /* RSPX                         */
#define ALERT_R232      0x010d0000     /* R232                         */
#define ALERT_TIME_SYNC 0x010e0000     /* TimeSync                     */
#define ALERT_CLIB      0x010f0000     /* CLib                         */
#define ALERT_PRINT     0x01100000     /* Print                        */
#define ALERT_NRS       0x01200000     /* Novell Replication Services  */
#define ALERT_DNS       0x01300000     /* IP/Domain Name Services      */
#define ALERT_DHCP      0x01400000     /* DHCP Services                */
#define ALERT_MM        0x01500000     /* Media Manager                */

/*
** OS-defined AlertNumber values for 'alertID' in EventNetWareAlertStruct_t
** structure.
*/
/* starting with NetWare 4... */
#define nmAllocFailed                           1
#define nmErrWrtExtDir                          2
#define nmSysErrWrtDSnoFN                       3
#define nmStaErrWrtDSnoFN                       4
#define nmSysErrWrtDSwithFN                     5
#define nmStaErrWrtDSwithFN                     6
#define nmSysErrRdDSnoFN                        7
#define nmStaErrRdDSnoFN                        8
#define nmSysErrRdDSwithFN                      9
#define nmStaErrRdDSwithFN                      10
#define nmSysWrtPreRDnoFN                       11
#define nmStaWrtPreRDnoFN                       12
#define nmSysWrtPreRDwithFN                     13
#define nmStaWrtPreRDwithFN                     14
#define nmCacheMemLimitExceded                  15
#define nmCacheMemOutOfMem                      16
#define nmCacheBufsGetLo                        17 
#define nmDskSpcNoDelFiles                      18 
#define nmDskSpcNoLimbo                         19 
#define nmVolSpcAlmostGone                      20 
#define nmFATWrtErr                             21 
#define nmDirWrtErr                             22
#define nmDirCopyRdErr                          23 
#define nmDirDblRdErr                           24 
#define nmAllocDirWrtErr                        25
#define nmDirExpansionErr                       26 
#define nmDirTooLarge                           27 
#define nmErrExpandingDir                       28
#define nmErrExpandingMem                       29 
#define nmErrDirGetTooLarge                     30 
#define nmDskBottleneck                         31 
#define nmWDClearedConn                         32 
#define nmCpyrtViolation                        33 
#define nmReadFault                             35 
#define nmPktTooSmall                           36 
#define nmCreatingVolLog                        37 
#define nmWrtVolLog                             38 
#define nmVolDmtDevDeact                        39 
#define nmLoginDisabled                         40 
#define nmLoginEnabled                          41 
#define nmClrSta                                42 
#define nmClrStaByUsr                           43 
#define nmFSDownByUser                          44 
#define nmRIPAlreadyOpn                         45 
#define nmRouterConfigErr                       46 
#define nmLANLoopbackErr                        47 
#define nmRouterConfigErrNoInfo                 48 
#define nmIPXUnreachable                        49 
#define nmIPXUnbind                             50
#define nmSAPAlreadyOpn                         51 
#define nmRouterConfigErrNameInfo               52 
#define nmSpuriousInt                           53 
#define nmChecksumInvalidAlert                  54
#define nmPrimaryPicLostInt                     55 
#define nmSecondaryPicLostInt                   56 
#define nmCompErrHoleCountMismatch              57 
#define nmInvalidScreen                         58 
#define nmRelinquishControl                     59 
#define nmFSUserDeleted                         60 
#define nmAccDelByUser                          61 
#define nmInvalidRTag                           62 
#define nmDeactUnknown                          63
#define nmDeactDriveUnld                        64
#define nmDeactDevFailure                       65
#define nmDeactUsrRequest                       66
#define nmDeactMediaDismount                    67
#define nmDeactMediaEject                       68
#define nmDeactServerDown                       69
#define nmDeactServerFailure                    70
#define nmResourceRelErr                        71 
#define nmMirrorsNotSync                        72 
#define nmMirrorsSyncUp                         73 
#define nmPartMirrorSync                        74 
#define nmPartMirrorNotSync                     75
#define nmReMirroringPart                       76 
#define nmReMirroringPartAborted                77 
#define nmLogPartMirrorInconsist                78 
#define nmSysFileLockThresh                     79 
#define nmStaFileLockThresh                     80 
#define nmSysRecLockThresh                      81 
#define nmStaRecLockThresh                      82
#define nmOpnNETACCTFailed                      83 
#define nmNCPSearchLimitSys                     84 
#define nmNCPSearchLimitSta                     85 
#define nmInsMediaAck                           86 
#define nmInsMediaAborted                       87 
#define nmRemMediaAck                           88 
#define nmRemMediaAbort                         89 
#define nmInsMediaInto                          90 
#define nmRemMediaFrom                          91 
#define nmReDirectedBlockPart                   92 
#define nmReDirectedBlockPartErr                93 
#define nmOutOfHotFixBlocks                     94 
#define nmLowWarningHotFixBlocks                95 
#define nmReDirectInconsistNoFix                96 
#define nmReDirectInconsistFixed                97 
#define nmInvalidRTagHOptions                   98 
#define nmCheckAndAddHWNoGetRTag                99 
#define nmRemHWBadPtr                           100
#define nmErrUnldNLM                            101
#define nmIvldRTagCrProc                        102
#define nmCrProcStkTooSmall                     103
#define nmCrProcNoPCB                           104
#define nmDelToLimboFileErr                     105
#define nmDelToLimboNoSpace                     106
#define nmMLIDResetLanBd                        107
#define nmRouterReset                           108
#define nmVolWrongDOSType                       109
#define nmNoOwnerNSfound                        110
#define nmRTDMDefSMchanged                      111
#define nmErrOpnTTSLOG                          112
#define nmErrWrtTTSLOG                          113
#define nmTTSdownVolDismount                    114
#define nmTTSdisableByStaUsr                    115
#define nmTTSdisByOp                            116
#define nmTTSdisErrRdBackFile                   117
#define nmTTSdisErrWrBackFile                   118
#define nmTTSdisTooManyDefVol                   119
#define nmTTSdisWrtVolDefInfo                   120
#define nmTTSdisErrRdBkFlRecGen                 121
#define nmTTSdisGrowMemTables                   122
#define nmTTSdisErrAllDiskSp                    123
#define nmTTSdisDirErrOnBkFile                  124
#define nmTTSEnableByStaUsr                     125
#define nmTTStransAbortedForSta                 126
#define nmTTStooManyTransDelaying               127
#define nmTTSNoMemForExpTransNodes              128
#define nmAuditEvent                            129
#define nmAuditDisNoAuditCfg                    130
#define nmInvldConnTypeToAllocConn              131
#define nmInvldRTagToAllocConn                  132
#define nmOutOfServerConns                      133
#define nmConnTermAfter5Min                     134
#define nmUsrAccDisableBySta                    135
#define nmUnEncryptPwdNotAllowed                136
#define nmSuperAccLockedByConsole               137
#define nmSystemTimeChangedByCon                138
#define nmSystemTimeChangedBySta                139
#define nmVolStillActWithError                  140
#define nmRouterFalsehood                       141
#define nmServerAddressChanged                  142
#define nmExtFileNoOwnerCharge                  143
#define nmRouterConfigErrNode                   144
#define nmRouterConfigErrMyAddr                 145
#define nmNoMigratorLd                          146
#define nmNoSMLd                                147
#define nmNotEnoughRamForCompression            148
#define nmDiskErrorCompressing                  149
#define nmUnknownErrorCompressing               150
#define nmInsufficientSpaceForDeCompression     151
#define nmDecompressUnknownCompressionVersion   152
#define nmUnknownDecompressError                153
#define nmInsufficientRAMToDecompress           154
#define nmCompressedFileIsCorrupt               155
#define nmStaAttemptedToUseBadPckt              156
#define nmStaUsedABadPckt                       157
#define nmStaAttemptedToUseBadSFL               158
#define nmStaUsedABadSFL                        159
#define nmCorruptCompFileWithName               160
#define nmCorruptCompFileWithNameAndStation     161
#define nmLowPriThreadsNotRun                   162
#define nmWorkToDoNotRun                        163
#define nmCompressErrorTempFileError            164
#define nmCompressErrorLengthTotalsMismatch     165
#define nmCompressErrorOffsetTotalsMismatch     166
#define nmCompressErrorDataCodeCountMismatch    167
#define nmCompressErrorLengthCountMismatch      168
#define nmCompressErrorLargeLengthCountMismatch 169
#define nmCompressErrorReadZeroBytesOrg         170
#define nmCompressErrorTreeTooBig               171
#define nmCompressErrorMatchSizeFail            172
#define nmSignatureInvalidAlert                 173
#define nmLicenseIsInvalid                      174
#define nmDeactHotFixError                      175
#define nmUnknownDecompressErrorFN              176
#define nmInsufficientRAMToDecompressFN         177
#define nmDecompressUnderFreePercentage         178
#define nmNegPktTriedLargeBuffer                179
#define nmLoginDisabledByConsole                180
#define nmLoginEnabledByConsole                 181
#define nmGrwStkNotAvail                        182
#define nmLicenseFileIsMissing                  183
#define nmFailedToDeletedMigratedFile           184
#define nmNoMemForAuditing                      185
#define nmAuditFileWriteError                   186
#define nmAuditFileFull                         187
#define nmAuditFileThresholdOverflow            188
#define nmCompressErrorReadZeroBytesInt         189
#define nmEASpaceLimit                          190
#define nmThreadAreaNotEmpty                    191
#define nmErrMovingLogToMSEngine                192
#define nmFaultInConsoleCmdHandler              193
#define nmServerToServerComLinkActivated        194
#define nmServerToServerComLinkFailure          195
#define nmServerToServerComLinkDeact            196
#define nmOtherServerAttemptedToSync            197
#define nmServerToServerComLinkBrokeOK          198
#define nmServerSyncStartingIAmSecondary        199
#define nmBadSvrInitMsgFromOtherSvr             200
#define nmSvrToSvrCommLinkInitFailed            201
#define nmFailedDuringSyncWithReason            202
#define nmCommDrvLdDuringActivateWait           203
#define nmErrWritingStatusDump                  204
#define nmComDrvFailureOnPrimary                205
#define nmComDrvFailureOnSecondary              206
#define nmErrFinishingGenStatusDump             207
#define nmSFTIIWhatToDoWithReasonString         208
#define nmSFTIIErrorUnexpected                  209
#define nmSyncErrFromCustomServerNLM            210
#define nmSvrLinkHasPluggedPacket               211
#define nmSvrToBeRevived                        212
#define nmServersAreSyncPri                     213
#define nmSvrCantRouteIPXSec                    214
#define nmSrvIPXRouteInfoSec                    215
#define nmErrGivingRAMtoMS                      216
#define nmMoreRAMgivenToMS                      217
#define nmServersAreSyncSec                     218
#define nmSvrCantRouteIPXPri                    219
#define nmSrvIPXRouteInfoPri                    220
#define nmPriSvrFailedButSecDown                221
#define nmPriSvrFailedNewPri                    222
#define nmNumMemSegsExceedLimit                 223
#define nmNumScreenExceedsLimit                 224
#define nmIOVersionMismatch                     225
#define nmOtherSvrProtectLvlNoMatch             226
#define nmOtherSvrScrAddrMismatch               227
#define nmIOEngNotAtSameAddr                    228
#define nmBothSvrHaveMSEng                      229
#define nmNoMSEngOnServers                      230
#define nmSecSvrMissingRAM                      231
#define nmBothSrvHaveSameIPXAddr                232
#define nmIOEngIPXAddrMatchMSEng                233
#define nmIOEngsMismatchRxSizes                 234
#define nmIOEngsHaveSameName                    235
#define nmNoMemForIOEngName                     236
#define nmSrvToSvrLinkBeginSync                 237
#define nmMSEngActivated                        238
#define nmMSEngActNowSyncOther                  239
#define nmIOtoMSComMisMatchUnload               240
#define nmSFTIIIOutOfMsgCodes                   241
#define nmErrXferDumpToSystem                   242
#define nmFailureChkPrimary                     243
#define nmNoMemForOtherIOEngScr                 244
#define nmErrStarting2ndProc                    245
#define nmSrvFailureMsg                         246
#define nmSecIOEngSupModNotLd                   247
#define nmMSLBdNumHasConn                       248
#define nmSecSvrLANIsBetter                     249
#define nmIPXrtnStatusPckts                     250
#define nmIPXnotRtnStatChkPckts                 251
#define nmIPXnotRtnStatLANJam                   252
#define nmFailReasonByOtherSrv                  253
#define nmIPXMayBeTooSlowForSecSrv              254
#define nmIPXToOtherSrvTooManyHops              255
#define nmIPXappearsDown                        256
#define nmIPXFoundRouteToOtherSrv               257
#define nmIPXLostRoute                          258
#define nmSecSrvGoingToDie                      259
#define nmPriSrcDyingTimerStart                 260
#define nmPriSrvDying                           261
#define nmIPXInternetIsJammed                   262
#define nmIPXNewRouteToSecSvr                   263
#define nmSrvsSyncing                           264
#define nmFSHookRegistered                      265
#define nmFSHookDeRegistered                    266
#define nmIOEngCantBorrowMemory                 267
#define nmDecompressNoCompressionOnVolume       268
#define nmMkProcessUsingTooSmallStk             269
#define nmQueueEventReportNoMemory              270
#define nmServerPartMirrorNotSync               271
#define nmStaWithoutRightsConsoleRPC            272
#define nmAuditOverflowFileThreshold            273
#define nmAuditOverflowFileFull                 274
#define nmSwitchStacksGrwStk                    275
#define nmConsoleCommandProcRestarted           276
#define nmGrowableStackGrew                     278
#define nmOtherSvrIOLogSpaceNoMatch             279
#define nmDFSLogicalStackRead                   280
#define nmDFSLogicalStackWrite                  281
#define nmSecureEraseFailure                    282
#define nmDropBadPktBurstConn                   283
#define nmOutOfIPXSockets                       284
#define nmVolumeObjectIDChanged                 285
#define nmAbendRecovery                         286
#define nmOpLockTimeout                         287
#define nmAbendRecovered                        288

/* starting with NetWare 5... */
#define  nmUnknownSetCmd                        289
#define  nmAddressSpaceProtectionFault          290
#define  nmAddressSpaceFailedToRestart          291
#define  nmAddressSpaceRestarted                292
#define  nmCorruptMemoryNodeDetected            293
#define  nmAddressSpaceCleanupFailure           294
#define  nmInvalidParameter                     295
#define  nmInvalidObjectHandle                  296
#define  nmNullPointer                          297
#define  nmVolDmtMedDmt                         298
#define  nmVolDmtmedChgd                        299
#define  nmAccDelByUsrActConn                   300
#define  nmResourcesRelErr                      301
#define  nmDemoVersion                          302
#define  nmDemoVersionTooLong                   303
#define  nmLicenseReSellerFileIsMissing         304
#define  nmLicenseUpgradeIsMissing              305
#define  nmLicenseVersionInvalid                306
#define  nmLicenseProductInvalid                307
#define  nmLicenseNoMoreFiles                   308
#define  nmLicensePIDInvalid                    309
#define  nmLicenseContentInalid                 310
#define  nmLicenseBadUpgrade                    311
#define  nmLicensePrevMaxConnMisMatch           312
#define  nmLicenseContentResellerBad            313
#define  nmLicenseSNMisMatch                    314
#define  nmLicenseUIDMisMatch                   315
#define  nmLicenseOpenError                     316
#define  nmLicenseCompanionErr                  317
#define  nmLicenseSNUpgradeMisMatch             318
#define  nmLicenseUnableToRemMSL                319
#define  nmLicenseUnableToRemULF                320
#define  nmLicenseUnableToRemRLF                321
#define  nmLicenseUnableToGetFileSize           322
#define  nmLicenseUnkLicenseType                323
#define  nmLicenseReadErr                       324
#define  nmLicenseFileSizeMisMatch              325
#define  nmLicenseDupServerLic                  326
#define  nmLicenseNeedUpgrade                   327
#define  nmLicenseMirrorNeedUpgrade             328
#define  nmLicenseDupLicDiscovered              329
#define  nmLicenseDupLicDiscoveredDel           330
#define  nmLicenseCpyRightViolated              331
#define  nmLicenseExpired                       332
#define  nmVolDmtDevMedChgd                     333
#define  nmVolDmtDevMedDmt                      334
#define  nmInsMediaAckDS                        335
#define  nmInsMediaAckMag                       336
#define  nmInsMediaAbortedDS                    337
#define  nmInsMediaAbortedMag                   338
#define  nmRemMediaAckDS                        339
#define  nmRemMediaAckMag                       340
#define  nmRemMediaAbortDS                      341
#define  nmRemMediaAbortMag                     342
#define  nmInsMediaIntoDS                       343
#define  nmInsMediaIntoMag                      344
#define  nmRemMediaFromDS                       345
#define  nmRemMediaFromMag                      346
#define  nmServAddr                             347
#define  nmSwapInError                          348
#define  nmSwapOutError                         349
#define  nmAveragePageInThresholdExceeded       350
#define  nmIllegalRequest                       351
#define  nmTTSThrottleDelayError                352
#define  nmTTSLackOfResourcesError              353
#define  nmTTSLackOfResourcesNoReason           354
#define  nmDelayedWTDNotRunning                 355
#define  nmInvalidCharacterInName               356

/* starting with NetWare 6... */
#define  nmMPKBadThreadState                    357
#define  nmPoolSeriousError                     358
#define  nmPoolSeriousReadError                 359
#define  nmVolSeriousError                      360
#define  nmVolSeriousReadError                  361
#define  nmVolDeactSeriousIOError               362
#define  nmVolDeactSeriousNonIOError            363
#define  nmPoolDeactSeriousIOError              364
#define  nmPoolDeactSeriousNonIOError           365
#define  nmTaskZeroCheck                        366


/* values for 'alertLocus' in EventNetWareAlertStruct_t... */
#define LOCUS_UNKNOWN               0
#define LOCUS_MEMORY                1
#define LOCUS_FILESYSTEM            2
#define LOCUS_DISKS                 3
#define LOCUS_LANBOARDS             4
#define LOCUS_COMSTACKS             5
#define LOCUS_TTS                   7
#define LOCUS_BINDERY               8
#define LOCUS_STATION               9
#define LOCUS_ROUTER                10
#define LOCUS_LOCKS                 11
#define LOCUS_KERNEL                12
#define LOCUS_UPS                   13
#define LOCUS_SERVICE_PROTOCOL      14
#define LOCUS_SFT_III               15
#define LOCUS_RESOURCE_TRACKING     16
#define LOCUS_NLM                   17
#define LOCUS_OS_INFORMATION        18
#define LOCUS_CACHE                 19

/* values for 'alertClass' in EventNetWareAlertStruct_t... */
#define CLASS_UNKNOWN               0
#define CLASS_OUT_OF_RESOURCE       1
#define CLASS_TEMP_SITUATION        2
#define CLASS_AUTHORIZATION_FAILURE 3
#define CLASS_INTERNAL_ERROR        4
#define CLASS_HARDWARE_FAILURE      5
#define CLASS_SYSTEM_FAILURE        6
#define CLASS_REQUEST_ERROR         7
#define CLASS_NOT_FOUND             8
#define CLASS_BAD_FORMAT            9
#define CLASS_LOCKED                10
#define CLASS_MEDIA_FAILURE         11
#define CLASS_ITEM_EXISTS           12
#define CLASS_STATION_FAILURE       13
#define CLASS_LIMIT_EXCEEDED        14
#define CLASS_CONFIGURATION_ERROR   15
#define CLASS_LIMIT_ALMOST_EXCEEDED 16
#define CLASS_SECURITY_AUDIT_INFO   17
#define CLASS_DISK_INFORMATION      18
#define CLASS_GENERAL_INFORMATION   19
#define CLASS_FILE_COMPRESSION      20
#define CLASS_PROTECTION_VIOLATION  21
#define CLASS_VIRTUAL_MEMORY        22             

/* values for 'alertSeverity' in EventNetWareAlertStruct_t... */
#define SEVERITY_INFORMATIONAL       0 /* counters reached thresholds         */
#define SEVERITY_WARNING             1 /* config errors, etc. no damage       */
#define SEVERITY_RECOVERABLE         2 /* hot fix disk, etc. worked around    */
#define SEVERITY_CRITICAL            3 /* disk mirror failure, etc. fix-up attempted */
#define SEVERITY_FATAL               4 /* resource fatally affected--shut down*/
#define SEVERITY_OPERATION_ABORTED   5 /* cannot complete--result unknown     */
#define SEVERITY_NONOS_UNRECOVERABLE 6 /* cannot complete--will not affect OS */

/* values for 'targetNotificationBits' in EventNetWareAlertStruct_t... */
#define NOTIFY_CONNECTION_BIT      0x00000001
#define NOTIFY_EVERYONE_BIT        0x00000002
#define NOTIFY_ERROR_LOG_BIT       0x00000004
#define NOTIFY_CONSOLE_BIT         0x00000008
#define NOTIFY_QUEUE_MESSAGE       0x10000000 /* use if alert to be queued */
#define NOTIFY_DONT_NOTIFY_NMAGENT 0x80000000


/* prototypes... */
typedef int    event_handle_t;
typedef void (*Report_t)( void *parm, void *userParm );
typedef int  (*Warn_t)( void *printf, void *parm, void *userParm );

event_handle_t RegisterForEventNotification( rtag_t rtag, int type,
                  int priority, Warn_t warn, Report_t report, void *userParm );
int            UnRegisterEventNotification( event_handle_t handle );
int            CanEventBlock( int type );
int            CheckForRegisteredEvent( int type );
int            EventCheck( int type, void *printf, void *parm );
int            EventReport( int type, void *parm );

#include <poppack.h>

#ifdef __cplusplus
}
#endif

#endif
