#ifndef __sys_mman_h__
#define __sys_mman_h__
/*============================================================================
=  Novell Software Development Kit
=
=  Copyright (C) 1999-2002 Novell, Inc. All Rights Reserved.
=
=  This work is subject to U.S. and international copyright laws and treaties.
=  Use and redistribution of this work is subject  to  the  license  agreement
=  accompanying  the  software  development kit (SDK) that contains this work.
=  However, no part of this work may be revised and/or  modified  without  the
=  prior  written consent of Novell, Inc. Any use or exploitation of this work
=  without authorization could subject the perpetrator to criminal  and  civil
=  liability. 
=
=  Source(s): ISO/IEC (POSIX) 9845:1996, BSD 4.3
=
=  sys/mman.h
==============================================================================
*/
#include <stddef.h>
#include <limits.h>

/* return value of mmap() in case of error... */
#define MAP_FAILED      ((void *) -1)

/* 'flags' values for mlockall()... */
#define MCL_CURRENT     0x00  /* lock all pages currently mapped           */
#define MCL_FUTURE      0x01  /* lock all pages currently mapped in future */

/* 'protection' values for mmap()... */
#define PROT_NONE       0     /* data cannot be accessed                   */
#define PROT_READ       1     /* data can be read                          */
#define PROT_WRITE      2     /* data can be written                       */
#define PROT_EXEC       3     /* data can be executed                      */

/* 'flags' values for mmap()... */
#define MAP_SHARED      0x01  /* changes are shared                        */
#define MAP_PRIVATE     0x02  /* changes are private                       */
#define MAP_FIXED       0x04  /* interpret 'addr' exactly                  */
#define MAP_NORESERVE   0x08  /* don't reserve swap space (not POSIX)      */

/* 'flags' values for msync()... */
#define MS_ASYNC        0x01  /* perform asynchronous writes               */
#define MS_SYNC         0x02  /* perform synchronous writes                */
#define MS_INVALIDATE   0x04  /* invalidate cached data                    */

/* 'advice' to madvice()... */
#define MADV_NORMAL	   0x00  /* no further special treatment              */
#define MADV_RANDOM	   0x01  /* expect random page references             */
#define MADV_SEQUENTIAL 0x02  /* expect sequential page references         */
#define MADV_WILLNEED	0x04  /* will need these pages                     */
#define MADV_DONTNEED	0x08  /* don't need these pages                    */

#ifdef __cplusplus
extern "C"
{
#endif

void *mmap      ( void *addr, size_t len, int prot, int flags, int fildes,
                    off_t offset);
void *mmap64    ( void *addr, size_t len, int prot, int flags, int fildes,
                    off64_t offset);
int   munmap    ( void *addr, size_t len );
int   mlock     ( const void *addr, size_t len );
int   mlockall  ( int flags );
int   munlock   ( const void *addr, size_t len );
int   munlockall( void );
int   msync     ( void *addr, size_t len, int flags );
int   mprotect  ( const void *addr, size_t len, int prot );
int   mincore   ( void *start, size_t len, unsigned char *vec );
int   madvise   ( void *addr, size_t len, int advice );

int   shm_open  ( const char *name, int oflag, mode_t mode );
int   shm_unlink( const char *name );

#ifdef __cplusplus
}
#endif

#endif
