#ifndef __fenv_h__
#define __fenv_h__
/*============================================================================
=  Novell Software Development Kit
=
=  Copyright (C) 1999-2002 Novell, Inc. All Rights Reserved.
=
=  This work is subject to U.S. and international copyright laws and treaties.
=  Use and redistribution of this work is subject  to  the  license  agreement
=  accompanying  the  software  development kit (SDK) that contains this work.
=  However, no part of this work may be revised and/or  modified  without  the
=  prior  written consent of Novell, Inc. Any use or exploitation of this work
=  without authorization could subject the perpetrator to criminal  and  civil
=  liability. 
=
=  Source(s): ISO/IEC (ANSI) 9899:1999
=
=  fenv.h
==============================================================================
*/
#include <stddef.h>
#include <float.h>

/* these interfaces not presently supported! */
#define _MAX_FPFLAGS    8

/* floating-point exception bits for 'excepts' argument */
#define FE_DIVBYZERO    0x00000001
#define FE_INEXACT      0x00000002
#define FE_INVALID      0x00000004
#define FE_OVERFLOW     0x00000008
#define FE_UNDERFLOW    0x00000010
#define FE_ALL_EXCEPT   0x00000020
#define FE_DOWNWARD     0x00000040
#define FE_TONEAREST    0x00000080
#define FE_TOWARDZERO   0x00000100
#define FE_UPWARD       0x00000200
#define FE_DFL_ENV      0x00000400


#include <pshpack1.h>

typedef unsigned int fexcept_t[_MAX_FPFLAGS];

typedef struct
{
   int         excepts;
   fexcept_t   flagp;
} fenv_t;

#include <poppack.h>

#ifdef __cplusplus
extern "C"
{
#endif

/* not presently supported... */
void  feclearexcept    ( int excepts );
void  fegetexceptflag  ( fexcept_t *flagp, int excepts );
void  feraiseexceptflag( const fexcept_t *flagp, int excepts );
void  fesetexceptflag  ( const fexcept_t *flagp, int excepts );
int   fetestexcept     ( int excepts );
int   fegetround       ( int round );
int   fesetround       ( void );
int   fegetenv         ( fenv_t *envp );
int   feholdexcept     ( fenv_t *envp );
void  fesetenv         ( const fenv_t *envp );
void  feupdateenv      ( const fenv_t *envp );


#ifdef __cplusplus
}
#endif


#endif
