#ifndef __fnmatch_h__
#define __fnmatch_h__
/*============================================================================
=  Novell Software Development Kit
=
=  Copyright (C) 1999-2002 Novell, Inc. All Rights Reserved.
=
=  This work is subject to U.S. and international copyright laws and treaties.
=  Use and redistribution of this work is subject  to  the  license  agreement
=  accompanying  the  software  development kit (SDK) that contains this work.
=  However, no part of this work may be revised and/or  modified  without  the
=  prior  written consent of Novell, Inc. Any use or exploitation of this work
=  without authorization could subject the perpetrator to criminal  and  civil
=  liability. 
=
=  Source(s): Single UNIX Specification
=
=  fnmatch.h
==============================================================================
*/
#include <stddef.h>

#define FNM_NOMATCH  (-1) /* string fails to match pattern */

/* values for field 'flags'... */
#define FNM_NOSYS    0x01 /* reserved (unused)                              */
#define FNM_PATHNAME 0x02 /* slash in string must match in pattern          */
#define FNM_PERIOD   0x04 /* leading period in string must match in pattern */
#define FNM_NOESCAPE 0x08 /* disable backslash escaping                     */


#ifdef __cplusplus
extern "C" {
#endif

int fnmatch( const char *pattern, const char *string, int flags );


#ifdef __cplusplus
}
#endif

#endif
