#ifndef __fsio_h__
#define __fsio_h__
/*============================================================================
=  Novell Software Development Kit
=
=  Copyright (C) 1999-2002 Novell, Inc. All Rights Reserved.
=
=  This work is subject to U.S. and international copyright laws and treaties.
=  Use and redistribution of this work is subject  to  the  license  agreement
=  accompanying  the  software  development kit (SDK) that contains this work.
=  However, no part of this work may be revised and/or  modified  without  the
=  prior  written consent of Novell, Inc. Any use or exploitation of this work
=  without authorization could subject the perpetrator to criminal  and  civil
=  liability.
=
=  Source(s): Novell Header
=
=  fsio.h
==============================================================================
*/
#include <stddef.h>
#include <unistd.h>

#include <nks/fsio.h>

/* for getcwdpath(), get NKS context for current working directory... */
#define CTX_ACTUAL_CWD 0x01

/* Faster, better when getstat() or fgetstat() used with request bit map... */
#define ST_NONE        0x00000000
#define ST_FLAGS_BIT   0x00000001
#define ST_MODE_BIT    0x00000002
#define ST_GEN_BIT     0x00000004
#define ST_INO_BIT     0x00000008
#define ST_DEV_BIT     0x00000010
#define ST_RDEV_BIT    0x00000020
#define ST_SIZE_BIT    0x00000040
#define ST_BLOCKS_BIT  0x00000080
#define ST_BLKSIZE_BIT 0x00000100
#define ST_NLINK_BIT   0x00000200
#define ST_UID_BIT     0x00000400
#define ST_GID_BIT     0x00000800
#define ST_BID_BIT     0x00001000
#define ST_MID_BIT     0x00002000
#define ST_ATIME_BIT   0x00004000
#define ST_MTIME_BIT   0x00008000
#define ST_CTIME_BIT   0x00010000
#define ST_BTIME_BIT   0x00020000
#define ST_RIGHTS_BIT  0x00040000   /* (NOT returned by normal stat call)    */
#define ST_NAME_BIT    0x00080000   /* (NOT returned by normal stat call)    */

#define ST_STAT_BITS   0x0003FFFF   /* bits for normal stat call             */
 
/* path analysis/parsing 'type' and 'flags' arguments for [de]construct()    */
#define PATH_UNDEF      0x00000000
#define PATH_DOS        PATH_UNDEF  /* indicates potential DOS path          */
#define PATH_UNC        0x00000001  /* double slash found at beginning       */
#define PATH_UNIX       0x00000002  /* forward slashes only                  */
#define PATH_NETWARE    0x00000004  /* slash and colon followed by slashes   */
#define PATH_MACINTOSH  0x00000008  /* only colons                           */
#define PATH_ROOTED     0x00000010  /* starts with delimiter                 */
#define PATH_VOLROOTED  0x00000020  /* volume plus colon appears             */
#define PATH_EXTENSION  0x00000040  /* contains period                       */
#define PATH_HIERARCHY  0x00000080  /* at least one subdirectory element     */
#define PATH_SHORTNAME  0x00000100  /* 8.3 names only                        */
#define PATH_LONGNAME   0x00000200  /* at least one element greater than 8.3 */
#define PATH_ENDED      0x00000400  /* ends in delimiter                     */
#define PATH_DOSDRIVE   0x00001000  /* single-letter drive, colon and path   */
#define PATH_MIXEDCASE  0x00002000  /* at least one element in mixed case    */
#define PATH_DOTS       0x00004000  /* path contains dots                    */
#define PATH_SLASH      0x00008000  /* path contains a slash                 */
#define PATH_BACKSLASH  0x00010000  /* path contains a backslash             */
#define PATH_COLON      0x00020000  /* path contains a colon                 */
#define PATH_ILLEGAL    0x80000000  /* illegal character or combination      */
#define PATH_MIXED      (PATH_SHORT|PATH_LONG)

#ifdef __cplusplus
extern "C"
{
#endif


/* extensions of unistd.h path parsing functions... */
int deconstruct( const char *path, char *server, char *volume, char *directory,
                     char *name, char *extension, int *elements, int *flags );
int construct  ( char *path, char *server, char *volume, char *directory,
                     char *name, char *extension, int flags );

/* extensions of client.h identity functions... */
int get_identity( NXPathCtx_t pathctx, int *identity );

/* extensions of unistd.h current working directory I/O functions... */
char *getcwdpath( char *buf, NXPathCtx_t *pathCtx, unsigned long flags );
int   chdir2    ( const char *path );
int   setcwd    ( NXPathCtx_t pathCtx );
int   setcwd2   ( NXPathCtx_t pathCtx );

/* extensions of unistd.h file I/O functions... */
int   eof       ( int fildes );
off_t tell      ( int fildes );

/* extensions of sys/stat.h functions... */
int   fgetstat  ( int fildes, struct stat *buf, unsigned long requestmap );
int   getstat   ( NXPathCtx_t ctx, const char *path, struct stat *buf,
                     unsigned long requestmap );

int   _fildes_from_nsskey( uint64_t key, int oflag );

#ifdef __cplusplus
}
#endif

/* equates to move between NKS file handles and POSIX descriptors... */
#define _fildes(fh)  ((int) fh)
#define _fhandle(fd) ((NXHandle_t) fd)

/* derivation of POSIX descriptor from NSS open file key... */
#define _nss2fildes(ky,f)   _fildes_from_nsskey(k,f)


#endif
