#ifndef __getopt_h__
#define __getopt_h__
/*============================================================================
=  Novell Software Development Kit
=
=  Copyright (C) 1999-2002 Novell, Inc. All Rights Reserved.
=
=  This work is subject to U.S. and international copyright laws and treaties.
=  Use and redistribution of this work is subject  to  the  license  agreement
=  accompanying  the  software  development kit (SDK) that contains this work.
=  However, no part of this work may be revised and/or  modified  without  the
=  prior  written consent of Novell, Inc. Any use or exploitation of this work
=  without authorization could subject the perpetrator to criminal  and  civil
=  liability. 
=
=  Source(s): GNU and Linux-inspired header
=
=  getopt.h
==============================================================================
*/
#include <unistd.h>

/* values for 'has_arg'... */
#define no_argument        0
#define required_argument  1
#define optional_argument  2


/* definition for getopt_long() and getopt_long_only()... */
struct option
{
	const char *name;
	int         has_arg;
	int        *flag;
	int         val;
};

#ifdef __cplusplus
extern "C"
{
#endif
int getopt_long     ( int argc, char * const argv[], const char *optstring,
                        const struct option *longopts, int *longindex );
int getopt_long_only( int argc, char * const argv[], const char *optstring,
                        const struct option *longopts, int *longindex );

#ifdef __cplusplus
}
#endif

#endif
