#ifndef __langinfo_h__
#define __langinfo_h__
/*============================================================================
=  Novell Software Development Kit
=
=  Copyright (C) 1999-2003 Novell, Inc. All Rights Reserved.
=
=  This work is subject to U.S. and international copyright laws and treaties.
=  Use and redistribution of this work is subject  to  the  license  agreement
=  accompanying  the  software  development kit (SDK) that contains this work.
=  However, no part of this work may be revised and/or  modified  without  the
=  prior  written consent of Novell, Inc. Any use or exploitation of this work
=  without authorization could subject the perpetrator to criminal  and  civil
=  liability.
=
=  Source(s): IEEE Std 1003.1-2001; Single UNIX Specification
=
=  langinfo.h
==============================================================================
*/
#include <nl_types.h>

#define DAY_1       1  /* Sunday                                          */
#define DAY_2       2  /* Monday                                          */
#define DAY_3       3  /* Tuesday                                         */
#define DAY_4       4  /* Wednesday                                       */
#define DAY_5       5  /* Thursday                                        */
#define DAY_6       6  /* Friday                                          */
#define DAY_7       7  /* Saturday                                        */

#define ABDAY_1     8  /* Sun                                             */
#define ABDAY_2     9  /* Mon                                             */
#define ABDAY_3     10 /* Tue                                             */
#define ABDAY_4     11 /* Wed                                             */
#define ABDAY_5     12 /* Thu                                             */
#define ABDAY_6     13 /* Fri                                             */
#define ABDAY_7     14 /* Sat                                             */

#define MON_1       15 /* January                                         */
#define MON_2       16 /* February                                        */
#define MON_3       17 /* March                                           */
#define MON_4       18 /* April                                           */
#define MON_5       19 /* May                                             */
#define MON_6       20 /* June                                            */
#define MON_7       21 /* July                                            */
#define MON_8       22 /* August                                          */
#define MON_9       23 /* September                                       */
#define MON_10      24 /* October                                         */
#define MON_11      25 /* November                                        */
#define MON_12      26 /* December                                        */

#define ABMON_1     27 /* Jan                                             */
#define ABMON_2     28 /* Feb                                             */
#define ABMON_3     29 /* Mar                                             */
#define ABMON_4     30 /* Apr                                             */
#define ABMON_5     31 /* May                                             */
#define ABMON_6     32 /* Jun                                             */
#define ABMON_7     33 /* Jul                                             */
#define ABMON_8     34 /* Aug                                             */
#define ABMON_9     35 /* Sep                                             */
#define ABMON_10    36 /* Oct                                             */
#define ABMON_11    37 /* Nov                                             */
#define ABMON_12    38 /* Dec                                             */

#define RADIXCHAR   39 /* radix character                 (not supported) */
#define THOUSEP     40 /* separator for thousand                          */
#define CRNCYSTR    43 /* currency symbol                                 */

#define D_T_FMT     44 /* string for formatting date and time             */
#define D_FMT       45 /* date format                                     */
#define T_FMT       46 /* time format                                     */
#define AM_STR      47 /* am string                                       */
#define PM_STR      48 /* pm string                                       */

#define CODESET     49 /* code set name                                   */
#define T_FMT_AMPM  50 /* a.m. or p.m. time format string (not supported) */
#define ERA         51 /* era description segments        (not supported) */
#define ERA_D_FMT   52 /* era date format string          (not supported) */
#define ERA_D_T_FMT 53 /* era date and time format string (not supported) */
#define ERA_T_FMT   54 /* era time format string          (not supported) */
#define ALT_DIGITS  55 /* alternative symbols for digits  (not supported) */

#define _MAXSTRMSG  57 /* maximum number of strings in langinfo           */


#ifdef __cplusplus
extern "C" {
#endif

char *nl_langinfo( nl_item item );


#ifdef __cplusplus
}
#endif

#endif
