#ifndef __library_h__
#define __library_h__
/*============================================================================
=  Novell Software Development Kit
=
=  Copyright (C) 1999-2002 Novell, Inc. All Rights Reserved.
=
=  This work is subject to U.S. and international copyright laws and treaties.
=  Use and redistribution of this work is subject  to  the  license  agreement
=  accompanying  the  software  development kit (SDK) that contains this work.
=  However, no part of this work may be revised and/or  modified  without  the
=  prior  written consent of Novell, Inc. Any use or exploitation of this work
=  without authorization could subject the perpetrator to criminal  and  civil
=  liability.
=
=  Source(s): Novell Header
=
=  library.h
==============================================================================
*/
#include <errno.h>
#include <stddef.h>
#include <sys/utsname.h>

/* return flags for get_app_type()... */
#define LIBRARY_UNKNOWN      0x01  /* thread has default library context     */
#define LIBRARY_LIBC         0x02  /* thread has specific NKS/LibC context   */
#define LIBRARY_CLIB         0x04  /* thread has CLib context                */
#define LIBRARY_JAVA         0x08  /* thread belongs to Java Virtual Machine */

/* (request) bits for uname2()... */
#define UNAME_NLMMODULE      0x00000001 /* nlmmodule (if it can be gotten)   */
#define UNAME_POSIXFIELDS    0x00000002 /* POSIX fields (see sys/utsname.h)  */
#define UNAME_LIBVERSION     0x00000004 /* libminor/major/revision           */
#define UNAME_FSVERSION      0x00000008 /* major/minor/revision/service pack */
#define UNAME_NETWAREVERSION 0x00000010 /* netware_major/minor/revision      */
#define UNAME_SERVERNAME     0x00000020 /* servername                        */
#define UNAME_CLUSTERNAME    0x00000040 /* clustername                       */
#define UNAME_LANGINFO       0x00000080 /* languagename/alt/id/altid/codepage*/
#define UNAME_NLMMESSAGES    0x00000100 /* nlmmessagecount/table             */
#define UNAME_NLMVERSION     0x00000200 /* nlmmajor/minor/revision           */
#define UNAME_NLMINFO        0x00000400 /* nlmtimer/loadflags                */
#define UNAME_NLMNAME        0x00000800 /* nlmname                           */
#define UNAME_NLMLOADPATH    0x00001000 /* nlmloadpath                       */
#define UNAME_NLMCOPYRIGHT   0x00002000 /* nlmcopyright                      */
#define UNAME_NLMDESCRIPTION 0x00004000 /* nlmdescription                    */
#define UNAME_NLMCOMMANDLINE 0x00008000 /* nlmcommandline                    */
#define UNAME_NDSTREENAME    0x00010000 /* treename                          */
#define UNAME_NLMCODEANDDATA 0x00020000 /* code and datastart/-length        */

#ifndef __RTAG_T
# define __RTAG_T
typedef void *rtag_t;
#endif

#ifndef __ADDRSP_T
# define __ADDRSP_T
typedef void *addrsp_t;
#endif


#ifdef __cplusplus
extern "C" {
#endif

/* traditional NetWare solution for libraries... */
void *get_app_data       ( int lib_id );
int   get_app_type       ( void );
int   register_library   ( int (*cleanupFunc)( void *data_area ));
int   register_destructor( int libid, int (*cleanupFunc)( void *data_area ));
int   set_app_data       ( int lib_id, void *data_area );
int   unregister_library ( int lib_id );

/* more prototypes for library creators and others... */
int       cleardontunloadflag ( void *handle );
void     *findnlmhandle       ( const char *name, addrsp_t space );
addrsp_t  getaddressspace     ( void );
char     *getaddressspacename ( addrsp_t space, char *name );
rtag_t    getallocresourcetag ( void );
void     *getnlmhandle        ( void );
char     *getnlmname          ( void *handle, char *name );
char     *getnlmloadpath      ( char *loadpath );
void     *library_calloc      ( void *handle, size_t size, size_t count );
void      library_free        ( void *addr );
void     *library_malloc      ( void *handle, size_t size );
size_t    library_msize       ( void *addr );
void     *library_realloc     ( void *handle, void *old, size_t size );
int       nlmisloadedprotected( void );
int       setdontunloadflag   ( void *handle );
int       uname2              ( void *handle, struct utsname *info,
                                 unsigned long bits );
int       validateaddressrange( const void *addr, size_t bytes );
void     *verifynlmhandle     ( void *handle );

#ifdef __cplusplus
}
#endif

/* name-logical additions to library_malloc... */
#define library_free(addr)   free(addr)
#define library_msize(addr)  msize(addr)


#endif
