#ifndef __limits_h__
#define __limits_h__
/*============================================================================
=  Novell Software Development Kit
=
=  Copyright (C) 1999-2002 Novell, Inc. All Rights Reserved.
=
=  This work is subject to U.S. and international copyright laws and treaties.
=  Use and redistribution of this work is subject  to  the  license  agreement
=  accompanying  the  software  development kit (SDK) that contains this work.
=  However, no part of this work may be revised and/or  modified  without  the
=  prior  written consent of Novell, Inc. Any use or exploitation of this work
=  without authorization could subject the perpetrator to criminal  and  civil
=  liability. 
=
=  Source(s): ISO/IEC (ANSI) 9899:1999
=
=  limits.h
==============================================================================
*/
#define PAGESIZE   4096              /* granularity of memory mapping et al. */

#define CHAR_BIT   8                 /* max number of bits in a 'char'       */
#define SCHAR_MIN  (-128)            /* min value of a 'signed char'         */
#define SCHAR_MAX  127               /* max value of a 'signed char'         */
#define UCHAR_MAX  255               /* max value of an 'unsigned char'      */

#if '\xFF' < 0
# define CHAR_MIN  SCHAR_MIN         /* min value of a 'char'                */
# define CHAR_MAX  SCHAR_MAX         /* max value of a 'char'                */
#else
# define CHAR_MIN  0
# define CHAR_MAX  UCHAR_MAX
#endif

#define MB_LEN_MAX 2                 /* max bytes in multibyte character     */

#define SHRT_MIN   (-32768)          /* min value of 'short int'             */
#define SHRT_MAX   32767             /* max value of 'short int'             */
#define USHRT_MAX  65535             /* max value of 'unsigned short int'    */
#define INT_MIN    LONG_MIN          /* min value of 'int'                   */
#define INT_MAX    LONG_MAX          /* max value of 'int'                   */
#define UINT_MAX   ULONG_MAX         /* max value of 'unsigned int'          */
#define LONG_MIN   (-2147483647-1)   /* min value of 'long int'              */
#define LONG_MAX   2147483647        /* max value of 'long int'              */
#define ULONG_MAX  4294967295        /* max value of 'unsigned long int'     */
#define LLONG_MIN  (-9223372036854775807-1)/* max value of 'long long'       */
#define LLONG_MAX  9223372036854775807/* max value of 'long long'            */
#define ULLONG_MAX 0xffffffffffffffff/* max value of 'unsigned long long'    */

#define PATH_MAX      511            /* max characters in file system path   */
#define NAME_MAX      255            /* max characters in file system name   */
#define TZNAME_MAX    8              /* max characters in time zone name     */
#define PIPE_BUF      65536          /* max bytes for atomic write to pipe   */
#define ENV_NAME_MAX  80             /* max len of environment variable name */

#define SSIZE_MIN     INT_MIN        /* max value storable in ssize_t object */
#define SSIZE_MAX     INT_MAX        /* max value storable in ssize_t object */

/* some limits wanted by POSIX... */
#define _POSIX_PATH_MAX    PATH_MAX
#define _POSIX_NAME_MAX    NAME_MAX
#define _POSIX_SSIZE_MAX   SSIZE_MAX
#define _POSIX_TZNAME_MAX  TZNAME_MAX

#endif
