#ifndef __locale_h__
#define __locale_h__
/*=============================================================================
=  Novell Software Development Kit
=
=  Copyright (C) 1999-2002 Novell, Inc. All Rights Reserved.
=
=  This work is subject to U.S. and international copyright laws and treaties.
=  Use and redistribution of this work is subject  to  the  license  agreement
=  accompanying  the  software  development kit (SDK) that contains this work.
=  However, no part of this work may be revised and/or  modified  without  the
=  prior  written consent of Novell, Inc. Any use or exploitation of this work
=  without authorization could subject the perpetrator to criminal  and  civil
=  liability. 
=
=  Source(s): ISO/IEC (ANSI) 9899:1990; Novell additions
=
=  locale.h
===============================================================================
*/
#include <stddef.h>

#define MAX_LOCNAME_LEN (31+1)/* for use with LC_ALL                         */


/* locale categories... */
#define LC_CTYPE     0        /* character classification (unsupported)      */
#define LC_COLLATE   1        /* the locale's collation table (unsupported)  */
#define LC_NUMERIC   2        /* the numeric part of struct lconv            */
#define LC_MONETARY  3        /* the monetary part of struct lconv           */
#define LC_TIME      4        /* the time and date part of struct lconv      */
#define LC_MESSAGES  5        /* new starting in NetWare v4.11 (unsupported) */
#define LC_ALL       6

#include <pshpack1.h>

struct lconv                  /* for the current locale...                   */
{
   int  country;              /* internal representations...                 */
   int  language;             /* ibid                                        */
   char name[8];              /* as returned from setlocale(LC_ALL, NULL)    */
   /* -------------------------- [Numeric Conventions] --------------------- */
   char decimal_point[4];     /* decimal point                               */
   char thousands_sep[4];     /* separator for digits left of decimal        */
   char grouping[4];          /* digit grouping size                         */
   /* -------------------------- [Monetary Conventions] -------------------- */
   char currency_symbol[4];   /* currency symbol                             */
   char mon_decimal_point[4]; /* decimal point                               */
   char mon_thousands_sep[4]; /* separator for digits left of decimal        */
   char mon_grouping[8];      /* digit grouping sizes                        */
   char positive_sign[4];     /* string indicating positive quantities       */
   char negative_sign[4];     /* string indicating negative quantities       */
   char frac_digits;          /* count of digits right of decimal            */
                              /* for positive monetary quantities:           */
   char p_cs_precedes;        /*   currency symbol precedes quantity         */
   char p_sep_by_space;       /*   currency symbol separated by blank        */
   char p_sign_posn;          /*   position of positive symbol               */
                              /* for negative monetary quantities:           */
   char n_cs_precedes;        /*   currency symbol precedes quantity         */
   char n_sep_by_space;       /*   currency symbol separated by blank        */
   char n_sign_posn;          /*   position of negative symbol               */
   char reserved;             /* (reserved for future use)                   */
   /* -------------------------- [International Monetary Conventions] ------ */
   char int_curr_symbol[15];  /* international currency symbol and separator */
   char int_frac_digits;      /* (international) digits right of decimal     */
   /* -------------------------- [Time and Date Conventions] --------------- */
   int  always_24;            /* always enforce 24-hour display (Boolean)    */
   char hour_sep[4];          /* hour and seconds separator                  */
   char hour_sans_sec_sep[4]; /* hour separator when no seconds displayed    */
   char date_sep[4];          /* month/day/year separator                    */
   char time_fmt[16];         /* hours:minutes:seconds format (hh:mm:ss)     */
   char date_fmt[16];         /* month/day/year format (mm/dd/yyyy)          */
   char full_date_fmt[32];    /* weekday, month, day and year format         */
   char ampm[32];             /* delimited string indicating am and pm       */
   char AMPM[32];             /* delimited string indicating AM and PM       */
   char days[160];            /* delimited string of day names               */
   char day_abbrevs[160];     /* delimited string of abbreviated day names   */
   char months[160];          /* delimited string of month names             */
   char month_abbrevs[160];   /* delimited string of abbreviated month names */
};                            /* sizeof(struct lconv) == 0x360 (864.)        */

#include <poppack.h>

#ifdef __cplusplus
extern "C"
{
#endif

/* prototypes for functions standard and nonstandard... */
struct lconv *localeconv( void );
char         *setlocale( int, const char * );

#ifndef __ANSIC__
char         *derivelocale( const char *, const char *, char [MAX_LOCNAME_LEN]);
char         *setlocale_r( int, const char *, struct lconv *, char * );
#endif

#ifdef __cplusplus
}
#endif

#endif
