#ifndef __math_h__
#define __math_h__
/*============================================================================
=  Novell Software Development Kit
=
=  Copyright (C) 1999-2002 Novell, Inc. All Rights Reserved.
=
=  This work is subject to U.S. and international copyright laws and treaties.
=  Use and redistribution of this work is subject  to  the  license  agreement
=  accompanying  the  software  development kit (SDK) that contains this work.
=  However, no part of this work may be revised and/or  modified  without  the
=  prior  written consent of Novell, Inc. Any use or exploitation of this work
=  without authorization could subject the perpetrator to criminal  and  civil
=  liability.
=
=  Source(s): ISO/IEC (ANSI) 9899:1990, 1999; Novell additions
=
=  math.h
==============================================================================
*/
#include <stddef.h>


/* constants for type exception using matherr()      */
#define DOMAIN    1  /* argument domain error        */
#define SING      2  /* argument singularity         */
#define OVERFLOW  3  /* overflow range error         */
#define UNDERFLOW 4  /* underflow range error        */
#define TLOSS     5  /* total loss of significance   */
#define PLOSS     6  /* partial loss of significance */

#ifdef __cplusplus
# define __FP_EXCEPTION struct __fp_exception
# define __COMPLEX      struct __complex
#else
# define __FP_EXCEPTION struct exception
# define __COMPLEX      struct complex
#endif

#include <pshpack1.h>

/* for C++, __fp_exception; for C, exception */
__FP_EXCEPTION
{
   int    type;
   char   *name;
   double arg1;
   double arg2;
   double retval;
};

/* for C++, __complex; for C, complex */
__COMPLEX
{
   double real;
   double imag;
};

#include <poppack.h>

#ifdef __cplusplus
extern "C"
{
#endif

#ifdef IAPX386
extern /*const*/ float          ___nan_float;
extern /*const*/ float          ___huge_float;
extern /*const*/ double         ___huge_double;
extern /*const*/ double         ___huge_long_double;
#else
extern const float             *___nan_float( void );
extern const float             *___huge_float( void );
extern const double            *___huge_double( void );
extern const double            *___huge_long_double( void );

# define ___nan_float         (*___nan_float())
# define ___huge_float        (*___huge_float())
# define ___huge_double       (*___huge_double())
# define ___huge_long_double  (*___huge_long_double())
#endif


double   acos     ( double );
double   asin     ( double );
double   atan     ( double );
double   atan2    ( double, double );
double   cbrt     ( double );
double   ceil     ( double );
double   cos      ( double );
double   cosh     ( double );
double   exp      ( double );
double   fabs     ( double );
double   floor    ( double );
double   fmod     ( double, double );
double   frexp    ( double, int * );
double   hypot    ( double, double );
double   ldexp    ( double, int );
double   log      ( double );
double   log10    ( double );
double   modf     ( double, double * );
double   pow      ( double, double );
double   remainder( double, double );
double   rint     ( double );
double   sin      ( double );
double   sinh     ( double );
double   sqrt     ( double );
double   tan      ( double );
double   tanh     ( double );


#ifndef __ANSIC__
double   cabs     ( __COMPLEX );
double   j0       ( double );
double   j1       ( double );
double   jn       ( int, double );
double   y0       ( double );
double   y1       ( double );
double   yn       ( int, double );

int      matherr        ( __FP_EXCEPTION * );
int      matherr_handler( int (*)( __FP_EXCEPTION * ) );
#endif

int      ___fpclassify_f ( float );
int      ___fpclassify_d ( double );
int      ___fpclassify_ld( long double );
int      ___isfinite_f   ( float );
int      ___isfinite_d   ( double );
int      ___isfinite_ld  ( long double );
int      ___signbit_f    ( float );
int      ___signbit_d    ( double );
int      ___signbit_ld   ( long double );

#ifdef __cplusplus
}
#endif

#define HUGE_VAL        (+___huge_double)
#define HUGE_VALL       (+___huge_long_double)
#define HUGE_VALF       (+___huge_float)
#define INFINITY        HUGE_VALF
#define NAN             (+___nan_float)

#define FP_NAN          1  /* not a number    */
#define FP_INFINITE     2  /* + or - infinity */
#define FP_ZERO         3  /* + or - zero     */
#define FP_NORMAL       4  /* normal values   */
#define FP_SUBNORMAL    5  /* anormal values  */

#define isnormal(x)     (fpclassify(x) == FP_NORMAL)
#define isnan(x)        (fpclassify(x) == FP_NAN)
#define isinf(x)        (fpclassify(x) == FP_INFINITE)

#define fpclassify(x)   ((sizeof(x) == 8)                      \
                           ? ___fpclassify_d((double) (x))     \
                           : (sizeof(x) == 4)                  \
                              ? ___fpclassify_f((float) (x))   \
                              : ___fpclassify_ld((long double) (x)))

#define signbit(x)      ((sizeof(x) == 8)                      \
                           ? ___signbit_d((double) (x))        \
                           : (sizeof(x) == 4)                  \
                              ? ___signbit_f((float) (x))      \
                              : ___signbit_ld((long double) (x)))

#define isfinite(x)     ((sizeof(x) == 8)                      \
                           ? ___isfinite_d((double) (x))       \
                           : (sizeof(x) == 4)                  \
                              ? ___isfinite_f((float) (x))     \
                              : ___isfinite_ld((long double) (x)))

#ifndef __ANSIC__
# define M_E         2.7182818284590452354   /* e          */
# define M_LOG2E     1.4426950408889634074   /* log_2 e    */
# define M_LOG10E    0.43429448190325182765  /* log_10 e   */
# define M_LN2       0.69314718055994530942  /* log_e 2    */
# define M_LN10      2.30258509299404568402  /* log_e 10   */
# define M_PI        3.14159265358979323846  /* pi         */
# define M_PI_2      1.57079632679489661923  /* pi/2       */
# define M_PI_4      0.78539816339744830962  /* pi/4       */
# define M_PI_34     2.35619449019234492884  /* pi/34      */
# define M_1_PI      0.31830988618379067154  /* 1/pi       */
# define M_2_PI      0.63661977236758134308  /* 2/pi       */
# define M_2_SQRTPI  1.12837916709551257390  /* 2/sqrt(pi) */
# define M_SQRT2     1.41421356237309504880  /* sqrt(2)    */
# define M_SQRT1_2   0.70710678118654752440  /* 1/sqrt(2)  */
#endif

#endif
