#ifndef __monitor_h__
#define __monitor_h__
/*=============================================================================
=  Novell Software Development Kit
=
=  Copyright (C) 1999-2002 Novell, Inc. All Rights Reserved.
=
=  This work is subject to U.S. and international copyright laws and treaties.
=  Use and redistribution of this work is subject  to  the  license  agreement
=  accompanying  the  software  development kit (SDK) that contains this work.
=  However, no part of this work may be revised and/or  modified  without  the
=  prior  written consent of Novell, Inc. Any use or exploitation of this work
=  without authorization could subject the perpetrator to criminal  and  civil
=  liability.
=
=  Source(s): Novell Header
=
=  monitor.h
===============================================================================
*/
#include <time.h>
#include <stdlib.h>


#include <pshpack1.h>

struct cpu_info
{
   int      which;
   int      CurrentProcessor;
   uint32_t ProcessorUtilization;
   uint32_t ThreadsOnProcessor;

   uint32_t ThreadCPUTime;

   /* additional processor information that may be available... */
   uint32_t Family;
   uint32_t Model;
   uint32_t Stepping;

   uint32_t Revision;
   uint32_t FeatureFlags;
   uint64_t SerialNumber;

   uint32_t Speed;
   uint32_t L1CacheSize;
   uint32_t L2CacheSize;
   uint32_t L3CacheSize;

   /* may not equal 'ThreadsOnProcessor' when totalled... */
   uint32_t ReadyThreads;
   uint32_t RunningThreads;
   uint32_t SuspendedThreads;

   uint32_t reserved[13];
};

struct filesystem_info
{
   int      OpenFileCount;
   int      CurrentDiskRequests;
   uint32_t reserved[62];
};

struct memory_info
{
   uint64_t AllocatedMemoryPool;
   uint64_t CacheBufferSize;
   uint64_t CacheBufferMemory;
   uint64_t CacheMoveableMemory;
   uint64_t CacheNonmoveableMemory;
   uint64_t CodeMemory;
   uint64_t DataMemory;
   uint64_t TotalWorkMemory;
   uint32_t reserved[20];
};

struct vmemory_info
{
	uint64_t PageInCount;
	uint64_t PageOutCount;
	uint64_t SwapResvCount;
	uint64_t SwapPageCount;
	uint64_t SwapFreeCount;
	uint64_t PageFaultCount;
	uint64_t freeCachePages;
	uint64_t freeCleanPages;
	uint64_t freeDirtyPages; 
	uint64_t VMPhysicalPageCount;
	uint32_t reserved[20];
};

struct net_info
{
#define MAX_LAN_BOARDS 12
#define MAX_IP_ADDRS   12
#define IPX_ADDR_LEN    6
   int      MaximumConnections;
   uint32_t MACAddrs[MAX_LAN_BOARDS];
   uint8_t  IPXAddr[IPX_ADDR_LEN];
   uint8_t  spare1[2];
   uint32_t spare2;
   uint32_t spare3[12];                      /* (obsolete: BoardIPXAddrs) */
   uint32_t IPAddrsBound[MAX_IP_ADDRS];
   uint32_t spare4[24];
};


struct os_info
{
   int      AbendedProcessCount;
   int      CurrentServerProcesses;
   uint32_t reserved[62];
};

struct volume_info
{
#define MAX_VOLUME_NAME_LEN      31
#define VOL_NSS_PRESENT          0x10000000
#define VOL_NS_MACINTOSH         0x00000001
#define VOL_NS_NFS               0x00000002
#define VOL_NS_FTAM              0x00000004
#define VOL_NS_LONG              0x00000008  /* identical to OS/2 */
#define VOL_NS_NT                0x00000010
#define VOL_NS_PRIMARY           0x00000020
#define VOL_READ_ONLY            0x00000100
#define VOL_COMPRESSION_ENABLED  0x00000200
#define VOL_SUBALLOC_ENABLED     0x00000400
#define VOL_IS_MIGRATABLE        0x00000800

   int      which;
   uint32_t flags;                           /* includes namespace list */
   char     name[MAX_VOLUME_NAME_LEN+1];

   uint32_t SectorSize;
   uint32_t SectorsPerCluster;
   uint32_t VolumeSizeInClusters;
   uint32_t FreedClusters;
   uint32_t SubAllocFreeableClusters;
   uint32_t FreeableLimboSectors;
   uint32_t NonFreeableLimboSectors;
   uint32_t NonFreeableAvailableSubAllocSectors;
   uint32_t NotUsableSubAllocSectors;
   uint32_t SubAllocClusters;
   uint32_t DataStreamsCount;
   uint32_t LimboDataStreamsCount;
   uint32_t OldestDeletedFileAgeInTicks;
   uint32_t CompressedDataStreamsCount;
   uint32_t CompressedLimboDataStreamsCount;
   uint32_t UnCompressableDataStreamsCount;
   uint32_t PreCompressedSectors;
   uint32_t CompressedSectors;
   uint32_t MigratedFiles;
   uint32_t MigratedSectors;
   uint32_t ClustersUsedByFAT;
   uint32_t ClustersUsedByDirectories;
   uint32_t ClustersUsedByExtendedDirectories;
   uint32_t TotalDirectoryEntries;
   uint32_t UnUsedDirectoryEntries;
   uint32_t TotalExtendedDirectoryExtants;
   uint32_t UnUsedExtendedDirectoryExtants;
   uint32_t ExtendedAttributesDefined;
   uint32_t ExtendedAttributeExtantsUsed;
   uint32_t DirectoryServicesObjectID;
   uint32_t VolumeLastModifiedDateAndTime;

   int      mounted;

   uint32_t reserved[63];
};

#include <poppack.h>

#ifdef __cplusplus
extern "C"
{
#endif

/* prototypes... */
int netware_cpu_info ( struct cpu_info        *info, int *sequence );
int netware_fs_info  ( struct filesystem_info *info );
int netware_net_info ( struct net_info        *info );
int netware_mem_info ( struct memory_info     *info );
int netware_os_info  ( struct os_info         *info );
int netware_vmem_info( struct vmemory_info    *info );
int netware_vol_info ( struct volume_info     *info, int *sequence );
int netware_vol_info_from_name
                     ( struct volume_info     *info, const char *name );

#ifdef __cplusplus
}
#endif

#endif
