#ifndef __netdb_h__
#define __netdb_h__
/*============================================================================
=  Novell Software Development Kit
=
=  Copyright (C) 1999-2002 Novell, Inc. All Rights Reserved.
=
=  This work is subject to U.S. and international copyright laws and treaties.
=  Use and redistribution of this work is subject  to  the  license  agreement
=  accompanying  the  software  development kit (SDK) that contains this work.
=  However, no part of this work may be revised and/or  modified  without  the
=  prior  written consent of Novell, Inc. Any use or exploitation of this work
=  without authorization could subject the perpetrator to criminal  and  civil
=  liability. 
=
=  Source(s): Berkeley Header
=
=  netdb.h
==============================================================================
=  Copyright (c) 1980 Regents of the University of California. All rights
=  reserved. The Berkeley software License Agreement specifies the terms and
=  conditions for redistribution.
==============================================================================
*/
#include <sys/types.h>

#if   defined(__novsock2_h__)
# error netdb.h is incompatible with novsock2.h!
#elif defined(__winsock2_h_)
# error netdb.h is incompatible with winsock2.h!
#endif

#define NETDB_INTERNAL (-1) /* see errno.h */
#define NETDB_SUCCESS  0    /* no problem */
#define HOST_NOT_FOUND 1    /* authoritative answer host not found */
#define TRY_AGAIN      2    /* non authoritative host not found or SERVERFAIL */
#define NO_RECOVERY    3    /* non recoverable: FORMERR, REFUSED, NOTIMP */
#define NO_DATA        4    /* valid name, no data record of requested type */
#define NO_ADDRESS     NO_DATA/* no address, look for MX record */


/*
** Addresses are supplied in host order and returned in network order.
*/
struct hostent
{
   char   *h_name;               /* official name of host                  */
   char  **h_aliases;            /* alias list                             */
   short   h_addrtype;           /* host address type                      */
   short   h_length;             /* length of address                      */
   char  **h_addr_list;          /* list of addresses                      */
#define h_addr  h_addr_list[0]   /* address, for backward compatibility    */
};

/*
** It is assumed here that a network number fits in 32 bits.
*/
struct netent                    /* assumed network number fits in 32 bits */
{
   char   *n_name;               /* official name of net                   */
   char  **n_aliases;            /* alias list                             */
   short   n_addrtype;           /* net address type                       */
   u_long  n_net;                /* network number                         */
};

struct servent
{
   char   *s_name;               /* official service name                  */
   char  **s_aliases;            /* alias list                             */
   short   s_port;               /* port number                            */
   char   *s_proto;              /* protocol to use                        */
};

struct protoent
{
   char   *p_name;               /* official protocol name                 */
   char  **p_aliases;            /* alias list                             */
   short   p_proto;              /* protocol number                        */
};

#ifdef __cplusplus
extern "C"
{
#endif

struct hostent  *gethostbyaddr   ( const char *, int, int );
struct hostent  *gethostbyname   ( const char * );
int              gethostname     ( char *, int );       
struct protoent *getprotobyname  ( const char * );
struct protoent *getprotobynumber( int );
struct servent  *getservbyname   ( const char *, const char * );
struct servent  *getservbyport   ( int, const char * );

int             *___h_errno      ( void );

#ifdef __cplusplus
}
#endif

#ifndef h_errno
# define h_errno (*___h_errno())
#endif

#endif
