#ifndef __netinet_in_h__
#define __netinet_in_h__
/*============================================================================
=  Novell Software Development Kit
=
=  Copyright (C) 1999-2002 Novell, Inc. All Rights Reserved.
=
=  This work is subject to U.S. and international copyright laws and treaties.
=  Use and redistribution of this work is subject  to  the  license  agreement
=  accompanying  the  software  development kit (SDK) that contains this work.
=  However, no part of this work may be revised and/or  modified  without  the
=  prior  written consent of Novell, Inc. Any use or exploitation of this work
=  without authorization could subject the perpetrator to criminal  and  civil
=  liability.
=
=  Source(s): Berkeley, various UNICES
=
=  netinet/in.h
==============================================================================
=  Copyright (c) 1980 Regents of the University of California. All rights
=  reserved. The Berkeley software License Agreement specifies the terms and
=  conditions for redistribution.
==============================================================================
*/
#include <string.h>
#include <sys/types.h>
#include <sys/byteorder.h>

/* protocols... */
#define IPPROTO_IP          0  /* dummy for IP                          */
#define IPPROTO_ICMP        1  /* control message protocol              */
#define IPPROTO_IGMP        2  /* internet group management protocol    */
#define IPPROTO_GGP         3  /* gateway^2 (deprecated)                */
#define IPPROTO_TCP         6  /* TCP                                   */
#define IPPROTO_EGP         8  /* exterior gateway protocol             */
#define IPPROTO_PUP        12  /* PUP                                   */
#define IPPROTO_UDP        17  /* user datagram protocol                */
#define IPPROTO_IDP        22  /* XNS IDP                               */
#define IPPROTO_ND         77  /* UNOFFICIAL net disk proto             */
#define IPPROTO_PGM       113  /* pragmatic general multicast (RFC3208) */

#define IPPROTO_RAW        255 /* raw IP packet                         */
#define IPPROTO_MAX        256

/* port/socket numbers: network standard functions */
#define IPPORT_ECHO         7
#define IPPORT_DISCARD      9
#define IPPORT_SYSTAT      11
#define IPPORT_DAYTIME     13
#define IPPORT_NETSTAT     15
#define IPPORT_FTP         21
#define IPPORT_TELNET      23
#define IPPORT_SMTP        25
#define IPPORT_TIMESERVER  37
#define IPPORT_NAMESERVER  42
#define IPPORT_WHOIS       43
#define IPPORT_MTP         57

/* port/socket numbers: host specific functions... */
#define IPPORT_TFTP        69
#define IPPORT_RJE         77
#define IPPORT_FINGER      79
#define IPPORT_TTYLINK     87
#define IPPORT_SUPDUP      95

/* UNIX TCP sockets...  */
#define IPPORT_EXECSERVER  512
#define IPPORT_LOGINSERVER 513
#define IPPORT_CMDSERVER   514
#define IPPORT_EFSSERVER   520

/* UNIX UDP sockets... */
#define IPPORT_BIFFUDP     512
#define IPPORT_WHOSERVER   513
#define IPPORT_ROUTESERVER 520 /* 520+1 also used */

/*
** Ports numbered less than IPPORT_RESERVED are reserved for privileged
** processes like 'root.'
*/
#define IPPORT_RESERVED     1024
#define IPPORT_USERRESERVED 5000

/* link numbers... */
#define IMPLINK_IP         155
#define IMPLINK_LOWEXPER   156
#define IMPLINK_HIGHEXPER  158

/*
** Definitions of bits in Internet address integers. On subnets, the
** decomposition of addresses to host and net parts is done according
** to subnet mask, not the masks here.
*/
#define IN_CLASSA(i)       (((long) (i) & 0x80000000) == 0)
#define IN_CLASSA_NET      0xFF000000
#define IN_CLASSA_NSHIFT   24
#define IN_CLASSA_HOST     0x00FFFFFF
#define IN_CLASSA_MAX      128

#define IN_CLASSB(i)       (((long) (i) & 0xc0000000) == 0x80000000)
#define IN_CLASSB_NET      0xffff0000
#define IN_CLASSB_NSHIFT   16
#define IN_CLASSB_HOST     0x0000FFFF
#define IN_CLASSB_MAX      65536

#define IN_CLASSC(i)       (((long) (i) & 0xE0000000) == 0xC0000000)
#define IN_CLASSC_NET      0xFFFFFF00
#define IN_CLASSC_NSHIFT   8
#define IN_CLASSC_HOST     0x000000FF

#define IN_CLASSD(i)       (((long) (i) & 0xF0000000) == 0xE0000000)
#define IN_CLASSD_NET      0xF0000000   /* these aren't really net */
#define IN_CLASSD_NSHIFT   28           /* and host fields, but    */
#define IN_CLASSD_HOST     0x0FFFFFFF   /* routing needn't know    */
#define IN_MULTICAST(i)    IN_CLASSD(i)

#define IN_EXPERIMENTAL(i) (((long) (i) & 0xE0000000) == 0xE0000000)
#define IN_BADCLASS(i)     (((long) (i) & 0xF0000000) == 0xF0000000)

#define INADDR_ANY         (u_long) 0x00000000
#define INADDR_LOOPBACK    (u_long) 0x7F000001
#define INADDR_BROADCAST   (u_long) 0xFFFFFFFF
#define INADDR_NONE        0xFFFFFFFF


#define ADDR_ANY           INADDR_ANY

/* options for use with [gs]etsockopt at IP level... */
#define IP_OPTIONS         1        /* set/get IP per-packet options   */
#define IP_MULTICAST_IF    2        /* set/get IP multicast interface  */
#define IP_MULTICAST_TTL   3        /* set/get IP multicast timetolive */
#define IP_MULTICAST_LOOP  4        /* set/get IP multicast loopback   */
#define IP_ADD_MEMBERSHIP  5        /* add  an IP group membership     */
#define IP_DROP_MEMBERSHIP 6        /* drop an IP group membership     */

#define IN_LOOPBACKNET     127   /* official!                     */

/* macro to stuff the loopback address into an Internet address... */
#define IN_SET_LOOPBACK_ADDR(a)                      \
   {                                                 \
      (a)->sin_addr.s_addr = htonl(INADDR_LOOPBACK); \
      (a)->sin_family      = AF_INET;                \
   }

#define IN6ADDR_ANY_INIT      {{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}}
#define IN6ADDR_LOOPBACK_INIT {{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1}}
#define INET6_ADDRSTRLEN      46
#define INET_ADDRSTRLEN       16
 
#define IPV6_UNICAST_HOPS     4  /* IP6 hops */

#define IPV6_MULTICAST_IF     9  /* u_char; set/get IP6 multicast I/F      */
#define IPV6_MULTICAST_HOPS   10 /* u_char; set/get IP6 multicast hops     */
#define IPV6_MULTICAST_LOOP   11 /* u_char; set/get IP6 multicast loopback */
#define IPV6_JOIN_GROUP       12 /* ip6_mreq; join a group membership      */
#define IPV6_LEAVE_GROUP      13 /* ip6_mreq; leave a group membership     */
           
/* address testing macros... */
#define IN6_IS_ADDR_UNSPECIFIED(a) (             \
      (*(uint32_t *) (&(a)->s6_addr [0]) == 0)   \
   && (*(uint32_t *) (&(a)->s6_addr [4]) == 0)   \
   && (*(uint32_t *) (&(a)->s6_addr [8]) == 0)   \
   && (*(uint32_t *) (&(a)->s6_addr[12]) == 0))
 
#define IN6_IS_ADDR_LOOPBACK(a)    (             \
      (*(uint32_t *) (&(a)->s6_addr [0]) == 0)   \
   && (*(uint32_t *) (&(a)->s6_addr [4]) == 0)   \
   && (*(uint32_t *) (&(a)->s6_addr [8]) == 0)   \
   && (*(uint32_t *) (&(a)->s6_addr[12]) == ntohl(1)))

#define IN6_IS_ADDR_MULTICAST(a)   (((a)->s6_addr[0] == 0xFF))
 
#define IN6_IS_ADDR_LINKLOCAL(a)   \
      (((a)->s6_addr[0] == 0xFE) && (((a)->s6_addr[1] & 0xC0) == 0x80))
 
 
#define IN6_IS_ADDR_SITELOCAL(a)   \
      (((a)->s6_addr[0] == 0xFE) && (((a)->s6_addr[1] & 0xC0) == 0xC0))
 

#define IN6_IS_ADDR_V4MAPPED(a)    (            \
      (*(u_int32_t *)(&(a)->s6_addr[0]) == 0)   \
   && (*(u_int32_t *)(&(a)->s6_addr[4]) == 0)   \
   && (*(u_int32_t *)(&(a)->s6_addr[8]) == ntohl(0x0000FFFF)))
 
#define IN6_IS_ADDR_V4COMPAT(a)    (            \
      (*(u_int32_t *)(&(a)->s6_addr [0]) == 0)  \
   && (*(u_int32_t *)(&(a)->s6_addr [4]) == 0)  \
   && (*(u_int32_t *)(&(a)->s6_addr [8]) == 0)  \
   && (*(u_int32_t *)(&(a)->s6_addr[12]) != 0)  \
   && (*(u_int32_t *)(&(a)->s6_addr[12]) != ntohl(1)))

#define IN6_ARE_ADDR_EQUAL(a, b)   (memcmp(&(a)->s6_addr[0],             \
                                           &(b)->s6_addr[0],             \
                                           sizeof(struct in6_addr)) == 0)

/* type definitions... */
struct in_addr
{
   union
   {
      struct { unsigned char s_b1, s_b2, s_b3, s_b4; } S_un_b;
      struct { unsigned short s_w1, s_w2; }            S_un_w;
      unsigned long                                    S_addr;
   } S_un;

#define s_addr  S_un.S_addr      /* can be used for most TCP/IP code */
#define s_host  S_un.S_un_b.s_b2 /* host on imp                      */
#define s_net   S_un.S_un_b.s_b1 /* network                          */
#define s_imp   S_un.S_un_w.s_w2 /* imp                              */
#define s_impno S_un.S_un_b.s_b4 /* imp number                       */
#define s_lh    S_un.S_un_b.s_b3 /* logical host                     */
};

typedef struct in_addr     in_addr_t;

struct sockaddr_in               /* socket address, internet style   */
{
   short          sin_family;
   u_short        sin_port;
   struct in_addr sin_addr;
   char           sin_zero[8];
};

typedef struct sockaddr_in sockaddr_in_t;

struct in6_addr
{
   union 
   {
      u_char   bytes[16];
		u_short  shorts[8];
      u_long   words[4];
   } in6a_u;

#define in6a_shorts in6a_u.shorts
#define in6a_words  in6a_u.words
#define s6_addr     in6a_u.bytes
};

struct sockaddr_in6
{
   short           sin6_family;
   u_short         sin6_port;
   u_long          sin6_flowinfo;
   struct in6_addr sin6_addr;
   u_long          sin6_scope_id ;
};

/* for IP_ADD_MEMBERSHIP and IP_DROP_MEMBERSHIP... */
struct ip_mreq
{
   struct in_addr imr_multiaddr;    /* IP multicast address of group   */
   struct in_addr imr_interface;    /* local IP address of interface   */
};


#ifdef __cplusplus
extern "C" {
#endif


/* data... */
extern const struct in6_addr  in6addr_any;
extern const struct in6_addr  in6addr_loopback;

#ifdef __cplusplus
}
#endif


#endif
