#ifndef __netware_h__
#define __netware_h__
/*============================================================================
=  Novell Software Development Kit
=
=  Copyright (C) 1999-2002 Novell, Inc. All Rights Reserved.
=
=  This work is subject to U.S. and international copyright laws and treaties.
=  Use and redistribution of this work is subject  to  the  license  agreement
=  accompanying  the  software  development kit (SDK) that contains this work.
=  However, no part of this work may be revised and/or  modified  without  the
=  prior  written consent of Novell, Inc. Any use or exploitation of this work
=  without authorization could subject the perpetrator to criminal  and  civil
=  liability.
=
=  Source(s): Novell Header
=
=  Direct consumption of NetWare OS interfaces; additional library interfaces.
=
=  netware.h
==============================================================================
*/
#include <stddef.h>
#include <stdint.h>

/* NLM load flags; values for linker flag command... */
#define LD_MODULE_REENTRANT_BIT       0x00000001 /* NLM is reeentrant       */
#define LD_MODULE_MULTIPLE_LOAD       0x00000002 /* multiple load           */
#define LD_SYNCHRONIZE_START          0x00000004 /* uses SynchronizeStart() */
#define LD_PSEUDOPREEMPTION_BIT       0x00000008
#define LD_KERNEL_LOAD                0x00000010 /* ring 0-only             */
#define LD_AUTO_UNLOAD                0x00000040 /* once dependencies gone  */
#define LD_HIDDEN_MODULE              0x00000080
#define LD_DIGITALLY_SIGNED_FILE      0x00000100
#define LD_PROTECTED_LOAD             0x00000200 /* protected address space */
#define LD_SHARED_LIBRARY             0x00000400
#define LD_RESTARTABLE                0x00000800
#define LD_MODULE_HAS_MPK_STUBS       0x00001000
#define LD_NOT_MULTIPROCESSOR_SAFE    0x00002000
#define LD_PREEMPTABLE                0x00004000
#define LD_HAS_SYSTEM_CALLS           0x00008000
#define LD_VIRTUAL_MEMORY             0x00010000
#define LD_TSR                        0x01000000 /* stays resident          */
#define LD_UNICODE_STRINGS            0x02000000 /* uses Unicode strings    */
#define LD_HOTSWAP_DRIVER             0x04000000
#define LD_STARTUP_DEVICE_NLM_BIT     0x08000000
#define LD_BOUND_NLM_BIT              0x10000000
#define LD_DONT_UNLOAD_BIT            0x20000000 /* never unload            */
#define LD_MODULE_BEING_DEBUGGED      0x40000000 /* (debugging)             */
#define LD_MEMORY_ON_4K_BOUNDRIES_BIT 0x80000000 /* (debugging)             */

#ifndef __RTAG_T
# define __RTAG_T
typedef void *rtag_t;
#endif

#ifndef __SCR_T
# define __SCR_T
typedef void *scr_t;
#endif

#include <event.h>

#ifdef __cplusplus
extern "C"
{
#endif

/* server interfaces... */
#define NW_MAX_CMDLINE_LEN       (511+1)

/* ShutdownServer() 'flags'... */
#define SHUTDOWN_RESET           0x00000001
#define SHUTDOWN_POWEROFF        0x00000002      /* as yet unimplemented    */

void  RestartServer( const char *commandLine );
int   ShutdownServer( scr_t scrID, uint8_t forceDown,
         const char *alternateMessage, unsigned long flags );
int   StopServer( scr_t scrID, uint8_t forceDown, uint32_t reserved1,
         void *reserved2, const char *alternateMessage, uint32_t reserved3);


/* resource tag interfaces... */
#ifndef  _AllocateResourceTag_
# define _AllocateResourceTag_
# define AllocSignature               0x54524C41
# define BreakpointSignature          0x54504B42
# define ConsoleCommandSignature      0x4D4F4343
# define CommandLineServicesSignature 0x5043574E
# define DebugCommandSignature        0x53504344
# define DebuggerSignature            0x47554244
# define EventSignature               0x544E5645
# define ScreenSignature              0x4E524353

typedef void   (*Cleanup_t)( rtag_t rTag, int forceFlag );

rtag_t AllocateResourceTag( void *NLMHandle, const char *description,
          uint32_t signature);
int    RegisterTrackedResource( void *NLMHandle, uint32_t signature,
          Cleanup_t cleanup, const char *description );
int    UnRegisterTrackedResource( void *NLMHandle, uint32_t signature );
#endif


/* NetWare-loader interfaces... */
#define MAX_SYMBOL_NAME_LEN      80

int   ExportPublicObject( void *NLMHandle, const char *name, void *object );
void *ImportPublicObject( void *NLMHandle, const char *name );
void  KillMe( void *NLMHandle );
int   ReturnMessageInformation( void *NLMHandle, char ***table,
         size_t *stringCount, int *languageID, void *helpFile );
int   SetAutoUnloadFlag( void *NLMHandle );
int   UnImportPublicObject( void *NLMHandle, const char *name );

/* module loading and console search path interfaces... */
/* option flags for LoadModule() */
#define LO_NORMAL               0x00000000
#define LO_PROTECT              0x00000002
#define LO_LOAD_LOW             0x00000020
#define LO_RETURN_HANDLE        0x00000040
#define LO_LOAD_SILENT          0x00000080
#define LO_RESTART              0x00000200
#define LO_DONT_DISPLAY_ERROR   0x00002000
#define LO_MEMORY_DEBUG         0x00010000  /* debug only; no production use */
#define LO_RELAXED_MEMORY_DEBUG 0x00020000  /* debug only; no production use */

/* error returns from LoadModule() */
#define ERR_LOADER_COULD_NOT_FIND_FILE           1
#define ERR_LOADER_ERROR_READING_FILE            2
#define ERR_LOADER_NOT_NLM_FILE_FORMAT           3
#define ERR_LOADER_WRONG_NLM_FILE_VERSION        4
#define ERR_LOADER_REENTRANT_INITIALIZE_FAILURE  5
#define ERR_LOADER_CAN_NOT_LOAD_MULTIPLE_COPIES  6
#define ERR_LOADER_ALREADY_IN_PROGRESS           7
#define ERR_LOADER_NOT_ENOUGH_MEMORY             8
#define ERR_LOADER_INITIALIZE_FAILURE            9
#define ERR_LOADER_INCONSISTENT_FILE_FORMAT      10
#define ERR_LOADER_CAN_NOT_LOAD_AT_STARTUP       11
#define ERR_LOADER_AUTO_LOAD_MODULES_NOT_LOADED  12
#define ERR_LOADER_UNRESOLVED_EXTERNAL           13
#define ERR_LOADER_PUBLIC_ALREADY_DEFINED        14
#define ERR_LOADER_XDC_DATA_ERROR                15
#define ERR_LOADER_NOT_KERNEL                    16
#define ERR_LOADER_NIOS_ONLY_NLM                 17
#define ERR_LOADER_ADDRESS_SPACE_CREATION        18
#define ERR_LOADER_INITIALIZE_FAULT              19

int   AddSearchPathAtEnd( scr_t scrID, const char *path );
int   DeleteSearchPath( scr_t scrID, int searchPathNumber );
int   GetSearchPathElement( int index, unsigned long *isDOSFlag, char *path );
int   InsertSearchPath( scr_t scrID, int searchPathNumber, const char *path );
int   LoadModule( scr_t scrID, const char *path, unsigned long options );
int   UnloadModule( scr_t scrID, const char *commandline );


/* memory management interfaces... */
void  *Alloc( size_t size, rtag_t rTag );
void  *AllocSleepOK( size_t size, rtag_t rTag, int *slept );
void   NWGarbageCollect( void *NLMHandle );
size_t NWGetAvailableMemory( void );
size_t NWGetPageSize( void );
int    NWMemorySizeAddressable( const void *addr, size_t size );
void  *ReallocSleepOK( void *addr, size_t size, rtag_t rTag, int *slept );
void   Free( void *addr );
size_t SizeOfAllocBlock( void *addr );


/* console command line parsing interfaces... */
/* handler flags for RegisterCommand()... */
#define CMD_CONFIG_INFO    0x00000001 /* need configuration info? */
#define CMD_CONVERT_UPPER  0x00000002 /* convert command line to upper case? */
#define CMD_SERVER_RUNNING 0x00000004 /* server need to be running? */
#define CMD_LEGAL_SERVER   0x00000008 /* command legal on regular server? */
#define CMD_HIDDEN_CMD     0x00200000 /* don't display this command */
#define CMD_SUB_CMDS_AVAIL 0x00100000 /* command has sub commands */
#define CMD_NO_CMD_CHAIN   0x00010000 /* disallow chaining of command keyword */
#define CMD_PASS_ON_ERROR  0x00020000 /* ignore error */
#define CMD_ANY_PROCESS    0x80000000 /* can run on any process with keyboard */

/* keyword flags for RegisterCommand()... */
#define CMD_MSG_NUMBER     0x80000000 /* pointer to keyword is number */
#define CMD_LENGTH_PREC    0x40000000 /* keyword is length-preceeded */

/* insertion flags for RegisterCommand()... */
#define CMD_INSERT_AT_HEAD 0x00000001 /* insert at head */
#define CMD_INSERT_AT_TAIL 0x00000002 /* insert at tail */
#define CMD_PERM_POSITION  0x80000000 /* leave in place (head or tail) */

/* valid error returns from command handler... */
#define CMD_CMD_EXECUTED   0x00000000 /* processed, go to next handler */
#define CMD_HALT_CMD_CHAIN 0x70000000 /* processed, but don't go on to next */
#define CMD_BAD_CMD_SYNTAX 0x70000010 /* not processed, syntax error */
#define CMD_NOT_RUNNING    0x70000011 /* won't execute until server up */
#define CMD_LINE_FAULT     0x70000012 /* command line fault--no error display */
#define CMD_BAD_MOD_HANDLE 0x70000021 /* NLM handle is invalid */
#define CMD_BAD_RTAG       0x70000022 /* invalid resource tag */
#define CMD_BAD_KEY        0x70000023 /* keyword is invalid */
#define CMD_RTAG_AND_MOD   0x70000024 /* resource tag doesn't match NLM */
#define CMD_NO_HANDLER     0x70000025 /* handler is missing */
#define CMD_KEY_TOO_LONG   0x70000026 /* keyword is too long */
#define CMD_INVAL_PERM     0x70000027 /* invalid syntax to make permanent */
#define CMD_NO_MEMORY      0x70000028 /* unable to allocate memory */
#define CMD_NOT_REGISTERED 0x70000029 /* unregistered command */
#define CMD_HAS_CHAIN      0x7000002A /* command has a chain */
#define CMD_CANT_MAKE_HEAD 0x7000002B /* cannot make command permanent head */
#define CMD_CANT_MAKE_TAIL 0x7000002C /* cannot make command permanent tail */
#define CMD_PASS_TO_NEXT   0x7000002D /* not processed, go to next handler */
#define CMD_PRIV_ON_ALT    0x7000002E /* no privilege on alternate handler */
#define CMD_STOP_CMDS      0x7000002F /* system no longer parsing commands */

/* simplified versions of returns from command handler... */
#define CMD_PROCESSED_OK   CMD_HALT_CMD_CHAIN
#define CMD_CHAIN_NEXT_CMD CMD_CMD_EXECUTED
#define CMD_SYNTAX_ERROR   CMD_BAD_CMD_SYNTAX
#define CMD_NOT_MY_COMMAND CMD_PASS_TO_NEXT

/* command handler function codes... */
#define CMD_HELP_ON_CMD    0x00000000
#define CMD_GET_SUB_CMDS   0x00000001
#define CMD_PROCESS_CMD    0x00000002
#define CMD_MAX_HELP_CMDS  ProcessCommand

/* error codes... */
#define ERR_INVALID_MODULE     0x00000001
#define ERR_INVALID_RTAG       0x00000002
#define ERR_INVALID_KEYWORD    0x00000003
#define ERR_MODULE_RTAG_MIX    0x00000004
#define ERR_MISSING_HANDLER    0x00000005
#define ERR_KEYWORD_TOO_LONG   0x00000006
#define ERR_INVALID_REQUEST    0x00000007
#define ERR_OUT_OF_MEMORY      0x00000008
#define ERR_FAILED_TO_REGISTER 0x00000009
#define ERR_ALREADY_REGISTERED 0x0000000A
#define ERR_CANT_GRANT_TOP     0x0000000B
#define ERR_CANT_GRANT_END     0x0000000C

/* modern command parsing; uses CommandLineServicesSignature... */
typedef int (*CommandHandler_t)( int funcCode, void *scrID,
                  const char *command, const char *upperCaseCommand,
                  void *callerReference );

int DeRegisterCommand( void *NLMHandle, rtag_t rTag, uint32_t keywordFlags,
       const char *keyword );
int RegisterCommand( void *NLMHandle, rtag_t rTag, uint32_t keywordFlags,
       const char *keyword, uint32_t handlerFlags, uint32_t insertionFlags,
       CommandHandler_t handler, void *callerReference );

/* legacy command parsing; uses ConsoleCommandSignature... */
typedef int (*Parser_t)( scr_t scrID, const char *commandline );
typedef struct parser
{
   struct parser  *link;
   Parser_t        parser;
   rtag_t          rTag;     /* allocate with ConsoleCommandSignature */
} CommandParser_t;

int ParseCommand( const char *commandLine );
int RegisterConsoleCommand( CommandParser_t *cmdParser );
int UnRegisterConsoleCommand( CommandParser_t *cmdParser );


/* console settable command parsing interfaces... */
#define GetSettableParameterValue  GetSetableParameterValue
#define ScanSettableParameters     ScanSetableParameters
#define SetSettableParameterValue  SetSetableParameterValue

int GetSettableParameterValue( int connection, const char *name, void *value );
int ScanSettableParameters( int scanCategory, uint32_t *scanSequence,
       const char *name, int *type, uint32_t *flags, int *category,
       void *description, void *value, int *lowerLimit, int *upperLimit );
int SetSettableParameterValue(int connection, const char *name, void *newValue);


/* NLM start-up synchronization... */
void SynchronizeStart( void );


/* message table loading... */
int LoadLanguageMessageTable( char ***table, int *count, int *languageID );


/* timer interfaces... */
uint32_t GetHighResolutionTimer( void );
uint32_t GetSuperHighResolutionTimer( void );


/* spin locks for use in the kernel (not from a protected address space)... */
typedef void *spinlock_t;

int           KernelSpinLockInit( spinlock_t *lock );
void          KernelSpinLock( spinlock_t *lock );
int           KernelSpinTryLock( spinlock_t *lock );
void          KernelSpinUnlock( spinlock_t *lock );

unsigned long KernelSpinLockDisable( spinlock_t *lock );
int           KernelSpinTryLockDisable(spinlock_t *lock, unsigned long *flags);
void          KernelSpinUnlockRestore( spinlock_t *lock, unsigned long flags );


/* debugging interfaces... */
#define EXCEPTION_HANDLED       0  /* return from exception */
#define EXCEPTION_NOT_HANDLED   1  /* chain to next handler */

                                   /* registered debugger parser returns: */
#define NEXT_DEBUG_PARSER     (-2) /* call next debug parser */
#define NEXT_ALT_DEBUG_PARSER (-1) /* call next registered debug parser */
#define COMMAND_HANDLED         0  /* call no other parser */
#define INTERNAL_DEBUGGER       1  /* pass to NetWare System Debugger */

typedef struct exceptionframe
{
   uint32_t  xfReserved[7];
   uint32_t *xfCR3;
   uint32_t  xfEIP;
   uint32_t  xfSystemFlags;
   uint32_t  xfEAX;
   uint32_t  xfECX;
   uint32_t  xfEDX;
   uint32_t  xfEBX;
   uint32_t  xfESP;
   uint32_t  xfEBP;
   uint32_t  xfESI;
   uint32_t  xfEDI;
   uint16_t  xfES[2];
   uint16_t  xfCS[2];
   uint16_t  xfSS[2];
   uint16_t  xfDS[2];
   uint16_t  xfFS[2];
   uint16_t  xfGS[2];
   uint16_t  xfLDT[2];
   uint16_t  xfSpecial[2];
   uint32_t  xfNumber;
   char     *xfDescription;
   uint32_t  xfFlags;
   uint32_t  xfErrorCode;
   uint32_t  xfPageFaultCR2;
   uint32_t  xfFPUState;
   uint32_t  xfHistogram;
   uint32_t  xfProcessorID;
} xframe_t;

typedef int (*SoftBPHandler_t)(int number, void *address, xframe_t *frame);
typedef int (*DebugParser_t)(scr_t scr, const char *command, xframe_t *frame);

void  Abend( const char *message );
void *AddressOfSoftBreakpoint( int number );
int   AddSoftBreakpoint( void *addr, SoftBPHandler_t handler );
int   CSetABreakpoint( int number, void *addr, uint8_t type, uint8_t length );
void  EnterDebugger( void );
int   GetDebuggerActiveCount( void );
int   RegisterDebugCommandParser( DebugParser_t parseRoutine, rtag_t rTag );
int   RemoveSoftBreakpoint( int number );
int   UnRegisterDebugCommandParser( DebugParser_t parseRoutine );

extern void *preferredModule;


/*
** Prototypes for libraries and drivers writing their own start-up and shut-
** down code. (DllMain() is also part of this list and defined in windows.h.)
** These are not interfaces, but only prototypes for code furnished by the
** NLM application, library, driver, etc.
*/
int  _NonAppCheckUnload( void );
int  _NonAppStart( void *NLMHandle, void *errorScreen, const char *commandLine,
          const char *loadDirPath, size_t uninitializedDataLength,
          void *NLMFileHandle, int (*readRoutineP)( int conn, void *fileHandle,
          size_t offset, size_t nbytes, size_t *bytesRead, void *buffer ),
          size_t customDataOffset, size_t customDataSize, int messageCount,
          const char **messages );
void _NonAppStop( void );


#ifdef __cplusplus
}
#endif


#endif
