#ifndef __stddef_h__
#define __stddef_h__
/*============================================================================
=  Novell Software Development Kit
=
=  Copyright (C) 1999-2002 Novell, Inc. All Rights Reserved.
=
=  This work is subject to U.S. and international copyright laws and treaties.
=  Use and redistribution of this work is subject  to  the  license  agreement
=  accompanying  the  software  development kit (SDK) that contains this work.
=  However, no part of this work may be revised and/or  modified  without  the
=  prior  written consent of Novell, Inc. Any use or exploitation of this work
=  without authorization could subject the perpetrator to criminal  and  civil
=  liability. 
=
=  Source(s): ISO/IEC (ANSI) 9899:1999
=
=  stddef.h
==============================================================================
*/
#include <stdint.h>

#ifdef __STDC__
# ifndef __WATCOMC__
#  ifndef __GNUC__
#   undef __STDC__               /* set this only if compiler itself conforms */
#   define __STDC__        1     /* LibC is "conforming" */
#  endif
# endif
#endif

#ifdef __STD_HOSTED__
# undef __STDC_HOSTED
# define __STDC_HOSTED     0     /* LibC is "conforming" not "hosted" */
#endif

#ifdef __STD_IEC_559__
# undef __STDC_IEC_559__
#endif
#define __STDC_IEC_559__   0     /* LibC does not claim conformity */

#ifdef __STD_IEC_559_COMPLEX__
# undef __STDC_IEC_559_COMPLEX__
#endif
#define __STDC_IEC_559_COMPLEX__ 0/* LibC does not claim conformity */

#define POSIX_THREAD_SAFE_FUNCTIONS

#define __NOVELL_LIBC__          /* differentiate LibC from CLib compilation */

#ifndef  NULL
# define NULL           0
#endif

#ifndef  TRUE
# define TRUE           1
#endif

#ifndef  FALSE
# define FALSE          0
#endif

#ifndef  _SIZE_T
# define _SIZE_T
typedef UMACHINE_WORD   size_t;  /* type yielded by sizeof() */
#endif

#ifndef  _SSIZE_T
# define _SSIZE_T
typedef MACHINE_WORD    ssize_t; /* signed byte counts for file I/O */
#endif

#ifndef  _SIZE64_T
# define _SIZE64_T
typedef uint64_t        size64_t;/* used for 64-bit (long) file I/O */ 
#endif

#ifndef  _MODE_T
# define _MODE_T
typedef unsigned long   mode_t;  /* file attributes, permissions */
#endif

#ifndef  _OFF_T
# define _OFF_T
typedef long            off_t;   /* file offset value */
#endif

#ifndef  _OFF64_T
# define _OFF64_T
typedef int64_t         off64_t; /* 64-bit (long) file offset value */
#endif

#ifndef _INO_T
# define _INO_T
typedef uint64_t        ino_t;
#endif

#ifndef  _PID_T
# define _PID_T
typedef MACHINE_WORD    pid_t;   /* capable of holding pointer and -1 */
#endif

#ifndef _UID_T
# define _UID_T
typedef uint64_t        uid_t;
#endif

#ifndef _GID_T
# define _GID_T
typedef uint64_t        gid_t;
#endif

#ifndef _BLKSIZE_T
# define _BLKSIZE_T
typedef uint64_t        blksize_t;
#endif

#ifndef _BLKCNT_T
# define _BLKCNT_T
typedef uint64_t        blkcnt_t;
#endif

#ifndef _DEV_T
# define _DEV_T
typedef uint64_t        dev_t;
#endif

#ifndef _NLINK_T
# define _NLINK_T
typedef unsigned long   nlink_t;
#endif

#ifndef  _PTRDIFF_T
# define _PTRDIFF_T
typedef MACHINE_WORD    ptrdiff_t;/* difference of two pointers */
#endif

#define offsetof(type, field)  (size_t) &(((type *) 0)->field)

#ifndef  _WCHAR_T
# define _WCHAR_T
# define _WCHAR_T_DEFINED
# if defined(__GNUC__) && defined(__cplusplus)  /* (GNU C++ built-in) */
# else
typedef unsigned short  wchar_t;
# endif
# ifdef __STDC_ISO_10646__
#  undef __STDC_ISO_10646__      /* estimate conformance at this date */
#  define __STDC_ISO_10646__  200103L
# endif
#endif

#if !defined(_M_IA64) /* ------------- NetWare 32 -------------------------- */
# ifndef IAPX386
#  define IAPX386
# endif
#endif

/*-----------------------------------------------------------------------------
** Definitions for the 'restrict' keyword which not all platforms support.
*/
#if defined(__INTEL_COMPILER) || defined(__ICL ) || defined(__ECC__)
#elif defined(__MWERKS__) || defined(__GNUC__) || defined(_MSC_VER)
# define restrict   __restrict
#elif defined(__WATCOMC__) || defined(__BORLANDC__)
# define restrict
#else
# error Platform definitions undefined for this environment!
#endif
/*-----------------------------------------------------------------------------
*/

#endif
