#ifndef __nks_dirio_h__
#define __nks_dirio_h__
/*============================================================================
=  Novell Software Development Kit
=
=  Copyright (C) 1999-2002 Novell, Inc. All Rights Reserved.
=
=  This work is subject to U.S. and international copyright laws and treaties.
=  Use and redistribution of this work is subject  to  the  license  agreement
=  accompanying  the  software  development kit (SDK) that contains this work.
=  However, no part of this work may be revised and/or  modified  without  the
=  prior  written consent of Novell, Inc. Any use or exploitation of this work
=  without authorization could subject the perpetrator to criminal  and  civil
=  liability.
=
=  Source(s): Novell Header
=
=  nks/dirio.h
==============================================================================
*/
#include <nks/fsio.h>

/* basic change bits for NXSetAttr()... */
#define NX_DIRENT_EFFECTIVERIGHTS 0x0000000000000001
#define NX_DIRENT_FLAGS           0x0000000000000002
#define NX_DIRENT_OWNERID         0x0000000000000004
#define NX_DIRENT_CREATETIME      0x0000000000000008
#define NX_DIRENT_CHANGETIME      0x0000000000000010
#define NX_DIRENT_ACCESSTIME      0x0000000000000020
#define NX_DIRENT_MODIFYTIME      0x0000000000000040
#define NX_DIRENT_ATTRIBUTES      0x0000000000000080
#define NX_DIRENT_RESERVED1       0x0000000000000100
#define NX_DIRENT_RESERVED2       0x0000000000000200
#define NX_DIRENT_RESERVED3       0x0000000000000400
#define NX_DIRENT_RESERVED4       0x0000000000000800

/* flag values for NXDirAttr_t and NXDeEnum_t, etc... */
#define NX_DEFLAGS_COMPRESSED     0x00000001
#define NX_DEFLAGS_ENCRYPTED      0x00000002
#define NX_DEFLAGS_TEMPORARY      0x00000004
#define NX_DEFLAGS_MIGRATED       0x00000008
#define NX_DEFLAGS_DELETED        0x00000010
#define NX_DEFLAGS_SPARSE         0x00000020

/* deEffectiveRights bits */
#define	NX_READ_EXISTING_FILE		0x00000001
#define	NX_WRITE_EXISTING_FILE		0x00000002
#define	NX_CREATE_NEW_ENTRY			0x00000008
#define	NX_DELETE_EXISTING_ENTRY	0x00000010
#define	NX_CHANGE_ACCESS_CONTROL	0x00000020
#define	NX_SEE_FILES					0x00000040
#define	NX_MODIFY_ENTRY				0x00000080
#define	NX_SUPERVISOR_PRIVILEGES	0x00000100
#define	NX_ACCESS_RIGHTS_MASK		0x000001FB

#include <pshpack1.h>

typedef uint64_t  NXChangeBits_t;

typedef enum                      /* pathname format (PNF) enumeration        */
{
   NX_PNF_DEFAULT = INT_MAX,      /* use PNF in effect at open                */
   NX_PNF_NKS     = 0,            /* generic NKS pathname format              */
   NX_PNF_DOS     = 1,            /* DOS                                      */
   NX_PNF_MAC     = 2,            /* Macintosh/AFP 3.0                        */
   NX_PNF_UNIX    = 4,            /* UNIX/NFS                                 */
   NX_PNF_WIN     = 5,            /* Windows NT, OS/2                         */
   NX_PNF_NSS     = 7             /* Novell Storage Services (NSS)            */
} NXPathFormat_t;

typedef enum
{
   NX_DELEVEL_BASIC    =INT_MAX,  /* basic attribute information              */
   NX_DELEVEL_NAME_ONLY=INT_MAX+1,/* filename                                 */
   NX_DELEVEL_EXTENDED =INT_MAX+2,/* extended file system information         */
} NXDeLevel_t;

typedef struct                    /* marking place in directory enumeration   */
{                                 /* all private to implementation            */
   uint8_t     mark[44];
   void       *pathCtx;
   void       *entryInfo;
} NXDirMark_t;                    /* structure size is 52 bytes on NetWare    */

typedef struct                    /* information common to all PNF structures */
{
   size_t         length;         /* total length of entry including any      */
   NXObjType_t    objectType;     /* type of entry (file, FIFO, etc.)         */
   NXPathFormat_t pathFormat;     /* file system yielding information         */
   NXDeLevel_t    infoLevel;      /* level specified in NXDirEnumStart()      */
} NXDeHeader_t;

typedef struct
{
   NXDeHeader_t deHeader;         /* common information                       */
   NXFid_t      deFid;            /*                                          */
   uint32_t     deEffectiveRights;

   NXOffset_t   deFileSize;       /* length of file                           */
   uint64_t     deFlags;          /* compressed, sparse, encrypted, etc.      */
   NXTime_t     deAttrChangeTime; /* timestamp of last attribute change       */
   NXTime_t     deAccessTime;     /* timestamp of last write+attribute change */
   NXTime_t     deModifyTime;     /* timestamp of last write                  */
   size_t       deIoBlockSize;    /* preferred I/O blocksize                  */
} NXDirAttr_t;

typedef struct
{
   NXDeHeader_t deHeader;
   void         *deName;          /* plus name                                */
} NXDirAttrWithName_t;

typedef struct
{
   NXDirAttr_t  deDirAttr;        /* information fields                       */
   NXDirMark_t  deDirMark;        /* NXDirEnum- navigational mark             */
   void        *deName;
} NXDirEnum_t;


typedef struct                    /* generic NKS (NX_PNF_NKS) attributes      */
{
   NXDeHeader_t xdeHeader;
   NXFid_t      xdeFid;
   uint32_t     xdeEffectiveRights;

   NXOffset_t   xdeFileSize;
   uint64_t     xdeFlags;
   NXTime_t     xdeChangeTime;
   NXTime_t     xdeAccessTime;
   NXTime_t     xdeModifyTime;
   NXTime_t     xdeCreateTime;
   NXGuid_t     xdeOwnerId;
} NXDirAttrNks_t;

typedef struct                    /* generic NKS (NX_PNF_NKS) information...  */
{                                 /* ...including name                        */
   NXDirAttrNks_t deNksDirAttr;
   NXDirMark_t    deDirMark;
   void          *deName;
} NXDirEnumNks_t;

#include <poppack.h>

#ifdef __cplusplus
extern "C"
{
#endif


/* Path context... */
int NXFreePathContext(NXPathCtx_t pathCtx);
int NXCreatePathContext(NXPathCtx_t pathCtx, const void *pathname,
      NXPathFormat_t format, void *securityBadge, NXPathCtx_t *newPathCtx);
int NXCreatePathContextWithFid(NXFid_t fid, NXPathFormat_t format,
      void *securityBadge, NXPathCtx_t *newPathCtx);

/* Directory I/O... */
int NXDirCreate(NXPathCtx_t pathCtx, const void *pathname, void *reserved,
      NXPathCtx_t *newPathCtx);
int NXDirRemove(NXPathCtx_t pathCtx, const void *pathname);

/* Directory entry attributes... */
int NXGetAttr(NXPathCtx_t pathCtx, const void *pathname, NXDeLevel_t level,
      void *buffer, size_t length, unsigned long flags);
int NXGetAttrWithHandle(NXHandle_t handle, NXPathFormat_t format,
      NXDeLevel_t level, void *buffer, size_t length, unsigned long flags);
int NXSetAttr(NXPathCtx_t pathCtx, const void *pathname, NXDeLevel_t level,
      const void *buffer, NXChangeBits_t changeBits);
int NXSetAttrWithHandle(NXHandle_t handle, NXPathFormat_t format,
      NXDeLevel_t level, const void *buffer, NXChangeBits_t changeBits);

/* Subdirectory enumeration... */
int NXDirMarkInit(NXHandle_t handle, NXDirMark_t *dirMark);
int NXDirEnumEnd(NXHandle_t handle);
int NXDirEnumGetEntries(NXHandle_t handle, NXDirMark_t *start, void *buffer,
      size_t length, size_t *entriesReturned, NXDirMark_t *next,
      NXBool_t *sequenceGuarantee);
int NXDirEnumStart(NXPathCtx_t pathCtx, const void *pathname,
      NXDeLevel_t level, NXHandle_t *handle);

#ifdef __cplusplus
}
#endif


#endif
