#ifndef __nks_doswin_h__
#define __nks_doswin_h__
/*============================================================================
=  Novell Software Development Kit
=
=  Copyright (C) 1999-2002 Novell, Inc. All Rights Reserved.
=
=  This work is subject to U.S. and international copyright laws and treaties.
=  Use and redistribution of this work is subject  to  the  license  agreement
=  accompanying  the  software  development kit (SDK) that contains this work.
=  However, no part of this work may be revised and/or  modified  without  the
=  prior  written consent of Novell, Inc. Any use or exploitation of this work
=  without authorization could subject the perpetrator to criminal  and  civil
=  liability.
=
=  Source(s): Novell Header
=
=  nks/doswin.h
==============================================================================
*/
#include <wchar.h>
#include <nks/dirio.h>

/* attributes for NXDirAttrDos_t 'attrib' field... */
#ifndef ATTR_NORMAL
# define ATTR_NORMAL             0x00000000  /* no read/write restrictions */
# define ATTR_READ_ONLY          0x00000001  /* read-only file             */
# define ATTR_HIDDEN             0x00000002  /* hidden file                */
# define ATTR_SYSTEM             0x00000004  /* system file                */
# define ATTR_EXECUTE            0x00000008  /* execute only file          */
# define ATTR_VOLUME_ID          0x00000008  /* file system label          */
# define ATTR_DIRECTORY          0x00000010  /* subdirectory               */
# define ATTR_ARCHIVE            0x00000020  /* archive file               */
# define ATTR_SHARE              0x00000080  /* Sharable file              */

# define ATTR_NO_SUBALLOC        0x00000800  /* don't sub allocate file    */
# define ATTR_TRANS              0x00001000  /* trans'l file, TTS-usable   */
# define ATTR_READAUD            0x00004000  /* read audit                 */
# define ATTR_WRITAUD            0x00008000  /* write audit                */

# define ATTR_IMMPURG            0x00010000  /* immediate purge            */
# define ATTR_NORENAM            0x00020000  /* rename inhibit             */
# define ATTR_NODELET            0x00040000  /* delete inhibit             */
# define ATTR_NOCOPY             0x00080000  /* copy inhibit               */

# define ATTR_FILE_MIGRATED      0x00400000  /* file has been migrated     */
# define ATTR_DONT_MIGRATE       0x00800000  /* don't migrate this file    */
# define ATTR_IMMEDIATE_COMPRESS 0x02000000  /* compress file immediately  */
# define ATTR_FILE_COMPRESSED    0x04000000  /* file is compressed         */
# define ATTR_DONT_COMPRESS      0x08000000  /* don't compress this file   */
# define ATTR_CANT_COMPRESS      0x20000000  /* can't compress this file   */
# define ATTR_ATTR_ARCHIVE       0x40000000  /* entry has been modified    */
#endif

/* attributes for NXDirAttrWin_t 'dwFileAttributes' field... */
#ifndef FILE_ATTRIBUTE_READONLY
# define FILE_ATTRIBUTE_READONLY             0x00000001
# define FILE_ATTRIBUTE_HIDDEN               0x00000002
# define FILE_ATTRIBUTE_SYSTEM               0x00000004
# define FILE_ATTRIBUTE_DIRECTORY            0x00000010
# define FILE_ATTRIBUTE_ARCHIVE              0x00000020
# define FILE_ATTRIBUTE_ENCRYPTED            0x00000040  /* needs a look?  */
# define FILE_ATTRIBUTE_NORMAL               0x00000080
# define FILE_ATTRIBUTE_TEMPORARY            0x00000100
# define FILE_ATTRIBUTE_SPARSE_FILE          0x00000200
# define FILE_ATTRIBUTE_REPARSE_POINT        0x00000400
# define FILE_ATTRIBUTE_COMPRESSED           0x00000800
# define FILE_ATTRIBUTE_OFFLINE              0x00001000
# define FILE_ATTRIBUTE_NOT_CONTENT_INDEXED  0x00002000
#endif

#include <pshpack1.h>

typedef struct                      /* DOS/FAT32 (NX_PNF_DOS) attributes   */
{
   NXDeHeader_t xdeHeader;
   NXFid_t      xdeFid;
   uint32_t     xdeEffectiveRights;
                                    /* FAT32 File System Spec., p. 22      */
   unsigned int xdeAttr;               
   uint16_t     xdeCrtDate;
   uint16_t     xdeCrtTime;
   uint16_t     xdeCrtTimeTenth;
   uint16_t     xdeLastAccDate;
   uint16_t     xdeWrtDate;
   uint16_t     xdeWrtTime;
   uint32_t     xdeFileSize;
   uint32_t     Reserved1;
   uint32_t     Reserved2;
} NXDirAttrDos_t;

typedef struct                      /* DOS/FAT32 (NX_PNF_DOS) information..*/
{                                   /* ...including name                   */
   NXDirAttrDos_t deDosDirAttr;
   NXDirMark_t    deDirMark;

   char           deShortName[16];
   void          *deName;           /* maximum length is 255 characters    */
} NXDirEnumDos_t;

typedef struct                      /* Win32 (NX_PNF_WIN) attributes       */
{
   NXDeHeader_t   xdeHeader;
   NXFid_t        xdeFid;
   uint32_t       xdeEffectiveRights;
                                    /* see WIN32_FIND_DATA...              */
   unsigned long  xdeFileAttributes;/* FILE_ATTRIBUTE_NORMAL, etc.         */
   uint64_t       xdeCreateTime;    /* date and time of creation or -1     */
   uint64_t       xdeLastAccessTime;/* date and time of last access        */
   uint64_t       xdeLastWriteTime; /* date and time of last modification  */
   uint64_t       xdeLastChangeTime;/* date and time of last attr change   */
   uint64_t       xdeFileSize;
   uint32_t          Reserved0;
   uint32_t          Reserved1;
   uint32_t          Reserved2;
   uint32_t          Reserved3;
                                    /* see BY_HANDLE_FILE_INFORMATION...   */
   unsigned long  xdeNumberOfLinks; /* always 1 for FAT                    */
   uint32_t       xdeVolumeSerialNumber;
   uint32_t          Reserved4;
   uint32_t          Reserved5;
   uint64_t       xdeFileIndex;     /* unique identifier                   */
   uint64_t          Reserved6;
                                    /* CIFS Specification 0.9, 4.2.16.8... */
   unsigned long  xdeAllocationSize;/* file system block size              */
                                    /* (currently) Ramesh-invented fields...*/
   unsigned long  xdeAccessFlags;   /* not in Win32 docs, but exists       */
   unsigned long  xdeMiscFlags;     /* Boolean flag fields for CIFS        */
   uint32_t          Reserved7;
   uint64_t       xdeEaSize;        /* total size of extended attributes   */
   uint64_t       xdeCompressedFileSize;/* size of compressed file          */
   unsigned short xdeCompressionFormat;/* format of of compression          */
   uint16_t          Reserved8;
   uint32_t          Reserved9;
   uint64_t          Reserved10;
} NXDirAttrWin_t;

typedef struct                      /* Win32 (NX_PNF_WIN) information...   */
{                                   /* ...including name                   */
   NXDirAttrWin_t deWinDirAttr;
   NXDirMark_t    deDirMark;
                                    /* see WIN32_FIND_DATA...              */
   char           deAlternativeFileName[16];
   void          *deName;           /* maximum length is 255 characters    */
} NXDirEnumWin_t;

#include <poppack.h>

#endif
