#ifndef __nks_errno_h__
#define __nks_errno_h__
/*=============================================================================
=  Novell Software Development Kit
=
=  Copyright (C) 1999-2002 Novell, Inc. All Rights Reserved.
=
=  This work is subject to U.S. and international copyright laws and treaties.
=  Use and redistribution of this work is subject  to  the  license  agreement
=  accompanying  the  software  development kit (SDK) that contains this work.
=  However, no part of this work may be revised and/or  modified  without  the
=  prior  written consent of Novell, Inc. Any use or exploitation of this work
=  without authorization could subject the perpetrator to criminal  and  civil
=  liability.
=
=  Source(s): Novell Header
=
=  nks/errno.h
===============================================================================
*/
#include <nks/defs.h>

#define NX_EOF        (-1)  /* end of file (EOF) including write beyond EOF  */

#define NX_ENOENT       1   /* no such file or directory                     */
#define NX_E2BIG        2   /* argument list too big                         */
#define NX_ENOEXEC      3   /* exec format error                             */
#define NX_EBADF        4   /* bad file number (descriptor or handle)        */
#define NX_ENOMEM       5   /* not enough memory                             */
#define NX_EACCES       6   /* permission denied                             */
#define NX_EEXIST       7   /* file exists                                   */
#define NX_EXDEV        8   /* cross-device link                             */
#define NX_EINVAL       9   /* invalid argument                              */
#define NX_ENFILE       10  /* file table overflow                           */
#define NX_EMFILE       11  /* too many open files                           */
#define NX_ENOSPC       12  /* no space left on device                       */
#define NX_ERANGE       14  /* result too large                              */
#define NX_EDEADLK      15  /* resource deadlock would occur                 */
#define NX_EINUSE       16  /* resource(s) in use                            */
#define NX_ESERVER      17  /* server error (memory out, I/O error, etc.)    */
#define NX_ENOSERVR     18  /* no server (queue server, file server, etc.)   */
#define NX_EWRNGKND     19  /* wrong kind--an operation is being...          */
                            /*  ...attempted on the wrong kind of object     */
#define NX_ETRNREST     20  /* transaction restarted                         */
#define NX_ERESOURCE    21  /* resources unavailable (maybe permanently)     */
#define NX_EBADHNDL     22  /* bad non-file handle (screen, semaphore, etc.) */
#define NX_EAGAIN       24  /* resource temporarily unavailable              */
#define NX_EIO          28  /* physical I/O error                            */

#define NX_EPIPE        32  /* broken pipe                                   */
#define NX_EALREADY     37  /* operation already in progress                 */

#define NX_ETIMEDOUT    60  /* connection timed out                          */
#define NX_EBUSY        62  /* resource busy                                 */
#define NX_EINTR        63  /* interrupted function call                     */
#define NX_EISDIR       64  /* is a directory (not a file)                   */
#define NX_ENAMETOOLONG 65  /* filename too long                             */
#define NX_ENOSYS       66  /* function not implemented                      */
#define NX_ENOTDIR      67  /* not a directory                               */
#define NX_ENOTEMPTY    68  /* directory is not empty                        */
#define NX_EPERM        69  /* operation not permitted                       */

#define NX_ECHILD       70  /* no child process                              */
#define NX_EFBIG        71  /* file too large                                */
#define NX_EMLINK       72  /* too many links                                */
#define NX_ENOLCK       74  /* no locks available                            */
#define NX_ESRCH        77  /* no such object                                */
#define NX_ENOTSUP      79  /* this optional functionality not supported     */

#define NX_EBADTYPE     80  /* bad type for operation                        */
#define NX_EOVERFLOW    81  /* operation would overflow                      */
#define NX_EHOSTDOWN    82  /* host is down                                  */
#define NX_EHOSTUNREACH 83  /* no route to host                              */
#define NX_EPROCLIM     84  /* too many processes                            */

#define NX_EUNKNOWN     99  /* unknown error occurring                       */
#define NX_ENLMDATA     100 /* anomaly in NLM data structure                 */
#define NX_EILSEQ       101 /* illegal character sequence in multibyte       */
#define NX_EINCONSIS    102 /* internal library inconsistency                */
#define NX_EDOSTEXTEOL  103 /* DOS-text file inconsistency--no newline...    */
                            /* ...after carriage return                      */
#define NX_ENONEXTANT   104 /* object doesn't exist                          */
#define NX_ENOCONTEXT   105 /* the caller is not an NKS thread               */
#define NX_ENAMESPACE   106 /* invalid namespace or namespace operation      */
#define NX_EBADCONN		107 /* invalid connection                            */
#define NX_EEXHAUSTED	108 /* end of search                                 */


#define NX_EFILESYS     111 /* generic file system error                     */
#define NX_ESUFFICIENT  112 /* insufficient space for any operation result   */
#define NX_EPARTONLY    113 /* partial result only  for lack of space        */

#define NX_EBADIDENT    114 /* invalid user or other identity                */

/* aliases... */
#define NX_ENOSUPPORT   NX_ENOTSUP
#define NX_ENORESOURCE  NX_BADIDENT

#ifdef __cplusplus
extern "C"
{
#endif

/* prototypes... */
void        NXGetNKSVersion( int *major, int *minor, int *revision,
               void *platformName, size_t maxNameLength );
const char *NXStrError( int errornumber );
#ifdef __cplusplus
}
#endif

#endif
