#ifndef __nks_mac_h__
#define __nks_mac_h__
/*=============================================================================
=  Novell Software Development Kit
=
=  Copyright (C) 1999-2002 Novell, Inc. All Rights Reserved.
=
=  This work is subject to U.S. and international copyright laws and treaties.
=  Use and redistribution of this work is subject  to  the  license  agreement
=  accompanying  the  software  development kit (SDK) that contains this work.
=  However, no part of this work may be revised and/or  modified  without  the
=  prior  written consent of Novell, Inc. Any use or exploitation of this work
=  without authorization could subject the perpetrator to criminal  and  civil
=  liability.
=
=  Source(s): Novell Header
=
=  nks/mac.h
===============================================================================
=  THIS HEADER IS NOT CONSIDERED PUBLISHED; DO NOT RELY ON ITS CONTENTS!
=
=  NKS does not yet officially support Macintosh. This information is only
=  tentative as we study the question.
===============================================================================
*/
#include <nks/dirio.h>

#include <pshpack1.h>

/* values for 'fdFlags' (Inside Macintosh IV-105)... */
#define fOnDesk     1
#define fHasBundle  8192
#define fInvisible  16384

/* values for 'fdLocation' (Inside Macintosh IV-105)... */
#define fDisk       0
#define fDesktop    (-2)
#define fTrash      (-3)

/* 'ioFlAttrib' values... */
#define flLocked    0x01
#define flResOpen   0x04
#define flDatOpen   0x08
#define flIsDir     0x10
#define flBothOpen  0x80

typedef char OSType[4];       /* (Inside Macintosh II-373) */

typedef struct                /* (Inside Macintosh I-139) */
{
   uint16_t v;
   uint16_t h;
} Point;

typedef union                 /* (Inside Macintosh I-141) */
{
   struct
   {
      Point topLeft;
      Point botRight;
   } corner;
   struct
   {
      uint16_t top;
      uint16_t left;
      uint16_t bottom;
      uint16_t right;
   } point;
} Rect;

typedef struct                /* (Inside Macintosh IV-104) */
{
   OSType   fdType;
   OSType   fdCreator;
   uint16_t fdFlags;
   Point    fdLocation;
   uint16_t fdFldr;           /* window */
} FInfo;

typedef struct                /* (Inside Macintosh IV-105) */
{
   uint16_t fdIconID;
   uint16_t fdUnused[4];
   uint16_t fdComment;        /* Finder (Desktop) comment ID */
   uint32_t fdPutAway;        /* home directory ID */
} FXInfo;

typedef struct                /* (Inside Macintosh IV-105) */
{
   Rect     frRect;           /* folder's rectangle */
   uint16_t frFlags;
   Point    frLocation;
   uint16_t frView;
} DInfo;

typedef struct
{
   Point    frScroll;         /* scroll position                           */
   uint32_t frOpenChain;      /* directory ID chain of open folders        */
   uint16_t frUnused;
   uint16_t frComment;
   uint32_t frPutAway;        /* directory ID                              */
} DXInfo;

typedef struct
{
   FInfo    ioFlFndrInfo;     /* information used by the Finder            */
   uint32_t ioDirID;          /* directory ID or file number               */
   uint16_t ioFlStBlk;        /* first allocation block of data fork       */
   uint32_t ioFlLgLen;        /* logical end-of-file of data fork          */
   uint32_t ioFlPyLen;        /* physical end-of-file of data fork         */
   uint16_t ioFlRStBlk;       /* first allocation block of resource fork   */

   uint32_t ioFlRLgLen;       /* logical end-of-file of resource fork      */
   uint32_t ioFlRPyLen;       /* physical end-of-file of resource fork     */
   uint32_t ioFlCrDat;        /* date and time of creation                 */
   uint32_t ioFlMdDat;        /* date and time of last modification        */
   uint32_t ioFlBkDat;        /* date and time of last back-up             */
   FXInfo   ioFlXFndrInfo;    /* additional information used by the Finder */
   uint32_t ioFlParID;        /* file's parent directory ID                */
   uint32_t ioFlClpSiz;       /* file's clump size                         */
} hFileInfo;

typedef struct
{
   DInfo    ioDrUsrWds;       /* information used by the Finder            */
   uint32_t ioDrDirID;
   uint16_t ioDrNmFls;        /* number of files in directory              */
   uint16_t filler3[9];
   uint32_t ioDrCrDat;        /* date and time of creation                 */
   uint32_t ioDrMdDat;        /* date and time of last modification        */
   uint32_t ioDrBkDat;        /* date and time of last backup              */
   DXInfo   ioDrFndrInfo;     /* additional information used by the Finder */
   uint32_t ioDrParID;        /* directory's parent directory ID           */
} dirInfo;

typedef union
{
   hFileInfo   file;
   dirInfo     dir;
} CInfoPBRec;


typedef struct                /* Macintosh (NX_PNF_MAC) attributes         */
{
   NXDeHeader_t xdeHeader;
   NXFid_t      xdeFid;
   uint32_t     xdeEffectRights;
                              /* (Inside Macintosh IV-125) */
   uint16_t     xdeIoFRefNum; /* path reference number */
   int8_t       xdeIofVersNum;
   int8_t       filler1;
   uint16_t     xdeIoFDirIndex;
   int8_t       xdeIoFlAttrib;
   int8_t       filler2;
   uint32_t     filler3;

   CInfoPBRec   xdeInfo;
} NXDirAttrMac_t;

typedef struct                /* Macintosh (NX_PNF_MAC) information...     */
{                             /* ...including                              */
   NXDirAttrMac_t deMacDirAttr;
   NXDirMark_t    deDirMark;
   void          *deName;     /* maximum length is 255 characters    */
} NXDirEnumMac_t;

#include <poppack.h>

#endif
