#ifndef __nks_memory_h__
#define __nks_memory_h__
/*============================================================================
=  Novell Software Development Kit
=
=  Copyright (C) 1999-2002 Novell, Inc. All Rights Reserved.
=
=  This work is subject to U.S. and international copyright laws and treaties.
=  Use and redistribution of this work is subject  to  the  license  agreement
=  accompanying  the  software  development kit (SDK) that contains this work.
=  However, no part of this work may be revised and/or  modified  without  the
=  prior  written consent of Novell, Inc. Any use or exploitation of this work
=  without authorization could subject the perpetrator to criminal  and  civil
=  liability. 
=
=  Source(s): Novell Header
=
=  nks/memory.h
==============================================================================
*/
#include <nks/defs.h>


/* deprecated values for memory control flags... */
#define NX_PAGE_UNLOCK        0x00000000
#define NX_PAGE_LOCK          0x00000001
#define NX_PAGE_RESERVE       0x00000020
#define NX_PAGE_COMMIT        0x00000040
#define NX_PAGE_PHYSICAL      0x00000080
#define NX_PAGE_RESERVE_ONLY  0x00000100

/* final values for memory control flags... */
#define NX_MEM_UNLOCK         0x00000000
#define NX_MEM_LOCK           0x00000001
#define NX_MEM_DECOMMIT       0x00000020
#define NX_MEM_COMMIT         0x00000040
#define NX_MEM_RESERVE        0x00000100


#ifdef __cplusplus
extern "C" {
#endif

/* Memory management... */
void *NXMemAlloc  ( size_t size, size_t alignment );
int   NXMemCtl    ( void *start, size_t size, unsigned long flags );
void  NXMemFree   ( void *memory );
void *NXMemRealloc( void *old, size_t newSize, size_t alignment );
void *NXPageAlloc ( size_t pageCount, unsigned long flags );
void  NXPageFree  ( void *memory);

#ifdef __cplusplus
}
#endif

#endif
