#ifndef __nks_netware_h__
#define __nks_netware_h__
/*=============================================================================
=  Novell Software Development Kit
=
=  Copyright (C) 1999-2002 Novell, Inc. All Rights Reserved.
=
=  This work is subject to U.S. and international copyright laws and treaties.
=  Use and redistribution of this work is subject  to  the  license  agreement
=  accompanying  the  software  development kit (SDK) that contains this work.
=  However, no part of this work may be revised and/or  modified  without  the
=  prior  written consent of Novell, Inc. Any use or exploitation of this work
=  without authorization could subject the perpetrator to criminal  and  civil
=  liability. 
=
=  Source(s): Novell Header
=
=  nks/netware.h
===============================================================================
*/
#include <nks/defs.h>
#include <nks/fsio.h>


#include <pshpack1.h>

#include <poppack.h>


#ifdef __cplusplus
extern "C"
{
#endif

/*-----------------------------------------------------------------------------
** The following are unofficial NKS interfaces and can only be used on NetWare.
**-----------------------------------------------------------------------------
*/
void     nxCancelCheck( void );
void     nxCancelDisable( void );
void     nxCancelEnable( void );
int      nxContextFlushName( NXContext_t *context );
int      nxExportInterface( void *funcAddr, const char *funcName );
int      nxExportInterfaceWrapped( void *funcAddr, int stackWords,
            const char *funcName, void **reference );
char   **nxGetEnviron( void );
NXBool_t nxIsLoadedProtected( void );
NXBool_t nxIsProtectedAddress( void * );
size_t   nxMemGetSize( void *block );
void     nxUnexportInterfaceWrapped( void *reference );

/* wrap/unwrap sobriquets... */
#define NX_WRAP_INTERFACE(func, sWords, ref) \
				nxExportInterfaceWrapped(func, sWords, (const char *) NULL, ref)
#define NX_UNWRAP_INTERFACE(ref)             \
				nxUnexportInterfaceWrapped(ref)

#ifdef __cplusplus
}
#endif

#endif
