#ifndef __nks_plat_h__
#define __nks_plat_h__
/*============================================================================
=  Novell Software Development Kit
=
=  Copyright (C) 1999-2002 Novell, Inc. All Rights Reserved.
=
=  This work is subject to U.S. and international copyright laws and treaties.
=  Use and redistribution of this work is subject  to  the  license  agreement
=  accompanying  the  software  development kit (SDK) that contains this work.
=  However, no part of this work may be revised and/or  modified  without  the
=  prior  written consent of Novell, Inc. Any use or exploitation of this work
=  without authorization could subject the perpetrator to criminal  and  civil
=  liability.
=
=  Source(s): Novell Header
=
=  nks/plat.h
==============================================================================
*/
#include <nks/defs.h>


typedef int  NXCpuId_t;

#ifdef __cplusplus
extern "C"
{
#endif

/* Platform-specific services... */
size_t        NXGetCacheLineSize( void );
unsigned int  NXGetCpuCount( void );
NXCpuId_t     NXGetCpuId( void );
size_t        NXGetPageSize( void );
int           NXSeedRandom( size_t width, void *seed );
unsigned int  NXGetSystemTick( void );

#define  NX_SECONDS_TO_TICKS(x) (((x)*((uint64_t)1000000000))/NXGetSystemTick())
#define NX_MSECONDS_TO_TICKS(x) (((x)*((uint64_t)   1000000))/NXGetSystemTick())
#define NX_USECONDS_TO_TICKS(x) (((x)*((uint64_t)      1000))/NXGetSystemTick())
#define NX_NSECONDS_TO_TICKS(x) (((x)*((uint64_t)         1))/NXGetSystemTick())

#ifdef __cplusplus
}
#endif

#endif
