#ifndef __nks_synch_h__
#define __nks_synch_h__
/*============================================================================
=  Novell Software Development Kit
=
=  Copyright (C) 1999-2002 Novell, Inc. All Rights Reserved.
=
=  This work is subject to U.S. and international copyright laws and treaties.
=  Use and redistribution of this work is subject  to  the  license  agreement
=  accompanying  the  software  development kit (SDK) that contains this work.
=  However, no part of this work may be revised and/or  modified  without  the
=  prior  written consent of Novell, Inc. Any use or exploitation of this work
=  without authorization could subject the perpetrator to criminal  and  civil
=  liability. 
=
=  Source(s): Novell Header
=
=  nks/synch.h
==============================================================================
*/
#include <nks/defs.h>
#include <nks/thread.h>

#define NX_MUTEX_RECURSIVE 0x00000001
#define NX_RWLOCK_RD       0
#define NX_RWLOCK_WR       1


#include <pshpack1.h>

typedef int    NXHierarchy_t;

typedef struct
{
   uint64_t  reserved1;
   void     *reserved2[10];
} NXMutex_t;

typedef struct
{
   uint64_t  reserved1;
   void     *reserved2[10];
} NXRwLock_t;

typedef struct
{
   uint64_t  reserved1;
   void     *reserved2[5];
} NXSema_t;

typedef struct
{
   uint64_t  reserved1;
   void     *reserved2[5];
} NXCond_t;

typedef struct
{
   char          liName[NX_MAX_OBJECT_NAME_LEN+1];
   unsigned long liFlags;
   unsigned long liPad[2];
} NXLockInfo_t;

#include <poppack.h>

#ifdef __cplusplus
extern "C"
{
#endif

/* Mutexes... */
NXMutex_t  *NXMutexAlloc   (unsigned long flags, NXHierarchy_t hierarchy,
                             const NXLockInfo_t *info);
void        NXMutexDeinit  (NXMutex_t *mutex);
int         NXMutexDepth   (NXMutex_t *mutex);
void        NXMutexFree    (NXMutex_t *mutex);
int         NXMutexInit    (NXMutex_t *mutex, unsigned long flags,
                             NXHierarchy_t hierarchy, const NXLockInfo_t *info);
NXBool_t    NXMutexIsOwned (NXMutex_t *mutex);
NXBool_t    NXMutexTestFlag(NXMutex_t *mutex, unsigned long flag);
int         NXLock         (NXMutex_t *mutex);
NXBool_t    NXTryLock      (NXMutex_t *mutex);
int         NXUnlock       (NXMutex_t *mutex);

/* Reader-writer locks... */
NXRwLock_t *NXRwLockAlloc  (NXHierarchy_t hierarchy, const NXLockInfo_t *info);
void        NXRwLockDeinit (NXRwLock_t *lock);
void        NXRwLockFree   (NXRwLock_t *lock);
int         NXRwLockInit   (NXRwLock_t *lock, NXHierarchy_t hierarchy,
                             const NXLockInfo_t *info);
NXBool_t    NXRwLockIsOwned(NXRwLock_t *lock, unsigned long mode);
void        NXRdLock       (NXRwLock_t *lock);
void        NXWrLock       (NXRwLock_t *lock);
NXBool_t    NXTryRdLock    (NXRwLock_t *lock);
NXBool_t    NXTryWrLock    (NXRwLock_t *lock);
void        NXRwUnlock     (NXRwLock_t *lock);

int         NXRwLockUpgrade(NXRwLock_t *lock);
int         NXRwLockDowngrade(NXRwLock_t *lock);

/* Semaphores... */
NXSema_t   *NXSemaAlloc    (unsigned int count, void *arg);
void        NXSemaDeinit   (NXSema_t *sema);
void        NXSemaFree     (NXSema_t *sema);
int         NXSemaInit     (NXSema_t *sema, unsigned int count, void *arg);
void        NXSemaPost     (NXSema_t *sema);
NXBool_t    NXSemaTryWait  (NXSema_t *sema);
void        NXSemaWait     (NXSema_t *sema);

/* Condition variables... */
NXCond_t   *NXCondAlloc    (void *arg);
void        NXCondBroadcast(NXCond_t *cond);
void        NXCondDeinit   (NXCond_t *cond);
void        NXCondFree     (NXCond_t *cond);
int         NXCondInit     (NXCond_t *cond, void *arg);
void        NXCondSignal   (NXCond_t *cond);
int         NXCondWait     (NXCond_t *cond, NXMutex_t *mutex);
int         NXCondTimedWait(NXCond_t *cond, NXMutex_t *mutex, 
                             unsigned long interval);

#ifdef NDEBUG
# define NX_LOCK_INFO_ALLOC(var, name, flags)
# define NXMutexAlloc(flags, h, info)          (NXMutexAlloc)(flags, 0, NULL)
# define NXMutexInit(m, flags, h, info)        (NXMutexInit)(m, flags, 0, NULL)
# define NXRwLockAlloc(h, info)                (NXRwLockAlloc)(0, NULL)
# define NXRwLockInit(l, h, info)              (NXRwLockInit)(l, 0, NULL)
#else
# include <assert.h>
# define NX_LOCK_INFO_ALLOC(var, name, flags)  NXLockInfo_t var = {name, flags}
# define NXLock(m)                                                             \
   ((!NXMutexTestFlag(m, NX_MUTEX_RECURSIVE) && NXMutexIsOwned(m))             \
      ? _assert_expr(1, "Mutex used recursively", FUNCNAME, __FILE__, __LINE__)\
      : (NXLock)(m))
# define NXTryLock(m)                                                          \
   ((!NXMutexTestFlag(m, NX_MUTEX_RECURSIVE) && NXMutexIsOwned(m))             \
      ? _assert_expr(1, "Mutex used recursively", FUNCNAME, __FILE__, __LINE__)\
      : (NXTryLock)(m))
# define NXUnlock(m)                                                           \
   ((NXMutexDepth(m) < 1)                                                      \
      ? _assert_expr(1, "Unheld mutex unlocked", FUNCNAME, __FILE__, __LINE__) \
      : (NXUnlock)(m))
#endif

#define _LOCKSTAT

#ifdef __cplusplus
}
#endif

#endif
