#ifndef __nks_thread_h__
#define __nks_thread_h__
/*============================================================================
=  Novell Software Development Kit
=
=  Copyright (C) 1999-2002 Novell, Inc. All Rights Reserved.
=
=  This work is subject to U.S. and international copyright laws and treaties.
=  Use and redistribution of this work is subject  to  the  license  agreement
=  accompanying  the  software  development kit (SDK) that contains this work.
=  However, no part of this work may be revised and/or  modified  without  the
=  prior  written consent of Novell, Inc. Any use or exploitation of this work
=  without authorization could subject the perpetrator to criminal  and  civil
=  liability.
=
=  Source(s): Novell Header
=
=  nks/thread.h
==============================================================================
*/
#include <nks/defs.h>
#include <nks/plat.h>
#include <nks/time.h>

/* values for thread priority... */
#define NX_PRIO_HIGH          10
#define NX_PRIO_MED           5
#define NX_PRIO_LOW           1
#define NX_PRIO_DEFAULT       NX_PRIO_MED

/* values for thread context flags... */
#define NX_CTX_NORMAL         0x00000000  /* normal thread                  */
#define NX_CTX_WORK           0x00000001  /* context for work-to-do thread  */

/* values for thread flags... */
#define NX_THR_JOINABLE       0x00000000  /* default thread type            */
#define NX_THR_DETACHED       0x00000010  /* thread cannot be joined        */
#define NX_THR_SUSPENDED      0x00000020  /* thread starts out suspended    */
#define NX_THR_DAEMON         0x00000040  /* detached and non-persistent    */
#define NX_THR_BIND_CONTEXT   0x00000080  /* context disappears with thread */
#define NX_THR_MASK           0x000000F0

/* value returned that specifies that the thread is unbound */
#define NX_THR_UNBOUND        ((NXCpuId_t) 0xFFFFFFFF)

/* value passed to NXThreadBind to bind it to the current CPU */
#define NX_MYCPUID            ((NXCpuId_t) 0xFFFFFFFE)

/* return from NXThreadGetId indicating no-context or other error */
#define NX_INVALID_THREAD_ID  ((NXThreadId_t) 0xFFFFFFFF)

#include <pshpack1.h>

typedef void     *NXContext_t;
typedef int       NXWorkId_t;
typedef int       NXKey_t;
typedef int       NXThreadId_t;
typedef int       NXInterruptId_t;
typedef uint64_t  NXInterruptSet_t;

typedef enum
{
   NX_CTXSTATE_INIT    = 0xFFFFFFFF,
   NX_CTXSTATE_BOUND   = 0x00000001,
   NX_CTXSTATE_UNBOUND = 0x00000000
} NXContextState_t;

typedef struct
{
   NXContextState_t   ciState;
   void             (*ciFunc)( void * );
   void              *ciArg;
   int                ciPriority;
   size_t             ciStackSize;
   unsigned long      ciFlags;
} NXContextInfo_t;

typedef struct lwWork
{
   void  *reserved[7];
   void (*lwWorkFunc)( struct lwWork *, void * );
   void  *lwAppRef;
} NXLwWork_t;

#include <poppack.h>

#ifdef __cplusplus
extern "C"
{
#endif

/* Context management... */
NXContext_t  NXContextAlloc(void (*start_routine)(void *arg), void *arg,
               int priority, size_t stackSize, unsigned long flags, int *error);
int          NXContextFree(NXContext_t ctx);
NXContext_t  NXContextGet(void);
int          NXContextGetInfo(NXContext_t ctx, NXContextInfo_t *info);
int          NXContextGetName(NXContext_t ctx, char *name, size_t len );
int          NXContextReinit(NXContext_t ctx,
               void (*start_routine)(void *arg), void *arg, int priority,
               unsigned long flags);
int          NXContextSetName(NXContext_t ctx, const char *name );

/* Key-value pairs (per-context data)... */
int          NXKeyCreate(void (*destructor)(void *), void *value, NXKey_t *key);
int          NXKeyDelete(NXKey_t key);
int          NXKeyGetValue(NXKey_t key, void **value);
int          NXKeySetValue(NXKey_t key, void *value);

/* Thread management... */
int          NXThreadBind(NXCpuId_t cpu_id);
int          NXThreadContinue(NXThreadId_t tid);
int          NXThreadCreate(NXContext_t ctx, unsigned long flags,
               NXThreadId_t *idp);
int          NXThreadCreateSx(void (*start_routine)(void *arg), void *arg,
               unsigned long thread_flags, NXContext_t *ctx, NXThreadId_t *thr);
void         NXThreadDelay(unsigned long delay);
int          NXThreadDestroy(NXThreadId_t tid);
int          NXThreadDetach(NXThreadId_t tid);
void         NXThreadExit(void *status);
NXCpuId_t    NXThreadGetBinding(void);
int          NXThreadGetContext(NXThreadId_t tid, NXContext_t *ctx);
NXThreadId_t NXThreadGetId(void);
int          NXThreadGetPriority(NXThreadId_t tid, int *priority);
int          NXThreadInterrupt(NXThreadId_t tid, NXInterruptId_t interId);
NXBool_t     NXThreadIsInterrupted(NXInterruptSet_t *set);
int          NXThreadJoin(NXThreadId_t wait_for,
               NXThreadId_t *departed_thread, void **status);
int          NXThreadSetPriority(NXThreadId_t tid, int priority);
int          NXThreadSuspend(NXThreadId_t tid);
int          NXThreadSwapContext(NXContext_t newctx, NXContext_t *prevctx);
int          NXThreadUnbind(void);
void         NXThreadYield(void);
int          nxThreadCreate(void (*start_routine)(void *arg),
               unsigned long flags, void *arg, NXContext_t *ctxp,
               NXThreadId_t *idp);

/* Work-to-dos... */
int          NXDelayedWorkSchedule(NXContext_t ctx, NXTimerVal_t *timerval,
               NXBool_t bind, NXWorkId_t *wid);
int          NXLwWorkCancel(NXLwWork_t *work);
int          NXLwWorkSchedule(void *reserved, NXLwWork_t *work, NXBool_t bind);
int          NXWorkCancel(NXWorkId_t wid, NXBool_t wait, NXBool_t *status);
int          NXWorkSchedule(NXContext_t context, NXBool_t bind,NXWorkId_t *wid);

/* Miscellaneous... */
NXBool_t     NXProcessInterruptSet(NXInterruptSet_t *set, NXInterruptId_t id,
               NXInterruptId_t *processed_id);

#ifdef __cplusplus
}
#endif

#define __SYS_ALLOCD_STACK 0

#define NX_THREAD_CREATE(start_func,create_flags,arg,ctx,thr,err)           \
{                                                                           \
   if (ctx = NXContextAlloc((void (*)(void *)) start_func, arg,             \
               NX_PRIO_MED, __SYS_ALLOCD_STACK, NX_CTX_NORMAL, &err))       \
   {                                                                        \
      if (err = NXThreadCreate(ctx, create_flags|NX_THR_BIND_CONTEXT, &thr))\
         NXContextFree(ctx);                                                \
   }                                                                        \
}

#endif
