#ifndef __nks_time_h__
#define __nks_time_h__
/*============================================================================
=  Novell Software Development Kit
=
=  Copyright (C) 1999-2002 Novell, Inc. All Rights Reserved.
=
=  This work is subject to U.S. and international copyright laws and treaties.
=  Use and redistribution of this work is subject  to  the  license  agreement
=  accompanying  the  software  development kit (SDK) that contains this work.
=  However, no part of this work may be revised and/or  modified  without  the
=  prior  written consent of Novell, Inc. Any use or exploitation of this work
=  without authorization could subject the perpetrator to criminal  and  civil
=  liability.
=
=  Source(s): Novell Header
=
=  nks/time.h
==============================================================================
*/
#include <nks/defs.h>

/* values for 'epoch' for NXGetTime()... */
#define NX_SINCE_BOOT   0
#define NX_SINCE_1970   1

/* values for 'units' for NXGetTime()... */
#define NX_TICKS        (-1)
#define NX_SECONDS      0
#define NX_MSECONDS     1000
#define NX_USECONDS     1000000
#define NX_NSECONDS     1000000000

#include <pshpack1.h>

typedef uint64_t    NXTime_t;

typedef struct
{
   unsigned long    tvPeriod;
   unsigned long    tvCurrent;
} NXTimerVal_t;

typedef struct
{
   unsigned long    reserved1[4];
   void           (*toRoutine)(void *);
   void            *toArg;
   NXTimerVal_t     toTimerVal;
   unsigned long    reserved2[16];
} NXTimeOut_t;

#include <poppack.h>

#ifdef __cplusplus
extern "C"
{
#endif

/* Time and time-out... */
int   NXTimeOutCancel  ( NXTimeOut_t *tout, NXBool_t wait, NXBool_t *status );
int   NXTimeOutSchedule( NXTimeOut_t *tout );
int   NXGetTime        ( int epoch, int units, NXTime_t *time );

#ifdef __cplusplus
}
#endif

#endif
