#ifndef __nks_unix_h__
#define __nks_unix_h__
/*============================================================================
=  Novell Software Development Kit
=
=  Copyright (C) 1999-2002 Novell, Inc. All Rights Reserved.
=
=  This work is subject to U.S. and international copyright laws and treaties.
=  Use and redistribution of this work is subject  to  the  license  agreement
=  accompanying  the  software  development kit (SDK) that contains this work.
=  However, no part of this work may be revised and/or  modified  without  the
=  prior  written consent of Novell, Inc. Any use or exploitation of this work
=  without authorization could subject the perpetrator to criminal  and  civil
=  liability.
=
=  Source(s): Novell Header
=
=  nks/unix.h
==============================================================================
*/
#include <time.h>
#include <nks/dirio.h>

#include <pshpack1.h>

typedef struct               /* UNIX (NX_PNF_UNIX) attributes          */
{
   NXDeHeader_t xdeHeader;
   NXFid_t      xdeFid;
   uint32_t     xdeEffectiveRights;

   unsigned long xde_mode;   /* file mode                              */
   unsigned long xde_nlink;  /* number of links                        */
   uint32_t          spare1;
   time_t        xde_atime;  /* last access time (files only)          */
   time_t        xde_mtime;  /* last modify time                       */
   time_t        xde_btime;  /* last archive time                      */
   time_t        xde_ctime;  /* last attribute change time (or 0)      */
   uint64_t      xde_change; /* generation; bumped when file modified  */
   uint64_t      xde_ino;    /* entry serial number                    */
   uint64_t      xde_dev[2]; /* file system (device) containing entry  */
   uint64_t      xde_rdev[2];/* ID of raw device containing this entry */
   uint64_t      xde_uid;    /* user ID of the owner of this entry     */
   uint64_t      xde_gid;    /* group ID of the group of this entry    */
   uint64_t      xde_size;   /* length of file in bytes                */
   uint64_t      xde_blocks; /* number of 512-byte blocks allocated    */
   unsigned long xde_blksize;/* preferred I/O block size               */
   uint32_t          spare2;
   uint64_t          spare3;
   uint64_t          spare4;
   uint64_t          spare5;
   uint64_t          spare6;
   uint64_t          spare7;
   uint64_t          spare8;
} NXDirAttrUnix_t;

typedef struct               /* UNIX (NX_PNF_UNIX) information...      */
{                            /* ...including name                      */
   NXDirAttrUnix_t deUnixDirAttr;
   NXDirMark_t     deDirMark;
   void           *deName;   /* maximum length is 255 characters       */
} NXDirEnumUnix_t;

#include <poppack.h>

#endif
