#ifndef __nks_vm_h__
#define __nks_vm_h__
/*============================================================================
=  Novell Software Development Kit
=
=  Copyright (C) 1999-2002 Novell, Inc. All Rights Reserved.
=
=  This work is subject to U.S. and international copyright laws and treaties.
=  Use and redistribution of this work is subject  to  the  license  agreement
=  accompanying  the  software  development kit (SDK) that contains this work.
=  However, no part of this work may be revised and/or  modified  without  the
=  prior  written consent of Novell, Inc. Any use or exploitation of this work
=  without authorization could subject the perpetrator to criminal  and  civil
=  liability.
=
=  Source(s): Novell Header
=
=  nks/vm.h
==============================================================================
*/
#include <nks/defs.h>
#include <nks/fsio.h>
#include <nks/thread.h>

/* value for 'wait_for' in NXVmJoin()... */
#define NX_VM_JOIN_ANY           (-1)

/* values for 'flags' in NXVmSpawn()... */
#define NX_VM_DETACHED           0x00000001 /* (default is joinable)         */
#define NX_VM_INHERIT_ENV        0x00000002 /* inherit environment variables */
#define NX_VM_SAME_ADDRSPACE     0x00000004 /* starts in same address space  */

#define NX_VM_CREATE_DETACHED    NX_VM_DETACHED

/* returned in newVm if NXVmSpawn() is passed NX_VM_DETACHED or if it fails */
#define NX_VM_INVALID_ID         0

#include <pshpack1.h>

typedef enum
{
   NX_STR_ASCII   = 0xFFFFFFFF,
   NX_STR_UTF8    = 0x00000000,
   NX_STR_UNICODE = 0x00000001
} NXStrType_t;

typedef struct
{
   NXObjType_t  ssType;     /* NX_OBJ_FILE, NX_OBJ_CONSOLE, NX_OBJ_FIFO, etc.*/
   int          ssReserved; /* set to 0                                      */
   NXPathCtx_t  ssPathCtx;  /* ancestor of 'ssPath'                          */
   void        *ssPath;     /* relative to 'ssPathCtx'                       */
} NXNameSpec_t, NXStreamSpec_t;

typedef struct
{
   int             esFlags; /* unused; set to 0                              */
   int             esArgc;  /* count of arguments in 'esArgv'                */
   void          **esArgv;  /* command-line arguments to spawned VM          */
   void          **esEnv;   /* starting environment of spawned VM            */
   NXStreamSpec_t  esStdin; /* wiring of standard input for spawned VM       */
   NXStreamSpec_t  esStdout;/* wiring of standard output for spawned VM      */
   NXStreamSpec_t  esStderr;/* wiring of standard error for spawned VM       */
} NXExecEnvSpec_t;

typedef struct
{
   size_t      wtcThreads;  /* maxmimum number of threads in worker pool     */
   int         reserved[5]; /* implementation-reserved                       */
} NXVmWorkerThreadConfig_t;

#include <poppack.h>

#ifdef __cplusplus
extern "C"
{
#endif

/* Virtual machine management... */
int      NXVmDestroy( NXVmId_t id );
void     NXVmExit( int status ) ;
NXVmId_t NXVmGetId( void );
int      NXVmGetWorkerThreadConfig( void *reserved,
            NXVmWorkerThreadConfig_t *config );
int      NXVmGetStringType( NXStrType_t *type );
int      NXVmJoin( NXVmId_t wait_for, NXVmId_t *departed_vm, int *status );
int      NXVmRegisterExitHandler( void (*cleanup)( void * ), void *arg );
int      NXVmSetWorkerThreadConfig( void *reserved,
            NXVmWorkerThreadConfig_t *config );
int      NXVmSpawn( NXNameSpec_t *name, NXExecEnvSpec_t *envSpec,
            unsigned long flags, NXVmId_t *newVm );
int      NXVmUnregisterExitHandler( void (*func)( void * ), void *arg );


#ifdef __cplusplus
}
#endif

#endif
