#ifndef __nl_types_h__
#define __nl_types_h__
/*============================================================================
=  Novell Software Development Kit
=
=  Copyright (C) 1999-2003 Novell, Inc. All Rights Reserved.
=
=  This work is subject to U.S. and international copyright laws and treaties.
=  Use and redistribution of this work is subject  to  the  license  agreement
=  accompanying  the  software  development kit (SDK) that contains this work.
=  However, no part of this work may be revised and/or  modified  without  the
=  prior  written consent of Novell, Inc. Any use or exploitation of this work
=  without authorization could subject the perpetrator to criminal  and  civil
=  liability.
=
=  Source(s): IEEE Std 1003.1-2001; Single UNIX Specification
=
=  nl_types.h
==============================================================================
*/
#include <stddef.h>

/* 'set_id' value for catgets()... */
#define NL_SETD         1

/* 'oflag' value for catopen()... */
#define NL_CAT_DEFAULT  0  /* base on value of environment variable "LANG" */
#define NL_CAT_LOCALE   1  /* base on LC_MESSAGES in effect */


#define _NL_ITEM
typedef int nl_item;

#define _NL_CATD
typedef int nl_catd;


#ifdef __cplusplus
extern "C" {
#endif

int      catclose( nl_catd catd );
char    *catgets ( nl_catd catd, int set_id, int msg_id, const char *string );
nl_catd  catopen ( const char *name, int oflag );

#ifdef __cplusplus
}
#endif

#endif
