#ifndef __nlmformat_h__
#define __nlmformat_h__
/*=============================================================================
=  Novell Software Development Kit
=
=  Copyright (C) 1993-2002 Novell, Inc. All Rights Reserved.
=
=  This work is subject to U.S. and international copyright laws and treaties.
=  Use and redistribution of this work is subject  to  the  license  agreement
=  accompanying  the  software  development kit (SDK) that contains this work.
=  However, no part of this work may be revised and/or  modified  without  the
=  prior  written consent of Novell, Inc. Any use or exploitation of this work
=  without authorization could subject the perpetrator to criminal  and  civil
=  liability. 
=
=  Source(s): Novell header
=
=  nlmformat.h
===============================================================================
=  There is no purpose to including this header. It is a description of the NLM
=  file format for information purposes only.
=
=  NetWare Tool Maker Specification, edition 1.0, (C) 1993 by Novell, Inc.
===============================================================================
*/
#include <stdint.h>


typedef struct
{                                         // offset in structure --------------
   char     signature[24];                // "NetWare Loadable Modulex\1A"
   uint32_t version;                      // 0x0018 ---------------------------
   char     moduleName[14];               // 0x001C ---------------------------
   uint32_t codeImageOffset;              // 0x002A ---------------------------
   uint32_t codeImageSize;                // 0x002E ---------------------------
   uint32_t dataImageOffset;              // 0x0032 ---------------------------
   uint32_t dataImageSize;                // 0x0036 ---------------------------
   uint32_t uninitializedDataSize;        // 0x003A ---------------------------
   uint32_t customDataOffset;             // 0x003E ---------------------------
   uint32_t customDataSize;               // 0x0042 ---------------------------
   uint32_t moduleDependencyOffset;       // 0x0046 ---------------------------
   uint32_t numberOfModuleDependencies;   // 0x004A ---------------------------
   uint32_t relocationFixupOffset;        // 0x004E ---------------------------
   uint32_t numberOfRelocationFixups;     // 0x0052 ---------------------------
   uint32_t externalReferencesOffset;     // 0x0056 ---------------------------
   uint32_t numberOfExternalReferences;   // 0x005A ---------------------------
   uint32_t publicsOffset;                // 0x005E ---------------------------
   uint32_t numberOfPublics;              // 0x0062 ---------------------------
   uint32_t debugInfoOffset;              // 0x0066 ---------------------------
   uint32_t numberOfDebugRecords;         // 0x006A ---------------------------
   uint32_t codeStartOffset;              // 0x006E ---------------------------
   uint32_t exitProcedureOffset;          // 0x0072 ---------------------------
   uint32_t checkUnloadProcedureOffset;   // 0x0076 ---------------------------
   uint32_t moduleType;                   // 0x007A ---------------------------
   uint32_t flags;                        // 0x007E ---------------------------
   uint8_t  descriptionLength;            // 0x0082 ---------------------------
   char     descriptionText[127];         // 0x0083 ---------------------------
#           define MAX_DESCRIPTION_LENGTH   128
   uint32_t stackSize;                    // 0x0103 ---------------------------
   uint32_t reserved;                     // 0x0107 ---------------------------
   uint8_t  reserved2[5];                 // 0x010B ---------------------------
#           define OLD_THREAD_NAME_LENGTH   5    // (used always to be " LONG")
   uint8_t  screenNameLength;             // 0x0110 ---------------------------
   char     screenName[71];               // 0x0111 ---------------------------
#           define MAX_SCREEN_NAME_LENGTH   71
   uint8_t  threadNameLength;             // 0x0158 ---------------------------
   char     threadName[71];               // 0x015C ---------------------------
#           define MAX_THREAD_NAME_LENGTH   71
   uint8_t  otherData[400];               // 0x01A3 ---------------------------
} NLM_HEADER;                             // (note: length not actually 0x0333)


typedef struct
{                                         // offset in structure --------------
   char     VeRsIoN[8];                   // 0x0000 "VeRsIoN"
   uint32_t majorVersion;                 // 0x0008 ---------------------------
   uint32_t minorVersion;                 // 0x000C ---------------------------
   uint32_t revision;                     // 0x0010 ---------------------------
   uint32_t year;                         // 0x0014 ---------------------------
   uint32_t month;                        // 0x0018 ---------------------------
   uint32_t day;                          // 0x001A ---------------------------
} VERSION_MASK;                           // 0x0020 (structure length)


typedef struct
{                                         // offset in structure --------------
   char     CoPyRiGhT[10];                // 0x0000 "CoPyRiGhT"
   uint8_t  copyrightLength;              // 0x000A ---------------------------
   char     copyright[252];               // 0x000B ---------------------------
} COPYRIGHT_MASK;                         // 0x0107 (structure length)


typedef struct
{                                         // offset in structure --------------
   uint8_t  CuStHeAd[8];                  // 0x0000 "CuStHeAd"
} CUSTOM_HEADER_MASK;                     // (note: length is custom)


typedef struct
{                                         // offset in structure --------------
   char     MeSsAgEs[8];                  // 0x0000 "MeSsAgEs"
   uint32_t languageID;                   // 0x0008 ---------------------------
   uint32_t messageFileOffset;            // 0x000C ---------------------------
   uint32_t messageFileLength;            // 0x0010 ---------------------------
   uint32_t messageCount;                 // 0x0014 ---------------------------
   uint32_t helpFileOffset;               // 0x0018 ---------------------------
   uint32_t helpFileLength;               // 0x001C ---------------------------
   uint32_t RPCDataOffset;                // 0x0020 ---------------------------
   uint32_t RPCDataLength;                // 0x0024 ---------------------------
   uint32_t sharedCodeOffset;             // 0x0028 (ignore to end of structure
   uint32_t sharedCodeLength;             // 0x0030  ...all these are either no
   uint32_t sharedDataOffset;             // 0x0034  longer used or never have
   uint32_t sharedDataLength;             // 0x0038  been)
   uint32_t sharedRelocationFixupOffset;  // 0x003C ---------------------------
   uint32_t sharedRelocationFixupLength;  // 0x0040 ---------------------------
   uint32_t sharedExternalReferenceOffset;// 0x0044 ---------------------------
   uint32_t sharedExternalReferenceCount; // 0x0048 ---------------------------
   uint32_t sharedPublicsOffset;          // 0x004C ---------------------------
   uint32_t sharedPublicsCount;           // 0x0050 ---------------------------
   uint32_t sharedDebugRecordOffset;      // 0x0054 ---------------------------
   uint32_t sharedDebugRecordCount;       // 0x0058 ---------------------------
   uint32_t (*sharedInitializationOffset)( void );
   void     (*sharedExitProcedureOffset)( void );
   uint32_t productID;                    // 0x0064 ---------------------------
   uint32_t reserved0;                    // 0x0068 ---------------------------
   uint32_t reserved1;                    // 0x006C ---------------------------
   uint32_t reserved2;                    // 0x0070 ---------------------------
   uint32_t reserved3;                    // 0x0074 ---------------------------
   uint32_t reserved4;                    // 0x0078 ---------------------------
   uint32_t reserved5;                    // 0x007C ---------------------------
} EXTENDED_HEADER;                        // 0x0080 (structure length)


#endif
