#ifndef __nwieeefp_h__
#define __nwieeefp_h__
/*============================================================================
=  Novell Software Development Kit
=
=  Copyright (C) 1999-2002 Novell, Inc. All Rights Reserved.
=
=  This work is subject to U.S. and international copyright laws and treaties.
=  Use and redistribution of this work is subject  to  the  license  agreement
=  accompanying  the  software  development kit (SDK) that contains this work.
=  However, no part of this work may be revised and/or  modified  without  the
=  prior  written consent of Novell, Inc. Any use or exploitation of this work
=  without authorization could subject the perpetrator to criminal  and  civil
=  liability. 
=
=  Source(s): Novell Header
=
=  nwieeefp.h
==============================================================================
*/
#include <stddef.h>

#define fp_except int
#define FP_X_INV  0x01 /* invalid operation exception   */
#define FP_X_DNML 0x02 /* denormal operation exception  */
#define FP_X_DZ   0x04 /* divide by zero exception      */
#define FP_X_OFL  0x08 /* overflow exception            */
#define FP_X_UFL  0x10 /* underflow exception           */
#define FP_X_IMP  0x20 /* inexact (precision) exception */

#include <pshpack1.h>

typedef enum fp_rnd
{
   FP_RN = 0,  /* round to nearest representable number, tie -> even */
   FP_RM = 1,  /* round toward minus infinity                        */
   FP_RP = 2,  /* round toward plus infinity                         */
   FP_RZ = 3   /* round toward zero (truncate)                       */
} fp_rnd;

#include <poppack.h>

#ifdef __cplusplus
extern "C"
{
#endif

fp_except fpgetmask  ( void ); 
fp_rnd    fpgetround ( void );
fp_except fpgetsticky( void ); 
fp_except fpsetmask  ( fp_except newmask ); 
fp_rnd    fpsetround ( fp_rnd newround );
fp_except fpsetsticky( fp_except newsticky );

#ifdef __cplusplus
}
#endif

#endif
