#ifndef __nwsnut_h__
#define __nwsnut_h__
/*============================================================================
=  Novell Software Development Kit
=
=  Copyright (C) 1999-2002 Novell, Inc. All Rights Reserved.
=
=  This work is subject to U.S. and international copyright laws and treaties.
=  Use and redistribution of this work is subject  to  the  license  agreement
=  accompanying  the  software  development kit (SDK) that contains this work.
=  However, no part of this work may be revised and/or  modified  without  the
=  prior  written consent of Novell, Inc. Any use or exploitation of this work
=  without authorization could subject the perpetrator to criminal  and  civil
=  liability.
=
=  Source(s): Novell Header
=
=  nwsnut.h
==============================================================================
*/
#ifndef _NUT_INCLUDED_
#define _NUT_INCLUDED_
#ifndef __NWSNUT_H__
#define __NWSNUT_H__
#include <netware.h>

/*
** This version of nwsnut.h has been reworked to interoperate with LibC
** and conform more realistically to standard C programming without lots
** type coercion as was necessary with the old one. The original version
** of this file is distributed in the original NetWare SDK for C, download
** NLM User Interface Developer Components (NWSNUT).
*/
#ifndef LONG
#define LONG unsigned long
#endif

#ifndef WORD
#define WORD unsigned short
#endif

#ifndef BYTE
#define BYTE unsigned char
#endif

#ifndef NULL
#define NULL 0
#endif



/* constants... */

/*
** The constant CURRENT_NUT_VERSION is incremented when increased
** functionality is added. An NLM can check this value which is placed
** in the NUTInfo structure, version field, to determine if the NWSNUT
** NLM contains sufficient functionality to support its requirements.
*/
#define CURRENT_NUT_VERSION   405

/*
** The constant NUT_REVISION_LEVEL is incremented when a major change in
** the behavior of NWSNUT is made. This value is not used by the calling
** NLM, but rather by NWSNUT itself to determine what is expected of it
** by the calling NLM.
*/
#define NUT_REVISION_LEVEL    1

#define SAVE                  1
#define NO_SAVE               0
#define NOHEADER              0
#define NOBORDER              0
#define NO_HELP_CONTEXT       0xFFFF
#define SINGLE                1
#define DOUBLE                2
#define CURSOR_OFF            0
#define CURSOR_ON             1
#define VIRTUAL               0
#define DIRECT                1

/* new version of severity defines that don't conflict with event.h... */
#define NUT_SEVERITY_INFORM   1
#define NUT_SEVERITY_WARNING  2
#define NUT_SEVERITY_FATAL    3

#ifndef SEVERITY_WARNING /* event.h hasn't been included--so no conflicts */
# define SEVERITY_INFORM      NUT_SEVERITY_INFORM
# define SEVERITY_WARNING     NUT_SEVERITY_WARNING
# define SEVERITY_FATAL       NUT_SEVERITY_FATAL
#endif

/* text size minimization styles */
#define SNORMAL               0
#define SMINWIDTH             1
#define SMINHEIGHT            2


/*
** Palettes to set screen colors; background and foreground can be reversed
** with VREVERSE.
*/
#define BW_PALETTE      0  /* white and black */
#define NORMAL_PALETTE  1  /* white and dark blue */
#define INIT_PALETTE    2  /* light blue and dark blue */
#define HELP_PALETTE    3  /* green and black */
#define ERROR_PALETTE   4  /* red and black */
#define WARNING_PALETTE 5  /* pink and white */
#define OTHER_PALETTE   6  /* green and red */


/* text and portal justification styles */
#define JRIGHT          0
#define JLEFT           1
#define JTOP            2
#define JBOTTOM         3
#define JCENTER         4
#define JTOPRIGHT       5
#define JTOPLEFT        6
#define JBOTTOMLEFT     7
#define JBOTTOMRIGHT    8

/* video constants */
#define V_UP            6
#define V_DOWN          7
#define LINE_OFFSET     160
#define EXPLODE_RATE    45
#define SCREEN_SPEED    0

/* video attributes */
#define VNORMAL         0
#define VINTENSE        1
#define VREVERSE        2
#define VBLINK          3
#define VIBLINK         4
#define VRBLINK         5

/* header types */
#define NO_HEADER       0
#define SMALL_HEADER    1
#define NORMAL_HEADER   2
#define LARGE_HEADER    3

/* keyboard constants */
#define KS_OFF          0
#define KS_ON           1
#define KS_INT          2

#define K_NORMAL        0

#define K_F1            1
#define K_F2            2
#define K_F3            3
#define K_F4            4
#define K_F5            5
#define K_F6            6
#define K_F7            7
#define K_F8            8
#define K_F9            9
#define K_F10           10

#define K_SF1           11
#define K_SF2           12
#define K_SF3           13
#define K_SF4           14
#define K_SF5           15
#define K_SF6           16
#define K_SF7           17
#define K_SF8           18
#define K_SF9           19
#define K_SF10          20

#define K_CF1           21
#define K_CF2           22
#define K_CF3           23
#define K_CF4           24
#define K_CF5           25
#define K_CF6           26
#define K_CF7           27
#define K_CF8           28
#define K_CF9           29
#define K_CF10          30

#define K_AF1           31
#define K_AF2           32
#define K_AF3           33
#define K_AF4           34
#define K_AF5           35
#define K_AF6           36
#define K_AF7           37
#define K_AF8           38
#define K_AF9           39
#define K_AF10          40

#define K_HELP          1
#define K_MODIFY        3
#define K_MARK          5
#define K_CANCEL        7
#define K_MODE          9
#define K_EXIT          40

#define K_ESCAPE        41
#define K_BACK          42
#define K_INSERT        43
#define K_DELETE        44
#define K_SELECT        45
#define K_CYCLE         46
#define K_UP            47
#define K_DOWN          48
#define K_LEFT          49
#define K_RIGHT         50
#define K_SUP           51
#define K_SDOWN         52
#define K_SLEFT         53
#define K_SRIGHT        54
#define K_PUP           55
#define K_PDOWN         56
#define K_FRIGHT        57
#define K_FLEFT         58
#define K_DELETE_END    59

/*
** For NWSUngetKey() of function keys, use UGK_FUNCTION_KEY for the "type"
** parameter and "K_F1" etc. for the "value" parameter.
*/
#define UGK_NORMAL_KEY        0x00
#define UGK_FUNCTION_KEY      0x01

/*
** For other special keys listed below, use UGK_NORMAL_KEY for the "value"
** parameter, and the UGK_xxx for the "type" parameter.
*/
#define UGK_ENTER_KEY         0x02
#define UGK_ESCAPE_KEY        0x03
#define UGK_BACKSPACE_KEY     0x04
#define UGK_DELETE_KEY        0x05
#define UGK_INSERT_KEY        0x06
#define UGK_CURSOR_UP_KEY     0x07
#define UGK_CURSOR_DOWN_KEY   0x08
#define UGK_CURSOR_RIGHT_KEY  0x09
#define UGK_CURSOR_LEFT_KEY   0x0a
#define UGK_CURSOR_HOME_KEY   0x0b
#define UGK_CURSOR_END_KEY    0x0c
#define UGK_CURSOR_PUP_KEY    0x0d
#define UGK_CURSOR_PDOWN_KEY  0x0e

/*
** Added in version 403
**
** A special key type to cause LISTs to refresh. K_REFRESH_KEY may be
** returned from an action procedure passed to NWSList, or another thread
** that wishes to cause a list to refresh may call NWSUngetKey with the
** UGK version of this, and it too will cause the list to be redrawn.
**
** Use "type" = UGK_SPECIAL_KEY, and "value" = UGK_REFRESH_KEY.
*/
#define UGK_SPECIAL_KEY       3
#define UGK_REFRESH_KEY       0x22222222
#define K_REFRESH_KEY         UGK_REFRESH_KEY
#define OLD_REFRESH_KEY       222


/* available action keys for list */
#define M_ESCAPE           0x0001
#define M_INSERT           0x0002
#define M_DELETE           0x0004
#define M_MODIFY           0x0008
#define M_SELECT           0x0010
#define M_MDELETE          0x0020   /* marked delete */
#define M_CYCLE            0x0040
#define M_MMODIFY          0x0080   /* marked modify */
#define M_MSELECT          0x0100   /* marked select */
#define M_NO_SORT          0x0200   /* don't sort list */
#define M_REFRESH          0x0400   /* allow the list to be refreshed */

/* return values for EditString */
#define E_ESCAPE           1
#define E_SELECT           2
#define E_EMPTY            4
#define E_CHANGE           8

/* type values for EditString */
#define EF_ANY             0x0001L
#define EF_DECIMAL         0x0002L
#define EF_HEX             0x0004L
#define EF_NOSPACES        0x0008L
#define EF_UPPER           0x0010L
#define EF_DATE            0x0020L
#define EF_TIME            0x0040L
#define EF_FLOAT           0x0080L
#define EF_SET             0x0100L
#define EF_NOECHO          0x0200L
#define EF_FILENAME        0x0400L
#define EF_MASK            0x0800L  /* added in version 404 */
#define EF_NOCONFIRM_EXIT  0x1000L  /* and in version 405 */

/* NWSEditTextWithScrollBars() and NWSViewTextWithScrollBars */
/* which scroll bars to show */
#define SHOW_VERTICAL_SCROLL_BAR    2
#define SHOW_HORIZONTAL_SCROLL_BAR  4

/* when to show the scroll bars--use only one of these... */
#define CONSTANT_SCROLL_BARS        0x0200
#define TEXT_SENSITIVE_SCROLL_BARS  0x0400
#define CONSIDER_LOCKED_FIELDS      0x0800


/* character and key constants */
#define F_H1      NWSGetLineDrawCharacter(0)
#define F_H2      NWSGetLineDrawCharacter(1)    /*  */
#define F_V1      NWSGetLineDrawCharacter(2)    /*  */
#define F_V2      NWSGetLineDrawCharacter(3)    /*  */
#define F_UL1     NWSGetLineDrawCharacter(4)    /*  */
#define F_UR1     NWSGetLineDrawCharacter(5)    /*  */
#define F_LL1     NWSGetLineDrawCharacter(6)    /*  */
#define F_LR1     NWSGetLineDrawCharacter(7)    /*  */
#define F_UL2     NWSGetLineDrawCharacter(8)    /*  */
#define F_UR2     NWSGetLineDrawCharacter(9)    /*  */
#define F_LL2     NWSGetLineDrawCharacter(10)   /*  */
#define F_LR2     NWSGetLineDrawCharacter(11)   /*  */
#define F_UT1     NWSGetLineDrawCharacter(12)   /*  */
#define F_DT1     NWSGetLineDrawCharacter(13)   /*  */
#define F_LT1     NWSGetLineDrawCharacter(14)   /*  */
#define F_RT1     NWSGetLineDrawCharacter(15)   /*  */
#define F_UT2     NWSGetLineDrawCharacter(24)   /*  */
#define F_DT2     NWSGetLineDrawCharacter(25)   /*  */
#define F_LT2     NWSGetLineDrawCharacter(26)   /*  */
#define F_RT2     NWSGetLineDrawCharacter(27)   /*  */
#define F_X1      NWSGetLineDrawCharacter(36)   /*  */
#define F_X2      NWSGetLineDrawCharacter(39)   /*  */
#define F_UP      NWSGetLineDrawCharacter(40)   /*  */
#define F_DOWN    NWSGetLineDrawCharacter(41)   /*  */
#define F_LEFT    NWSGetLineDrawCharacter(42)   /*  */
#define F_RIGHT   NWSGetLineDrawCharacter(43)   /*  */
#define F_BG1     NWSGetLineDrawCharacter(44)   /*  */
#define F_BG2     NWSGetLineDrawCharacter(45)   /*  */
#define F_BG3     NWSGetLineDrawCharacter(46)   /*  */
#define F_BG4     NWSGetLineDrawCharacter(47)   /*  */


/* form constants (control flags) */
#define F_NOVERIFY         0x00
#define F_VERIFY           0x10
#define F_FORCE            0x20

/* a flag to pass if no help is desired in the form */
#define F_NO_HELP          0xFFFFFFFF

/* fieldFlags type masks **/
#define NORMAL_FIELD       0x00  /* normal editable field */
#define LOCKED_FIELD       0x01  /* non accessable */
#define SECURE_FIELD       0x02  /* non editable */
#define REQUIRED_FIELD     0x04  /* verify field on form exit */
#define HIDDEN_FIELD       0x09  /* hidden fields are also locked */
#define PROMPT_FIELD       0x11  /* prompt fields are also locked */
#define ULOCKED_FIELD      0x0100/* field locked by user, not by NUT */

/* MASKED_FIELD added in version 402 */
#define MASKED_FIELD       0x200 /* display '*' for text                */

/* flag to cause form deselection before action & verify routines are called */
#define FORM_DESELECT      0x20
#define NO_FORM_DESELECT   0x00  /* in case old flag was used */
#define DEFAULT_FORMAT     0x00  /* normal field controlled justify */
#define RIGHT_FORMAT       0x40  /* right justification format */
#define LEFT_FORMAT        0x80  /* left justification format */
#define CENTER_FORMAT      0xC0  /* centering format */

#define MAXPORTALS         50
#define MAXLISTS           20
#define SAVELISTS          20
#define MAXACTIONS         60
#define MAXFUNCTIONS       MAXACTIONS
#define MAXHELP            30

#define NO_MESSAGE               0xFFFF
#define DYNAMIC_MESSAGE_ONE      0xFFFE
#define DYNAMIC_MESSAGE_TWO      0xFFFD
#define DYNAMIC_MESSAGE_THREE    0xFFFC
#define DYNAMIC_MESSAGE_FOUR     0xFFFB
#define DYNAMIC_MESSAGE_FIVE     0xFFFA
#define DYNAMIC_MESSAGE_SIX      0xFFF9
#define DYNAMIC_MESSAGE_SEVEN    0xFFF8
#define DYNAMIC_MESSAGE_EIGHT    0xFFF7
#define DYNAMIC_MESSAGE_NINE     0xFFF6
#define DYNAMIC_MESSAGE_TEN      0xFFF5
#define DYNAMIC_MESSAGE_ELEVEN   0xFFF4
#define DYNAMIC_MESSAGE_TWELVE   0xFFF3
#define DYNAMIC_MESSAGE_THIRTEEN 0xFFF2
#define DYNAMIC_MESSAGE_FOURTEEN 0xFFF1
#define SYSTEM_MESSAGE           0x8000

#define IS_DYNAMIC_MESSAGE(a)    (a > 0xFFF0 && a < 0xFFFF)

#include <pshpack1.h>         /* we pack this by hand */

typedef struct                /* process-control block */
{
   LONG     frameLine;
   LONG     frameColumn;
   size_t   frameHeight;
   size_t   frameWidth;
   size_t   virtualHeight;    /* height of virtual screen */
   size_t   virtualWidth;     /* width of virtual screen */
   LONG     cursorState;
   LONG     borderType;
   LONG     borderAttribute;
   WORD     saveFlag;
   WORD     secondarySaveFlag;
   LONG     directFlag;
   LONG     headerAttribute;
   LONG     portalLine;       /* top-most line of portal */
   LONG     portalColumn;     /* left-most column of portal */
   size_t   portalHeight;
   size_t   portalWidth;
   LONG     virtualLine;      /* position of portal over virtual portal */
   LONG     virtualColumn;    /* position of portal over virtual portal */
   LONG     cursorLine;
   LONG     cursorColumn;
   LONG     firstUpdateFlag;
   char    *headerText;
   char    *headerText2;
   BYTE    *virtualScreen;
   BYTE    *saveScreen;

   /* no data beyond this point must ever be referenced by caller... */
   void   *reserved[16];
} PCB;

typedef struct
{
   LONG     nextScreen;
   LONG     previousScreen;
   LONG     frameLine;     /* Topmost line of frame on physical screen */
   LONG     frameColumn;   /* Leftmost column of frame on physical screen */
   size_t   frameHeight;   /* Height of frame on physical screen */
   size_t   frameWidth;    /* Width of frame on physical screen */
   size_t   virtualHeight; /* Height of virtual screen */
   size_t   virtualWidth;  /* Width of virtual screen */
   LONG     cursorState;   /* Is the cursor on or off (1 or 0) */
   LONG     borderType;    /* Type of border to use */
   LONG     borderAttribute;/* Attribute to use with border */
   LONG     saveFlag;      /* TRUE = save old screen */
   LONG     directFlag;    /* TRUE = no virtual screen */
   LONG     headerAttribute;/* Attribute of header text */
   BYTE    *headerText;    /* Pointer to header text */
   BYTE    *text;          /* Pointer to help text, always assumed to be... */
                           /* ...non NULL (when empty, points to a null byte */
} HELP_SCREEN;

typedef struct list_struct
{
   struct list_struct   *prev;
   struct list_struct   *next;
   void                 *otherInfo;
   LONG                 marked;
   WORD                 flags;
   WORD                 maxSkew;
   void                 (*entryProcedure)(struct list_struct *listElement,
                           LONG displayLine, void *NUTInfoStructure);
   LONG                 extra;
   char                 text[1];
} LIST;

typedef struct
{
   void  *head;
   void  *tail;
   int   (*sortProc)();
   void  (*freeProcedure)(void *memoryPointer);
} LISTPTR;

typedef struct
{
   char     *dynamicMessageOne;
   char     *dynamicMessageTwo;
   char     *dynamicMessageThree;
   char     *dynamicMessageFour;
   char     *dynamicMessageFive;
   char     *dynamicMessageSix;
   char     *dynamicMessageSeven;
   char     *dynamicMessageEight;
   char     *dynamicMessageNine;
   char     *dynamicMessageTen;
   char     *dynamicMessageEleven;
   char     *dynamicMessageTwelve;
   char     *dynamicMessageThirteen;
   char     *dynamicMessageFourteen;
   size_t   messageCount;
   char     **programMesgTable;
} MessageInfo;

typedef struct
{
   void  (*interruptProc)(void *handle);
   LONG  key;
} INTERRUPT;

typedef struct
{
   int   (*listAction)(int option, void *parameter);
   void  *parameter;
} MENU_PARAMETER;


typedef struct
{
   PCB         *portal[MAXPORTALS];
   LONG        currentPortal;
   LONG        headerHeight;
   LONG        waitFlag;
   LISTPTR     listStack[MAXLISTS];
   LISTPTR     saveStack[SAVELISTS];
   LONG        nextAvailList;
   LIST        *head;
   LIST        *tail;
   int         (*defaultCompareFunction)(LIST *el1, LIST *el2);
   void        (*freeProcedure)(void *memoryPointer);
   void        (*interruptTable[MAXFUNCTIONS])();
   LONG        functionKeyStatus[MAXACTIONS];
   MessageInfo messages;
   LONG        helpContextStack[MAXHELP];
   LONG        currentPreHelpMessage;
   int         freeHelpSlot;
   LONG        redisplayFormFlag;
   LONG        preHelpPortal;
   short       helpActive;
   short       errorDisplayActive;
   LONG        helpPortal;
   LONG        waitPortal;
   LONG        errorPortal;
   void        *resourceTag;
   void        *screenID;
   BYTE        *helpScreens;
   int         helpOffset;
   LONG        helpHelp;
   void        *allocChain;
   LONG        version;
   LONG        reserved1[10];
   LONG        moduleHandle;
   void        *customData;
   void        (*customDataRelease)(void *theData, void *thisStructure);
   LONG        displayErrorLabel;
   BYTE        *markBuffer;
   size_t      markBufferLength;
   char        *editBuffer;
   size_t      editBufferLength;

   /* no data beyond should be referenced directly by caller... */
   void        *reserved2[10];
} NUTInfo;


typedef struct
{
   LONG     headernum;          /* menu header message number */
   LONG     centerLine;         /* menu center line */
   LONG     centerColumn;       /* menu center column */
   size_t   maxoptlen;          /* length of longest menu option */
   int      (*action)(int option, void *parameter);/* menu action routine */
   LONG     arg1;
   LONG     arg2;
   LONG     arg3;
   LONG     arg4;
   LONG     arg5;
   LONG     arg6;
   LISTPTR  menuhead;           /* list head for menu list */
   NUTInfo  *nutInfo;
} MFCONTROL;

typedef struct fielddef
{
   LIST    *element;            /* list element that owns the field */
   LONG     fieldFlags;         /* Control flags */
   LONG     fieldLine;          /* Line where field is located */
   LONG     fieldColumn;        /* Column where field is located */
   size_t   fieldWidth;         /* Maximum width of field */
   LONG     fieldAttribute;     /* Display attribute for field */
   int      fieldActivateKeys;  /* Keys that will activate the field */

   void   (*fieldFormat)(struct fielddef *field, const char *text,
               size_t bufLen);

                                /* Routine called when field selected */
   LONG   (*fieldControl)(struct fielddef *field, int selectKey,
               int *fieldChanged, NUTInfo *handle);

                                /* Routine to verify Input */
   int    (*fieldVerify)(struct fielddef *field, BYTE *data, NUTInfo *handle);

                                /* Data & Xtra field release routine */
   void   (*fieldRelease)(struct fielddef *);

   BYTE             *fieldData; /* Pointer to data */
   BYTE             *fieldXtra; /* Additional control info */
   int               fieldHelp; /* help context for this field */
   struct fielddef  *fieldAbove;/* Pointer to field above */
   struct fielddef  *fieldBelow;/* Pointer to field below */
   struct fielddef  *fieldLeft; /* Pointer to field to left */
   struct fielddef  *fieldRight;/* Pointer to field to right */
   struct fielddef  *fieldPrev; /* Pointer to previous field */
   struct fielddef  *fieldNext; /* Pointer to next field */

                                /* if this value is set, this routine will be
                                    called upon entry to each field */
   void   (*fieldEntry)(struct fielddef *intoField, void *fieldData,
               NUTInfo *handle);

                                /* this allows the user to have any sort of
                                    custom data that he wants attached to the
                                    field */
   void    *customData;

                                /* and this permits release; note that these
                                    parameters match NWSFree which allows the
                                    use of NWSAlloc for this data (a further
                                    guarantee that the memory will be freed */
   void   (*customDataRelease)(void *fieldCustomData, NUTInfo *handle);

   NUTInfo *nutInfo;            /* handle to keep track of field ownership */
} FIELD;


typedef struct
{
   int   ccodeReturned;
   int   errorMessageNumber;
} PROCERROR;

typedef struct
{
   void  *address;
   void  *next;
} NUT_ALLOC;


#ifdef __cplusplus
extern "C" {
#endif

long  NWSInitializeNut(LONG utility, LONG version, LONG headerType,
        LONG compatibilityLevel, char **messageTable,
        const char *helpScreens, scr_t scr, rtag_t resourceTag,
        NUTInfo **handle);
void  NWSScreenSize(LONG *maxLines, LONG *maxColumns);
void  NWSShowPortalLine(LONG line, LONG column, const char *text, size_t length,
        PCB *portal);
void  NWSShowPortalLineAttribute(LONG line, LONG column, const char *text,
        LONG attribute, size_t length, PCB *portal);
void  NWSScrollPortalZone(LONG line, LONG column, size_t height, size_t width,
        LONG attribute, LONG count, LONG direction, PCB *portal);
void  NWSFillPortalZone(LONG line, LONG column, size_t height, size_t width,
        LONG fillCharacter, LONG fillAttribute, PCB *portal);
void  NWSFillPortalZoneAttribute(LONG line, LONG column, size_t height,
        size_t width, LONG attribute, PCB *portal);
char  *NWSGetMessage(int message, MessageInfo *messages);
void  NWSSetDynamicMessage(int message, const char *text,
        MessageInfo *messages);
LONG  NWSCreatePortal(LONG line, LONG column, size_t frameHeight,
        size_t frameWidth, size_t virtualHeight, size_t virtualWidth, LONG saveFlag,
        const char *headerText, LONG headerAttribute, LONG borderType,
        LONG borderAttr, LONG cursorFlag, LONG directFlag, NUTInfo *handle);
void  NWSDestroyPortal(LONG portalNumber, NUTInfo *handle);
void  NWSPositionPortalCursor(LONG line, LONG column, PCB  *portal);
void  NWSEnablePortalCursor(PCB *portal);
void  NWSDisablePortalCursor(PCB *portal);
void  NWSDeselectPortal(NUTInfo *handle);
void  NWSSelectPortal(LONG portalNumber, NUTInfo *handle);
int   NWSComputePortalPosition(LONG centerLine, LONG centerColumn,
        size_t height, size_t width, LONG *line, LONG *column, NUTInfo *handle);
void  NWSClearPortal(PCB *portal);
void  NWSInitList(NUTInfo *handle, void (*freeRoutine)(void *memoryPointer));
LONG  NWSPushList(NUTInfo *handle);
LONG  NWSPopList(NUTInfo *handleNWS);
LONG  NWSSaveList(LONG listIndex, NUTInfo *handle);
LONG  NWSRestoreList(LONG listIndex, NUTInfo *handle);
void  NWSDestroyList(NUTInfo *handle);
void  NWSDestroyMenu(NUTInfo *handle);
void  NWSDestroyForm(NUTInfo *handle);
LIST  *NWSAppendToList(const char *text, void *otherInfo, NUTInfo *handle);
LIST  *NWSDeleteFromList(LIST *el, NUTInfo *handle);
LIST  *NWSInsertInList(const char *text, char *otherInfo, LIST *atElement,
        NUTInfo *handle);
char  *NWSGetListElementText(LIST *element);
LIST  *NWSGetListHead(NUTInfo *handle);
LIST  *NWSGetListTail(NUTInfo *handle);
void  NWSUnmarkList(NUTInfo *handle);
void  NWSSetList(LISTPTR *listPtr, NUTInfo *handle);
void  NWSGetList(LISTPTR *listPtr, NUTInfo *handle);
LONG  NWSIsAnyMarked(NUTInfo *handle);
void  NWSPushMarks(NUTInfo *handle);
void  NWSPopMarks(NUTInfo *handle);
void  NWSSortList(NUTInfo *handle);
void  NWSInitMenu(NUTInfo *handle);
void  NWSInitForm(NUTInfo *handle);
LONG  NWSGetSortCharacter (LONG charIndex);
LONG  NWSGetLineDrawCharacter (LONG charIndex);
LONG  NWSStrcat(BYTE *string, BYTE *newStuff);
void  NWSMemmove(void *dest, void *source, size_t len);
BYTE  NWSToupper(BYTE ch);
int   NWSIsdigit(BYTE ch);
int   NWSIsxdigit(BYTE ch);
int   NWSAsciiToInt(BYTE *data);
LONG  NWSAsciiToLONG(BYTE *data);
int   NWSAsciiHexToInt(BYTE *data);
void  NWSWaitForEscape(NUTInfo *handle);
int   NWSWaitForEscapeOrCancel(NUTInfo *handle);
void  NWSGetKey(LONG *type, BYTE *value, NUTInfo *handle);
LONG  NWSKeyStatus(NUTInfo *handle);
LONG  NWSUngetKey(LONG type, LONG value, NUTInfo *handle);
void  NWSEnableFunctionKey(LONG key, NUTInfo *handle);
void  NWSDisableFunctionKey(LONG key, NUTInfo *handle);
void  NWSDisableInterruptKey(LONG key, NUTInfo *handle);
void  NWSEnableInterruptKey(LONG key, void (*interruptProc)(void *handle),
        NUTInfo *handle);
void  NWSSaveFunctionKeyList(BYTE *keyList, NUTInfo *handle);
void  NWSEnableFunctionKeyList(BYTE *keyList, NUTInfo *handle);
void  NWSSaveInterruptList(INTERRUPT *interruptList, NUTInfo *handle);
void  NWSEnableInterruptList(INTERRUPT *interruptList, NUTInfo *handle);
void  NWSDisableAllInterruptKeys(NUTInfo *handle);
void  NWSDisableAllFunctionKeys(NUTInfo *handle);
void  NWSEnableAllFunctionKeys(NUTInfo *handle);
int   NWSDisplayTextInPortal(LONG line, LONG indentLevel, const char *text,
        LONG attribute, PCB *portal);
LONG  NWSDisplayInformation(LONG header, LONG pauseFlag, LONG centerLine,
        LONG centerColumn, LONG palette, LONG attribute,
        const char *displayText, NUTInfo *handle);
void  NWSStartWait(LONG centerLine, LONG centerColumn, NUTInfo *handle);
void  NWSEndWait(NUTInfo *handle);
LONG  NWSAlert(LONG centerLine, LONG centerColumn, NUTInfo *handle,
        LONG message, ...);
LONG  NWSAlertWithHelp(LONG centerLine, LONG centerColumn, NUTInfo *handle,
        LONG message, LONG helpContext, ...);
LONG  NWSTrace(NUTInfo *handle, const char *message, ...);
void  NWSDisplayErrorText(LONG message, LONG severity, NUTInfo *handle, ...);
void  NWSDisplayErrorCondition(char *procedureName, int errorCode,
        LONG severity, PROCERROR *errorList, NUTInfo *handle, ...);
LIST *NWSAppendToMenu(LONG message, LONG option, NUTInfo *handle);
int   NWSMenu(LONG header, LONG centerLine, LONG centerColumn,
        LIST *defaultElement, int (*action)(int option, void *parameter),
        NUTInfo *handle, void *actionParameter);
int   NWSConfirm(LONG header, LONG centerLine, LONG centerColumn,
        LONG defaultChoice, int (*action)(int option, void *parameter),
        NUTInfo *handle, void *actionParameter);
int   NWSPushHelpContext(LONG helpContext, NUTInfo *handle);
int   NWSPopHelpContext(NUTInfo *handle);
LONG  NWSList(LONG header, LONG centerLine, LONG centerColumn,
        size_t height, size_t width, LONG validKeyFlags, LIST **element,
        NUTInfo *handle,
        int (*format)(LIST *element, LONG skew, const char *displayLine,
          size_t width),
        int (*action)(LONG keyPressed, LIST **elementSelected,
          LONG *itemLineNumber, void *actionParameter),
        void *actionParameter);
int   NWSInsertInPortalList(LIST **currentElement, LONG *currentLine,
        int (*InsertProcedure)(const char *text, void **otherInfo,
          void *parameters),
        int (*FreeProcedure)(void *otherInfo), NUTInfo *handle,
          void *parameters);
int   NWSModifyInPortalList(LIST **currentElement, LONG *currentLine,
        int (*ModifyProcedure)(char *text, void *parameters), NUTInfo *handle,
        void *parameters);
int   NWSDeleteFromPortalList(LIST **currentElement, LONG *currentLine,
        LIST *(*DeleteProcedure)(LIST *el, NUTInfo *handle, void *parameters),
        LONG deleteCurrentHeader, LONG deleteMarkedHeader, NUTInfo *handle,
        void *parameters);
int   NWSEditString(LONG centerLine, LONG centerColumn, size_t editHeight,
        size_t editWidth, LONG header, LONG prompt, char *buf, size_t maxLen,
        LONG type, NUTInfo *handle,
        int (*insertProc)(BYTE *buffer, size_t maxLen, void *parameters),
        int (*actionProc)(LONG action, BYTE *buffer, void *parameters),
        void *parameters);
FIELD *NWSAppendIntegerField(LONG line, LONG column, LONG fflag, int *data,
        int minimum, int maximum, LONG help, NUTInfo *handle);
FIELD *NWSAppendUnsignedIntegerField(LONG line, LONG column, LONG fflag,
        LONG *data, LONG minimum, LONG maximum, LONG help, NUTInfo *handle);
FIELD *NWSAppendHexField(LONG line, LONG column, LONG fflag, int *data,
        int minimum, int maximum, LONG help, NUTInfo *handle);
void  NWSDisplayPreHelp(LONG line, LONG column, LONG message, NUTInfo *handle);
void  NWSRemovePreHelp(NUTInfo *handle);
LONG  NWSGetADisk(const char *volName, const char *prompt, NUTInfo *handle);
void  NWSInitListPtr(LISTPTR *listPtr);
int   NWSEditForm(LONG headernum, LONG line, LONG col, size_t portalHeight,
        size_t portalWidth, size_t virtualHeight, size_t virtualWidth,
        LONG ESCverify, LONG forceverify, LONG confirmMessage, NUTInfo *handle);
int   NWSEditPortalFormField(LONG header, LONG cline, LONG ccol,
        size_t formHeight, size_t formWidth, LONG controlFlags, LONG formHelp,
        LONG confirmMessage, FIELD *startField, NUTInfo *handle);
int   NWSEditPortalForm(LONG header, LONG centerLine, LONG centerColumn,
        size_t formHeight, size_t formWidth, LONG controlFlags, LONG formHelp,
        LONG confirmMessage, NUTInfo *handle);
FIELD *NWSAppendToForm(LONG fline, LONG fcol, size_t fwidth, LONG fattr,
        void (*fFormat)(struct fielddef *field, const char *text, size_t bufLen),
        int  (*fControl)(struct fielddef *field, int selectKey,
          int *fieldChanged, NUTInfo *handle),
        int  (*fVerify)(struct fielddef *field, BYTE *data, NUTInfo *handle),
        void (*fRelease)(struct fielddef *field),
        BYTE *fData, BYTE *fXtra, LONG fflags, LONG fActivateKeys, LONG fhelp,
        NUTInfo *handle);
FIELD *NWSAppendPromptField(LONG line, LONG column, LONG promptnum,
        NUTInfo *handle);
FIELD *NWSAppendCommentField(LONG line, LONG column, const char *prompt,
        NUTInfo *handle);
FIELD *NWSAppendStringField(LONG line, LONG column, size_t width, LONG fflag,
        const char *data, const char *cset, LONG help, NUTInfo *handle);
FIELD *NWSAppendBoolField(LONG line, LONG column, LONG fflag, int *data,
        LONG help, NUTInfo *handle);
FIELD *NWSAppendGenericBoolField(LONG line, LONG column, LONG fflag,
        BYTE *data, LONG help, const char *yesString, const char *noString,
        NUTInfo *handle);
FIELD *NWSAppendHotSpotField(LONG line, LONG column, LONG fflag,
        const char *displayString,
        int (*SpotAction)(FIELD *fp, int selectKey, int *changedField,
          NUTInfo *handle),
        NUTInfo *handle);
MFCONTROL   *NWSInitMenuField(LONG headermsg, LONG cLine, LONG cCol,
        int (*action)(int option, void *parameter), NUTInfo *nutInfo, ...);
int   NWSAppendToMenuField(MFCONTROL *m, LONG optiontext, int option,
        NUTInfo *nutInfo);

FIELD *NWSAppendMenuField(LONG line, LONG column, LONG fflag, int *data,
        MFCONTROL *m, LONG help, NUTInfo *nutInfo);
int   NWSEditText(LONG centerLine, LONG centerColumn, size_t height,
        size_t width, LONG headerNumber, char *textBuffer, size_t maxBufLen,
        LONG confirmMessage, LONG forceConfirm, NUTInfo *handle);
int   NWSViewText(LONG centerLine, LONG centerColumn, size_t height,
        size_t width, LONG headerNumber, const char *textBuffer,
        size_t maxBufLen, NUTInfo *handle);
void  NWSDisplayHelpScreen(LONG offset, NUTInfo *handle);
void  *NWSAlloc(LONG numberOfBytes, NUTInfo *handle);
void  NWSFree(void *address, NUTInfo *handle);
int   NWSDisplayTextJustifiedInPortal(LONG justify, LONG line, LONG column,
        size_t textWidth, const char *text, LONG attribute, PCB *portal);
int   NWSDisplayInformationInPortal(LONG header, LONG portalJustifyLine,
        LONG portalJustifyColumn, LONG portalJustifyType, LONG portalPalette,
        LONG portalBorderType, size_t portalMaxWidth, size_t portalMaxHeight,
        size_t portalMinWidth, size_t portalMinHeight, LONG textLRJustifyType,
        LONG textLRIndent, LONG textTBJustifyType, LONG textTBIndent,
        LONG textAttribute, LONG textMinimizeStyle, const char *text,
        NUTInfo *handle);
void  NWSRestoreNut(NUTInfo *handle);
void  NWSDrawPortalBorder(PCB *portal);
void  NWSUpdatePortal(PCB *portal);
void  NWSSetFieldFunctionPtr(FIELD *fp,
        void (*Format) (FIELD *, const char *text, LONG),
        int  (*Control) (FIELD *, int, int *, NUTInfo *),
        int  (*Verify) (FIELD *, BYTE *, NUTInfo *),
        void (*Release) (FIELD *),
        void (*Entry) (FIELD *, void *, NUTInfo *),
        void (*customDataRelease) (void *, NUTInfo *));
void  NWSGetFieldFunctionPtr (FIELD *fp,
        void (**Format) (FIELD *, const char *text, LONG),
        int  (**Control) (FIELD *, int, int *, NUTInfo *),
        int  (**Verify) (FIELD *, BYTE *, NUTInfo *),
        void (**Release) (FIELD *),
        void (**Entry) (FIELD *, void *, NUTInfo *),
        void (**customDataRelease) (void *, NUTInfo *));
void  NWSSetDefaultCompare(NUTInfo *handle,
        int (*defaultCompareFunction)(LIST *el1, LIST *el2));
void  NWSGetDefaultCompare (NUTInfo *handle,
        int (**defaultCompareFunction)(LIST *el1, LIST *el2));

/* added in version 402 */
void  NWSSetListSortFunction(NUTInfo *handle,
        void (*listSortFunction)(LIST *head, LIST *tail, NUTInfo *handle));

/* added in version 402 */
void  NWSGetListSortFunction(NUTInfo *handle,
        void (**listSortFunction)(LIST *head, LIST *tail, NUTInfo *handle));
void  NWSSetScreenPalette(LONG newPalette, NUTInfo *handle);
LONG  NWSGetScreenPalette(NUTInfo *handle);
void  NWSGetPCB(PCB **pPcb, LONG portalNumber, NUTInfo *handle);
void  NWSSetListNotifyProcedure(LIST *el,
        void (*entryProcedure)(LIST *element, LONG displayLine,
          NUTInfo *handle));
void  NWSGetListNotifyProcedure(LIST *el,
        void (**entryProcedure)(LIST *element, LONG displayLine,
          NUTInfo *handle));
void  NWSSetHandleCustomData(NUTInfo *handle, void *customData,
        void (*customDataRelease)(void *theData, NUTInfo *handle));
void  NWSGetHandleCustomData(NUTInfo *handle, void **customData,
        void (**customDataRelease)(void *theData, NUTInfo *handle));
void  NWSSetErrorLabelDisplayFlag(LONG flag, NUTInfo *handle);
void  NWSSetHelpHelp(LONG helpIndex, NUTInfo *handle);
LONG  NWSPromptForPassword (LONG passwordHeader, LONG line, LONG column,
        size_t maxPasswordLen, const char *passwordString, LONG verifyEntry,
        NUTInfo *handle);
FIELD *NWSAppendPasswordField(LONG line, LONG column, size_t width, LONG fflag,
        char *data, size_t maxDataLen, LONG help, LONG verifyEntry,
        LONG passwordPortalHeader, LONG maskCharacter, NUTInfo *handle);
FIELD *NWSAppendScrollableStringField(LONG line, LONG column, size_t width,
        LONG fflag, char *data, size_t maxLen, char *cset, LONG editFlags,
        LONG help, NUTInfo *handle);
void  NWSSetScrollableFieldInsertProc (FIELD *fp,
        int (*insertProc) (BYTE *string, size_t maxLen, void *parameters));

/* returns 0 for success, -1 if none selected */
LONG  NWSGetCurrentPortal(NUTInfo *nutInfo, LONG *portalNumber, PCB **portal);

int   NWSWaitForKeyAndValue(NUTInfo *handle, LONG nKeys, LONG keyType[],
        LONG keyValue[]);
void  NWSShowLineAttribute(LONG line, LONG column, const char *text,
        LONG attribute, size_t length, scr_t scr);
void  NWSShowLine(LONG line, LONG column, const char *text, size_t length,
        scr_t scr);
void  NWSScrollZone(LONG line, LONG column, size_t height, size_t width,
        LONG attribute, LONG count, LONG direction, scr_t scr);
void  NWSSaveZone(LONG line, LONG column, size_t height, size_t width,
        BYTE *buffer, scr_t scr);
void  NWSRestoreZone(LONG line, LONG column, size_t height, size_t width,
        BYTE *buffer, scr_t scr);
void  NWSRestoreDisplay(struct ScreenStruct *screenID);
void  NWSPositionCursor(LONG line, LONG column, scr_t scr);
void  NWSGetNUTVersion(LONG *majorVersion, LONG *minorVersion, LONG *revision);
void  NWSSetFormRepaintFlag(LONG value, NUTInfo *handle);
void  NWSSetFormNoWrap(NUTInfo *handle);
int   NWSViewTextWithScrollBars(LONG centerLine, LONG centerColumn,
        size_t height, size_t width, LONG headerNumber, const char *textBuffer,
        size_t maxBufferLength, LONG scrollBarFlag, NUTInfo *handle);
int   NWSEditTextWithScrollBars(LONG centerLine, LONG centerColumn,
        size_t height, size_t width, LONG headerNumber, char *textBuffer,
        size_t maxBufferLength, LONG confirmMessage, LONG forceConfirm,
        LONG scrollBarFlag, NUTInfo *handle);


#include <poppack.h>

#ifdef __cplusplus
}
#endif

#endif
#endif
#endif
