#ifndef __proc_h__
#define __proc_h__
/*============================================================================
=  Novell Software Development Kit
=
=  Copyright (C) 2002 Novell, Inc. All Rights Reserved.
=
=  This work is subject to U.S. and international copyright laws and treaties.
=  Use and redistribution of this work is subject  to  the  license  agreement
=  accompanying  the  software  development kit (SDK) that contains this work.
=  However, no part of this work may be revised and/or  modified  without  the
=  prior  written consent of Novell, Inc. Any use or exploitation of this work
=  without authorization could subject the perpetrator to criminal  and  civil
=  liability.
=
=  Source(s): Novell Header
=
=  proc.h
==============================================================================
*/
#include <stddef.h>

#define PROC_DETACHED      0x00000001 /* detached process            */
#define PROC_CURRENT_SPACE 0x00000004 /* use current address space   */
#define PROC_MEMORY_DEBUG  0x00000008 /* same as load -m             */
#define PROC_LOAD_SILENT   0x00000010 /* no console messages         */
#define PROC_INHERIT_CWD   0x00000020 /* child start in same CWD     */

/* standard console wiring for process()...                          */
typedef struct
{
#define FD_UNUSED  -1  /* ignore: do not wire the console            */
   int   infd;         /* new process' standard input, etc.          */
   int   outfd;
   int   errfd;
} wiring_t;


#ifdef __cplusplus
extern "C"
{
#endif

pid_t  procle( const char *path, unsigned long flags, const char *env[],
					wiring_t *wiring, struct fd_set *fds, void *appdata,
					size_t appdata_size, void *reserved, const char *arg0, ... );
pid_t  procve( const char *path, unsigned long flags, const char *env[],
					wiring_t *wiring, struct fd_set *fds, void *appdata,
					size_t appdata_size, void *reserved, const char *argv[] );

#ifdef __cplusplus
}
#endif


#endif
