#ifndef __pthread_h__
#define __pthread_h__
/*=============================================================================
=  Novell Software Development Kit
=
=  Copyright (C) 1999-2002 Novell, Inc. All Rights Reserved.
=
=  This work is subject to U.S. and international copyright laws and treaties.
=  Use and redistribution of this work is subject  to  the  license  agreement
=  accompanying  the  software  development kit (SDK) that contains this work.
=  However, no part of this work may be revised and/or  modified  without  the
=  prior  written consent of Novell, Inc. Any use or exploitation of this work
=  without authorization could subject the perpetrator to criminal  and  civil
=  liability. 
=
=  Source(s): ISO/IEC (POSIX) 9845:1996
=
=  pthread.h
===============================================================================
*/
#include <sched.h>
#include <signal.h>
#include <sys/time.h>
#include <nks/synch.h>
#include <nks/thread.h>

#define PTHREAD_CREATE_DETACHED     NX_THR_DETACHED
#define PTHREAD_CREATE_JOINABLE     0

#define PTHREAD_SCOPE_PROCESS       0
#define PTHREAD_SCOPE_SYSTEM        1    /* as yet unsupported */
#define PTHREAD_PROCESS_PRIVATE     0
#define PTHREAD_PROCESS_SHARED      1    /* as yet unsupported */

#define PTHREAD_CANCELED            (-1)
#define PTHREAD_CANCEL_ASYNCHRONOUS 1
#define PTHREAD_CANCEL_DEFERRED     2
#define PTHREAD_CANCEL_DISABLE      0
#define PTHREAD_CANCEL_ENABLE       1

#define PTHREAD_EXPLICIT_SCHED      0    /* as yet unsupported */
#define PTHREAD_INHERIT_SCHED       1    /* as yet unsupported */

#define PTHREAD_PRIO_INHERIT        1    /* as yet unsupported */
#define PTHREAD_PRIO_NONE           0    /* as yet unsupported */
#define PTHREAD_PRIO_PROTECT        (-1) /* as yet unsupported */

#define PTHREAD_ONCE_INIT           0

#define PTHREAD_COND_INITIALIZER    {0,0,0,0}
#define PTHREAD_MUTEX_INITIALIZER   {PTHREAD_PROCESS_PRIVATE,\
                                     0,0,0,0,0,0,0,0,0,0}

typedef NXThreadId_t pthread_t;
typedef NXKey_t      pthread_key_t;
typedef NXMutex_t    pthread_mutex_t;
typedef NXCond_t     pthread_cond_t;

typedef int          pthread_once_t;


#include <pshpack1.h>

typedef struct
{
   unsigned long attr_flags;
   int           attr_scope;
   int           attr_priority;
   int           attr_detachstate;
   void         *attr_stackaddr;
   size_t        attr_stacksize;
   int           attr_spare1;
   int           attr_spare2;
} pthread_attr_t;

typedef struct
{
   unsigned long cattr_flags;
   void         *cattr_arg;
   int           cattr_spare1;
   int           cattr_spare2;
} pthread_condattr_t;

typedef struct
{
   unsigned long mattr_flags;
   NXHierarchy_t mattr_hierarchy;
   int           mattr_priority;
   int           mattr_prioceiling;
   int           mattr_protocol;
   int           mattr_spare1;
   int           mattr_spare2;
   int           mattr_spare3;
   NXLockInfo_t  mattr_lock_info;
} pthread_mutexattr_t;

#include <poppack.h>

#ifdef __cplusplus
extern "C"
{
#endif

//pthread_once_t once_control = PTHREAD_ONCE_INIT;

/* pthread functions... */
int   pthread_create(pthread_t *thread, const pthread_attr_t *attr,
                        void *(*start_routine)(void *), void *arg);
int   pthread_cancel(pthread_t thread);
int   pthread_join  (pthread_t thread, void **status);
void  pthread_exit  (void *status);
int   pthread_equal (pthread_t t1, pthread_t t2);
void  pthread_yield (void);
int   pthread_kill  (pthread_t thread, int sig);
int   pthread_detach(pthread_t thread);
int   pthread_once  (pthread_once_t *once_control, void (*init_routine)(void));

pthread_t pthread_self(void);

int   pthread_key_create (pthread_key_t *, void (*destructor)(void *));
int   pthread_key_delete (pthread_key_t key);
void *pthread_getspecific(pthread_key_t key);
int   pthread_setspecific(pthread_key_t key, const void *value);

int   pthread_getschedparam(pthread_t thread, int *policy,
                               struct sched_param *param);
int   pthread_setschedparam(pthread_t thread, int policy,
                               const struct sched_param *param);

int   pthread_setcancelstate(int state, int *oldstate);
int   pthread_setcanceltype (int type, int *oldtype);
void  pthread_testcancel    (void);

int   pthread_sigmask(int how, const sigset_t *set, sigset_t *oset);

void  pthread_cleanup_push(void (*routine)(void *), void *arg);
void  pthread_cleanup_pop (int execute);

/* pthread attribute functions... */
int   pthread_attr_init           (pthread_attr_t *attr);
int   pthread_attr_destroy        (pthread_attr_t *attr);
int   pthread_attr_getdetachstate (const pthread_attr_t *attr,
                                      int *detachstate);
int   pthread_attr_setdetachstate (pthread_attr_t *attr, int detachstate);
int   pthread_attr_getinheritsched(const pthread_attr_t *attr,
                                      int *inheritsched);
int   pthread_attr_setinheritsched(pthread_attr_t *attr,  int inheritsched);
int   pthread_attr_getschedparam  (const pthread_attr_t *attr,
                                      struct sched_param *param);
int   pthread_attr_setschedparam  (pthread_attr_t *attr,
                                      struct sched_param *param);
int   pthread_attr_getschedpolicy (const pthread_attr_t *attr, int *policy);
int   pthread_attr_setschedpolicy (pthread_attr_t *attr, int *policy);
int   pthread_attr_getscope       (const pthread_attr_t *attr,
                                      int *contentionscope);
int   pthread_attr_setscope       (pthread_attr_t *attr, int contentionscope);
int   pthread_attr_getstackaddr   (const pthread_attr_t *attr,void **stackaddr);
int   pthread_attr_setstackaddr   (pthread_attr_t *attr, void *stackaddr);
int   pthread_attr_getstacksize   (const pthread_attr_t *attr,
                                      size_t * stacksize);
int   pthread_attr_setstacksize   (pthread_attr_t *attr, size_t stacksize);

/* condition variable functions... */
int   pthread_cond_init          (pthread_cond_t *cond,
                                     const pthread_condattr_t *attr);
int   pthread_cond_destroy       (pthread_cond_t *cond);
int   pthread_cond_signal        (pthread_cond_t *cond);
int   pthread_cond_broadcast     (pthread_cond_t *cond);
int   pthread_cond_wait          (pthread_cond_t *cond, pthread_mutex_t *mutex);
int   pthread_cond_timedwait     (pthread_cond_t *cond, pthread_mutex_t *mutex,
                                     const struct timespec *);

/* condition variable attribute functions... */
int   pthread_condattr_init      (pthread_condattr_t *attr);
int   pthread_condattr_destroy   (pthread_condattr_t *attr);
int   pthread_condattr_getpshared(const pthread_condattr_t *attr,
                                     int *pshared);
int   pthread_condattr_setpshared(pthread_condattr_t *attr, int pshared);

/* mutex functions... */
int   pthread_mutex_init              (pthread_mutex_t *mutex,
                                          const pthread_mutexattr_t *attr);
int   pthread_mutex_destroy           (pthread_mutex_t *mutex);
int   pthread_mutex_lock              (pthread_mutex_t *mutex);
int   pthread_mutex_trylock           (pthread_mutex_t *mutex);
int   pthread_mutex_unlock            (pthread_mutex_t *mutex);

/* mutex attribute functions... */
int   pthread_mutexattr_init          (pthread_mutexattr_t *attr);
int   pthread_mutexattr_destroy       (pthread_mutexattr_t *attr);
int   pthread_mutexattr_getprioceiling(const pthread_mutexattr_t *attr,
                                          int *prioceiling);
int   pthread_mutexattr_setprioceiling(pthread_mutexattr_t *attr,
                                          int prioceiling);
int   pthread_mutexattr_getprotocol   (const pthread_mutexattr_t *attr,
                                          int *protocol);
int   pthread_mutexattr_setprotocol   (pthread_mutexattr_t *attr,
                                          int protocol);
int   pthread_mutexattr_getpshared    (const pthread_mutexattr_t *attr,
                                          int *pshared);
int   pthread_mutexattr_setpshared    (pthread_mutexattr_t *attr,
                                          int pshared);


#ifdef __cplusplus
}
#endif

#define sigprocmask(a,b,c)
#define sigset(a,b)

#endif
