#ifndef __pwd_h__
#define __pwd_h__
/*============================================================================
=  Novell Software Development Kit
=
=  Copyright (C) 1999-2002 Novell, Inc. All Rights Reserved.
=
=  This work is subject to U.S. and international copyright laws and treaties.
=  Use and redistribution of this work is subject  to  the  license  agreement
=  accompanying  the  software  development kit (SDK) that contains this work.
=  However, no part of this work may be revised and/or  modified  without  the
=  prior  written consent of Novell, Inc. Any use or exploitation of this work
=  without authorization could subject the perpetrator to criminal  and  civil
=  liability. 
=
=  Source(s): ISO/IEC (POSIX) 9845:1996
=             POSIX Standard: 9.2.2 User database access
=
=  pwd.h
==============================================================================
*/
#include <stddef.h>
#include <time.h>


typedef struct passwd
{
   char    *pw_name;    /* username             */
   char    *pw_passwd;  /* password             */
   uid_t    pw_uid;     /* user ID              */
   gid_t    pw_gid;     /* group ID             */
   char    *pw_dir;     /* home directory       */
   char    *pw_shell;   /* default shell        */
   char    *pw_gecos;   /* Honeywell login info */
   char    *pw_comment; /* comment              */
   time_t   pw_change;  /* password change time */
   time_t   pw_expire;  /* account expiration   */
   char    *pw_LDAPName;/* real name            */
   void    *spare1[3];
   void    *spare2[4];
} passwd;


#ifdef __cplusplus
extern "C" {
#endif

void     setpwent( void );
void     endpwent( void );
passwd  *getpwent( void );
passwd  *getpwuid( uid_t userid );
passwd  *getpwnam( const char *name );
uid_t    geteuid( void );
uid_t    getuid(void );

int      posixlogin( char *host, int port, char *name, char *pwd, char *ctx );
int      posixlogout( void );

#ifdef __cplusplus
}
#endif

#endif
