#ifndef __ringx_h__
#define __ringx_h__
/*============================================================================
=  Novell Software Development Kit
=
=  Copyright (C) 1999-2002 Novell, Inc. All Rights Reserved.
=
=  This work is subject to U.S. and international copyright laws and treaties.
=  Use and redistribution of this work is subject  to  the  license  agreement
=  accompanying  the  software  development kit (SDK) that contains this work.
=  However, no part of this work may be revised and/or  modified  without  the
=  prior  written consent of Novell, Inc. Any use or exploitation of this work
=  without authorization could subject the perpetrator to criminal  and  civil
=  liability.
=
=  Source(s): Novell Header
=
=  Direct consumption of NetWare OS interfaces; additional library interfaces.
=
=  ringx.h
==============================================================================
*/
#include <wchar.h>
#include <stddef.h>

#define PAGE_SIZE       4096

#define RxLockMemory    NVMKernelLock
#define RxUnlockMemory  NVMKernelUnlock


typedef void   (*RxCleanup_t)( void * );


/* data; referenced to overcome compiler optimization */
int  RxTmp;


/* preliminary (registration and clean-up)... */
int  RxIdentifyCode     ( void *, void *, int *);
int  RxUnidentifyCode   ( int);
int  RxRegisterSyscall  ( void *, const char *, int);
int  RxUnregisterSyscall( char *);

/* mundane calls... */
int  RxLockMemory       ( const void *, size_t);
int  RxUnlockMemory     ( const void *, size_t);

/* to handle address space fault and threads caught in kernel... */
int  RxRegisterKernelResource  ( void *, RxCleanup_t );
int  RxRegisterThreadResource  ( void *, RxCleanup_t );
int  RxUnregisterKernelResource( void * );
int  RxUnregisterThreadResource( void * );


/* main working macros (buffers and structures, char and wide strings... */
#define RX_CHECK_BUFFER(ptr, size)                \
{                                                 \
   char   *end, *beg, tmp = 0;                    \
                                                  \
   if (size)                                      \
   {                                              \
      beg = (char *)(ptr);                        \
      end = (char *)(ptr)+(size)-1;/* last byte */\
                                                  \
      do                                          \
      {                                           \
         tmp += *beg;                             \
         beg += PAGE_SIZE;                        \
      } while (beg < end);                        \
                                                  \
      tmp  += *end;   /* check last byte */       \
      RxTmp = tmp;    /* don't be optimized out */\
   }                                              \
}

#define RX_CHECK_STRLEN(str, len)                 \
{                                                 \
   char  *tmp;                                    \
                                                  \
   tmp   = (char *)(str);                         \
   (len) = 0;                                     \
                                                  \
   while (*tmp)                                   \
      (len)++, tmp++;                             \
}

#define RX_CHECK_WCSLEN(str, len)                 \
{                                                 \
   wchar_t  *tmp;                                 \
                                                  \
   tmp   = (wchar_t *)(str);                      \
   (len) = 0;                                     \
                                                  \
   while (*tmp)                                   \
      (len)++, tmp++;                             \
}

#define RX_CHECK_UNILEN RX_CHECK_WCSLEN

#endif
