#ifndef __sched_h__
#define __sched_h__
/*=============================================================================
=  Novell Software Development Kit
=
=  Copyright (C) 1999-2002 Novell, Inc. All Rights Reserved.
=
=  This work is subject to U.S. and international copyright laws and treaties.
=  Use and redistribution of this work is subject  to  the  license  agreement
=  accompanying  the  software  development kit (SDK) that contains this work.
=  However, no part of this work may be revised and/or  modified  without  the
=  prior  written consent of Novell, Inc. Any use or exploitation of this work
=  without authorization could subject the perpetrator to criminal  and  civil
=  liability. 
=
=  Source(s): ISO/IEC (POSIX) 9845:1996
=
=  sched.h
===============================================================================
*/
#include <time.h>
#include <thread.h>

#define SCHED_UNKNOWN   0 /* unknown policy                            */
#define SCHED_FIFO      1 /* first-in, first-out (default NetWare MPK) */
#define SCHED_RR        2 /* round-robin         (unimplemented)       */

#include <pshpack1.h>

struct sched_param
{
   int   sched_priority;
};

#include <poppack.h>


#ifdef __cplusplus
extern "C" {
#endif

int sched_getparam        ( pid_t pid, const struct sched_param *param );
int sched_getscheduler    ( pid_t pid );
int sched_get_priority_max( int policy );
int sched_get_priority_min( int policy );
int sched_rr_get_interval ( pid_t pid, struct timespec *interval );
int sched_setparam        ( pid_t pid, const struct sched_param *param );
int sched_setscheduler    ( pid_t pid, int policy,
                              const struct sched_param *param );
int sched_yield           ( void );

#ifdef __cplusplus
}
#endif

#endif
