#ifndef __screen_h__
#define __screen_h__
/*============================================================================
=  Novell Software Development Kit
=
=  Copyright (C) 1999-2002 Novell, Inc. All Rights Reserved.
=
=  This work is subject to U.S. and international copyright laws and treaties.
=  Use and redistribution of this work is subject  to  the  license  agreement
=  accompanying  the  software  development kit (SDK) that contains this work.
=  However, no part of this work may be revised and/or  modified  without  the
=  prior  written consent of Novell, Inc. Any use or exploitation of this work
=  without authorization could subject the perpetrator to criminal  and  civil
=  liability. 
=
=  Source(s): Novell Header--these are not recommended interfaces
=
=  screen.h
==============================================================================
*/
#include <stddef.h>
#include <netware.h>

#define MAX_SCREEN_STRING_LEN 255

/* screen mode flags... */
#define SCR_NO_MODE           0x00000000
#define SCR_AUTOCLOSE_ON_EXIT 0x00000001  /* (default) */
#define SCR_COLOR_ATTRS       0x00000002

/* key types... */
#define NORMAL_KEY            0x00
#define FUNCTION_KEY          0x01
#define ENTER_KEY             0x02
#define ESCAPE_KEY            0x03
#define BACKSPACE_KEY         0x04
#define DELETE_KEY            0x05
#define INSERT_KEY            0x06
#define CURSOR_UP_KEY         0x07
#define CURSOR_DOWN_KEY       0x08
#define CURSOR_RIGHT_KEY      0x09
#define CURSOR_LEFT_KEY       0x0A
#define CURSOR_HOME_KEY       0x0B
#define CURSOR_END_KEY        0x0C
#define CURSOR_PUP_KEY        0x0D
#define CURSOR_PDOWN_KEY      0x0E

/* some name equivalents... */
#define ENTER                 0x0D
#define ESCAPE                0x1B
#define BACKSPACE             0x08

/* modifier code constituents... */
#define SHIFT_KEY_HELD        0x01
#define CTRL_KEY_HELD         0x02
#define ALT_KEY_HELD          0x04
#define CAPS_LOCK_IS_ON       0x10
#define NUM_LOCK_IS_ON        0x20
#define SCROLL_LOCK_IS_ON     0x40

/* suggested 'maxlen' argument for getpassword()... */
#define _PASSWORD_LEN         128

/* string-embeddable color representations... */
#define COLOR_STR_BLACK       "\x1B[0;30m"
#define COLOR_STR_MAROON      "\x1B[0;31m"
#define COLOR_STR_GREEN       "\x1B[0;32m"
#define COLOR_STR_OLIVE       "\x1B[0;33m"
#define COLOR_STR_NAVY        "\x1B[0;34m"
#define COLOR_STR_PURPLE      "\x1B[0;35m"
#define COLOR_STR_TEAL        "\x1B[0;36m"
#define COLOR_STR_SILVER      "\x1B[0;37m"

#define COLOR_STR_GREY        "\x1B[1;30m"
#define COLOR_STR_RED         "\x1B[1;31m"
#define COLOR_STR_LIME        "\x1B[1;32m"
#define COLOR_STR_YELLOW      "\x1B[1;33m"
#define COLOR_STR_BLUE        "\x1B[1;34m"
#define COLOR_STR_MAGENTA     "\x1B[1;35m"
#define COLOR_STR_CYAN        "\x1B[1;36m"
#define COLOR_STR_WHITE       "\x1B[1;37m"

#define COLOR_STR_NORMAL      COLOR_STR_SILVER /* dim/unhighlighted white */
#define COLOR_STR_GRAY        COLOR_STR_GREY

/* attributes for OutputToScreenWithAttributes(); cf. HTML color names */
#define COLOR_ATTR_NONE       0           /* (black, no color at all)        */
#define COLOR_ATTR_NAVY       1           /* (dim blue)                      */
#define COLOR_ATTR_BLUE       (0x01|8)
#define COLOR_ATTR_GREEN      2
#define COLOR_ATTR_LIME       (0x02|8)    /* (bright green)                  */
#define COLOR_ATTR_TEAL       3           /* (dim cyan)                      */
#define COLOR_ATTR_CYAN       (0x03|8)
#define COLOR_ATTR_MAROON     4           /* (dim red)                       */
#define COLOR_ATTR_RED        (0x04|8)
#define COLOR_ATTR_PURPLE     5
#define COLOR_ATTR_MAGENTA    (0x05|8)    /* (bright purple)                 */
#define COLOR_ATTR_OLIVE      6           /* (brown, dim yellow)             */
#define COLOR_ATTR_YELLOW     (0x06|8)
#define COLOR_ATTR_SILVER     7           /* normal white, dim/unhighlighted */
#define COLOR_ATTR_GREY       8           /* (dimmed white)                  */
#define COLOR_ATTR_WHITE      15          /* bright, highlighted white       */


#ifndef __SCR_T
# define __SCR_T
typedef void *scr_t;
#endif

#ifdef __cplusplus
extern "C" {
#endif

/* LibC-promulgated functions... */
void     clearscreen     ( void );
int      consoleprintf   ( const char *, ... );
int      getscreenmode   ( unsigned long *mode );
int      getcharacter    ( void );
int      getkey          ( int *keytype, int *modifer, int *scancode );
scr_t    getconsolehandle( void );
char    *getpassword     ( const char *prompt, char *password, size_t maxlen );
scr_t    getscreenhandle ( void );
char    *getstring       ( char *string, size_t max, int display );
int      gotorowcol      ( int row, int col );
int      kbhit           ( void );
int      pressanykey     ( void );
int      pressescape     ( void );
int      pressenter      ( void );
int      putcharacter    ( int ch );
int      putstring       ( const char *string );
int      setscreenmode   ( unsigned long mode );
int      renamescreen    ( const char *name );
void     ringbell        ( void );
int      ungetcharacter  ( int ch );
int      ungetkey        ( int keytype, int modifer, int scancode );
int      wherecol        ( void );
int      whererow        ( void );
int      whererowcol     ( int *row, int *col );

#ifdef __cplusplus
}
#endif

/* direct NetWare OS interfaces... */
typedef enum
{
   SCROLL_DOWN = 0,
   SCROLL_UP   = 1,
   SCROLL_NONE = INT_MAX
} scroll_t;

#ifdef __cplusplus
extern "C" {
#endif

void  ActivateScreen( scr_t scrID );
int   CheckIfScreenActive( scr_t scrID, unsigned long waitFlag );
int   CheckKeyStatus( scr_t scrID );
void  ClearScreen( scr_t scrID );
void  CloseScreen( scr_t scrID );
void  DisableInputCursor( scr_t scrID );
int   DisplayScreenLine( scr_t scrID, uint32_t line, uint32_t col,
         uint32_t length, uint8_t *textAndAttr ); 
int   DisplayScreenText( scr_t scrID, uint32_t line, uint32_t col,
         uint32_t length, char *text ); 
int   DisplayScreenTextWithAttribute( scr_t scrID, uint32_t line,
         uint32_t col, uint32_t length, uint8_t lineAttr, char *text );
void  EnableInputCursor( scr_t scrID );
int   FillScreenArea( scr_t scrID, uint32_t line, uint32_t col,
         uint32_t height, uint32_t width, char character, uint8_t attr );
int   FillScreenAreaAttribute( scr_t scrID, uint32_t line, uint32_t col,
         uint32_t height, uint32_t width, uint8_t attr ); 
scr_t GetActiveScreen( void );
int   GetActualScreenSize( scr_t scrID, uint32_t *height, uint32_t *width,
         size_t *bufferSize ); 
void  GetCursorStyle( scr_t scrID, uint16_t *cursorStyle ); 
void  GetInputCursorPosition( scr_t scrID, uint16_t *row, uint16_t *col );
void  GetKey( scr_t scrID, uint8_t *type, uint8_t *value, uint8_t *status,
         uint8_t *scanCode, size_t linesToProtect );
void  GetOutputCursorPosition( scr_t scrID, uint16_t *row, uint16_t *col );
void *GetScreenAddress( void );
int   GetScreenName( scr_t scrID, char *nameBuffer);
void  GetScreenSize( uint16_t *height, uint16_t *width );
int   IsScreenModeSupported( unsigned long screenMode); 
int   OpenScreen( const char *screenName, rtag_t rTag, scr_t *newScrID );
int   OutputToScreen( scr_t scrID, const char *format, ... );
int   OutputToScreenWithAttribute( scr_t scrID, uint8_t attr,
         const char *format, ...);
void  Pause( scr_t scrID );
int   PauseWithEscape( scr_t scrID );
void  PositionInputCursor( scr_t scrID, uint16_t row, uint16_t col );
int   PositionOutputCursor( scr_t scrID, uint16_t row, uint16_t col );
int   ReadScreenCharacter( scr_t scrID, uint32_t line, uint32_t col,
         char *character ); 
int   RenameScreen( scr_t scrID, const char *name );
int   RestoreFullScreen( scr_t scrID, void *buffer ); 
int   RestoreScreenArea( scr_t scrID, uint32_t line, uint32_t col,
         uint32_t height, uint32_t width, void *buffer ); 
void  ReturnScreenType( unsigned long *type, unsigned long *colorFlag ); 
void  RingTheBell( void );
int   SaveFullScreen( scr_t scrID, void *buffer ); 
int   SaveScreenArea( scr_t scrID, uint32_t line, uint32_t col,
         uint32_t height, uint32_t width, void *buffer ); 
void  SetCursorStyle( scr_t scrID, uint16_t newStyle ); 
void  SetInputToOutputCursorPosition( scr_t scrID );
int   ScrollScreenArea( scr_t scrID, uint32_t line, uint32_t col,
         uint32_t height, uint32_t width, uint32_t count,
         uint8_t newLineAttribute, scroll_t direction ); 
void  ShowTitleBarText( void *screenMemoryAddress, const char *titleBarText,
         size_t textLength );
int   UngetKey( scr_t scrID, uint8_t type, uint8_t value, uint8_t status,
         uint8_t scanCode );
int   ValidateScreenHandle( scr_t scrID );
void  WaitForKey( scr_t scrID );
int   WriteScreenCharacter( scr_t scrID, uint32_t line, uint32_t col,
         char character ); 
int   WriteScreenCharacterAttribute( scr_t scrID, uint32_t line,
         uint32_t col, char character, uint8_t attr );


#ifdef __cplusplus
}
#endif

#define CONSOLE_SCREEN  ((scr_t) 0)

/* cursor types... */
#define CURSOR_NORMAL          0x0C0B
#define CURSOR_THICK           0x0C09
#define CURSOR_BLOCK           0x0C00
#define CURSOR_TOP             0x0400

/* screen types... */
#define SCREEN_TYPE_TTY        0x00
#define SCREEN_TYPE_MONOCHROME 0x01
#define SCREEN_TYPE_DUAL_MODE  0x02
#define SCREEN_TYPE_CGA        0x03
#define SCREEN_TYPE_EGA        0x04
#define SCREEN_TYPE_VGA        0x05

/* screen modes... */
#define SCREEN_MODE_TTY        0x00
#define SCREEN_MODE_80X25      0x01
#define SCREEN_MODE_80X43      0x02
#define SCREEN_MODE_80X50      0x03
#define SCREEN_MODE_D          0x0D
#define SCREEN_MODE_E          0x0E
#define SCREEN_MODE_F          0x0F
#define SCREEN_MODE_10         0x10
#define SCREEN_MODE_11         0x11
#define SCREEN_MODE_12         0x12
#define SCREEN_MODE_13         0x13

#endif
