#ifndef __semaphore_h__
#define __semaphore_h__
/*=============================================================================
=  Novell Software Development Kit
=
=  Copyright (C) 1999-2002 Novell, Inc. All Rights Reserved.
=
=  This work is subject to U.S. and international copyright laws and treaties.
=  Use and redistribution of this work is subject  to  the  license  agreement
=  accompanying  the  software  development kit (SDK) that contains this work.
=  However, no part of this work may be revised and/or  modified  without  the
=  prior  written consent of Novell, Inc. Any use or exploitation of this work
=  without authorization could subject the perpetrator to criminal  and  civil
=  liability. 
=
=  Source(s): ISO/IEC (POSIX) 9845:1996
=
=  semaphore.h
===============================================================================
*/
#include <nks/synch.h>
#include <limits.h>

#define SEM_VALUE_MAX   ULONG_MAX
#define SEM_FAILED      ((sem_t *) 0)

typedef NXSema_t  sem_t;


#ifdef __cplusplus
extern "C" {
#endif

int sem_init   ( sem_t *sem, int pshared, unsigned int value );
int sem_destroy( sem_t *sem );
int sem_post   ( sem_t *sem );
int sem_wait   ( sem_t *sem );
int sem_trywait( sem_t *sem );

#ifdef __cplusplus
}
#endif

#endif
