#ifndef __setjmp_h__
#define __setjmp_h__
/*============================================================================
=  Novell Software Development Kit
=
=  Copyright (C) 1999-2002 Novell, Inc. All Rights Reserved.
=
=  This work is subject to U.S. and international copyright laws and treaties.
=  Use and redistribution of this work is subject  to  the  license  agreement
=  accompanying  the  software  development kit (SDK) that contains this work.
=  However, no part of this work may be revised and/or  modified  without  the
=  prior  written consent of Novell, Inc. Any use or exploitation of this work
=  without authorization could subject the perpetrator to criminal  and  civil
=  liability. 
=
=  Source(s): ISO/IEC (ANSI) 9899:1990
=
=  setjmp.h
==============================================================================
*/
#include <stddef.h>

#if defined(IAPX386)
# define _JBTYPE  double
# define _JBLEN   32
#elif defined(_M_IA64)
# define _JBTYPE  __int128
# define _JBLEN   40
#endif

typedef _JBTYPE jmp_buf[_JBLEN];

#ifdef __cplusplus
extern "C"
{
#endif

void  __longjmp( jmp_buf, int );
int   __setjmp( jmp_buf );

#ifdef __cplusplus
}
#endif

#define longjmp(b, w)   __longjmp(b, w)
#define setjmp(b)       __setjmp(b)

#endif
