#ifndef __signal_h__
#define __signal_h__
/*============================================================================
=  Novell Software Development Kit
=
=  Copyright (C) 1999-2002 Novell, Inc. All Rights Reserved.
=
=  This work is subject to U.S. and international copyright laws and treaties.
=  Use and redistribution of this work is subject  to  the  license  agreement
=  accompanying  the  software  development kit (SDK) that contains this work.
=  However, no part of this work may be revised and/or  modified  without  the
=  prior  written consent of Novell, Inc. Any use or exploitation of this work
=  without authorization could subject the perpetrator to criminal  and  civil
=  liability. 
=
=  Source(s): ISO/IEC (ANSI) 9899:1990; ISO/IEC (POSIX) 9845:1996
=
=  signal.h
==============================================================================
*/
#include <stddef.h>

/* default handler values */
#define SIG_IGN            (void (*)(int)) 1
#define SIG_DFL            (void (*)(int)) 2
#define SIG_ERR            (void (*)(int)) 3

/* standard signals */
#define SIGABRT            1
#define SIGFPE             2
#define SIGILL             3
#define SIGINT             4
#define SIGSEGV            5
#define SIGTERM            6
#define SIGPOLL            7

/* currently unimplemented POSIX-mandated signals */
#define SIGKILL            11
#define SA_NOCLDSTOP       12
#define SIGALRM            13
#define SIGCHILD           14
#define SIGCHLD            SIGCHILD
#define SIGCONT            15
#define SIGHUP             16
#define SIGPIPE            17
#define SIGQUIT            18
#define SIGSTOP            19
#define SIGTSTP            20
#define SIGTTIN            21
#define SIGTTOU            22
#define SIGUSR1            23
#define SIGUSR2            24
#define SIGUSR3            25
#define SIGUSR4            26
#define SIGUSR5            27
#define SIGUSR6            28
#define SIGUSR7            29

/* Novell-defined signals */
#define SIG_FINI           30
#define SIG_LOCALECHANGE   31

#define NSIG					32

#define SIG_BLOCK          0x00000000
#define SIG_UNBLOCK        0x00000001
#define SIG_SETMASK        0xFFFFFFFF

#define SIGEMPTYSET        0x0000000000000000
#define SIGFULLSET         0xFFFFFFFFFFFFFFFF


typedef int      sig_atomic_t;
typedef uint64_t sigset_t;

struct sigaction 
{
   void     (*sa_handler)(int);
   sigset_t sa_mask;
   int      sa_flags;
};


#ifdef __cplusplus
extern "C" {
#endif

int    raise   ( int );
void (*signal  ( int sig, void (*func)( int ) )) ( int );


#ifndef __ANSIC__
int sigwait    ( const sigset_t *set, int *sig );

/* signal vector functions... */
int sigaction  (int sig, const struct sigaction *act, struct sigaction *oact);
int sigaddset  (sigset_t *, const int);
int sigdelset  (sigset_t *, const int);
int sigismember(const sigset_t *, int);
int sigfillset (sigset_t *);
int sigemptyset(sigset_t *);
#endif


#ifdef __cplusplus
}
#endif

#endif
