#ifndef __stdarg_h__
#define __stdarg_h__
/*============================================================================
=  Novell Software Development Kit
=
=  Copyright (C) 1999-2002 Novell, Inc. All Rights Reserved.
=
=  This work is subject to U.S. and international copyright laws and treaties.
=  Use and redistribution of this work is subject  to  the  license  agreement
=  accompanying  the  software  development kit (SDK) that contains this work.
=  However, no part of this work may be revised and/or  modified  without  the
=  prior  written consent of Novell, Inc. Any use or exploitation of this work
=  without authorization could subject the perpetrator to criminal  and  civil
=  liability. 
=
=  Source(s): ISO/IEC (ANSI) 9899:1990
=
=  stdarg.h
==============================================================================
*/
#define _VA_LIST

typedef char   *va_list;

#define _ARGWIDTH(n)       ((sizeof(n) + sizeof(int) - 1) & ~(sizeof(int) - 1))
#define va_start(ap, parm) (void) (ap = (va_list) &parm + _ARGWIDTH(parm))
#define va_end(ap)         (void) (ap = (va_list) 0)
#define va_arg(ap, type)   (*(type *)((ap += _ARGWIDTH(type))-_ARGWIDTH(type)))


#endif
