#ifndef __stdint_h__
#define __stdint_h__
/*============================================================================
=  Novell Software Development Kit
=
=  Copyright (C) 1999-2002 Novell, Inc. All Rights Reserved.
=
=  This work is subject to U.S. and international copyright laws and treaties.
=  Use and redistribution of this work is subject  to  the  license  agreement
=  accompanying  the  software  development kit (SDK) that contains this work.
=  However, no part of this work may be revised and/or  modified  without  the
=  prior  written consent of Novell, Inc. Any use or exploitation of this work
=  without authorization could subject the perpetrator to criminal  and  civil
=  liability. 
=
=  Source(s): ISO/IEC (ANSI) 9899:1999--partial compliance
=
=  stdint.h
==============================================================================
*/
#include <limits.h>

#if defined(__MWERKS__)            /* Metrowerks CodeWarrior */
# define X_INT64_X     long long
#elif defined(__ICL)               /* Intel's C/C++ 32- and 64-bit */
# define X_INT64_X     long long
#elif defined(__INTEL_COMPILER)    /* Intel's C/C++ 32- and 64-bit (v >= 5.0) */
# define X_INT64_X     long long
#elif defined(__GNUC__)            /* GNU C/C++ */
# define X_INT64_X     long long
#elif defined(__WATCOMC__)         /* Watcom C/C++ */
# define X_INT64_X     __int64
#elif defined(__ECC__)             /* Ediburgh Portable Compilers, Ltd. */
# define X_INT64_X     __int64
#elif defined(__BORLANDC__)        /* Borland */
# define X_INT64_X     __int64
#elif defined(_MSC_VER)            /* Microsoft */
# define X_INT64_X     __int64
#else
# error Compiler defined unsupported in environment!
#endif

#ifndef X_UINT64_X
# define X_UINT64_X     unsigned X_INT64_X
#endif

#if defined(_M_IA64)                /* NetWare 64 */
# define MACHINE_WORD   X_INT64_X
#define _Bool           INT32       /* no penalty in access */
#else                               /* IAPX386/NetWare */
# define MACHINE_WORD   int
#define _Bool           int
#endif

#define UMACHINE_WORD   unsigned MACHINE_WORD


#if !defined(__cplusplus) || defined(__STDC_LIMIT_MACROS)
# define __INCLUDE_LIMIT_MACROS__
#endif
#if !defined(__cplusplus) || defined(__STDC_CONSTANT_MACROS)
# define __INCLUDE_CONSTANT_MACROS__
#endif


/* exact-width signed types... */
typedef signed char        int8_t;
typedef short int          int16_t;
typedef long int           int32_t;
typedef X_INT64_X          int64_t;

/* exact-width unsigned types... */
typedef unsigned char      uint8_t;
typedef unsigned short int uint16_t;
typedef unsigned long int  uint32_t;
typedef X_UINT64_X         uint64_t;

#ifdef __INCLUDE_LIMIT_MACROS__
/* lower and upper bound of exact width integer types... */
# define INT8_MIN          SCHAR_MIN
# define INT16_MIN         SHRT_MIN
# define INT32_MIN         LONG_MIN
# define INT64_MIN         LLONG_MIN

# define INT8_MAX          SCHAR_MAX
# define INT16_MAX         SHRT_MAX
# define INT32_MAX         LONG_MAX
# define INT64_MAX         LLONG_MAX

# define UINT8_MAX         UCHAR_MAX
# define UINT16_MAX        USHRT_MAX
# define UINT32_MAX        ULONG_MAX
# define UINT64_MAX        ULLONG_MAX

# define INTMAX_MIN        INT32_MIN
# define INTMAX_MAX        INT32_MAX
# define UINTMAX_MIN       UINT32_MIN
# define UINTMAX_MAX       UINT32_MAX
#endif

#ifdef __INCLUDE_CONSTANT_MACROS__
/* macros for minimum-width integer constants... */
# define INT8_C(value)     value
# define INT16_C(value)    value
# define INT32_C(value)    value ## L
# define INT64_C(value)    value ## LL

# define UINT8_C(value)    value ## U
# define UINT16_C(value)   value ## U
# define UINT32_C(value)   value ## UL
# define UINT64_C(value)   value ## ULL
#endif

/* minimum-width signed integer types... */
typedef signed char        int_least8_t;
typedef short int          int_least16_t;
typedef long int           int_least32_t;
typedef X_INT64_X          int_least64_t;

/* minimum-width unsigned integer types... */
typedef unsigned char      uint_least8_t;
typedef unsigned short int uint_least16_t;
typedef unsigned long int  uint_least32_t;
typedef X_UINT64_X         uint_least64_t;

#ifdef __INCLUDE_LIMIT_MACROS__
/* lower and upper bound of exact width integer types... */
# define INT_LEAST8_MIN    SCHAR_MIN
# define INT_LEAST16_MIN   SHRT_MIN
# define INT_LEAST32_MIN   LONG_MIN
# define INT_LEAST64_MIN   LLONG_MIN

# define INT_LEAST8_MAX    SCHAR_MAX
# define INT_LEAST16_MAX   SHRT_MAX
# define INT_LEAST32_MAX   LONG_MAX
# define INT_LEAST64_MAX   LLONG_MAX
#endif

/* fastest minimum-width signed integer types... */
typedef signed char        int_fast8_t;
typedef short int          int_fast16_t;
typedef long int           int_fast32_t;
typedef X_INT64_X          int_fast64_t;

/* fastest minimum-width unsigned integer types... */
typedef unsigned char      uint_fast8_t;
typedef unsigned short int uint_fast16_t;
typedef unsigned long int  uint_fast32_t;
typedef X_UINT64_X         uint_fast64_t;

#ifdef __INCLUDE_LIMIT_MACROS__
/* lower and upper bound of fastest minimum-width integer types... */
# define INT_FAST8_MIN     SCHAR_MIN
# define INT_FAST16_MIN    SHRT_MIN
# define INT_FAST32_MIN    LONG_MIN
# define INT_FAST64_MIN    LLONG_MIN

# define INT_FAST8_MAX     SCHAR_MAX
# define INT_FAST16_MAX    SHRT_MAX
# define INT_FAST32_MAX    LONG_MAX
# define INT_FAST64_MAX    LLONG_MAX
#endif


/* integer types capable of holding object pointer... */
#if defined(_M_IA64)                /* Modesto */

typedef int64_t            intptr_t;
typedef uint64_t           uintptr_t;

#ifdef __INCLUDE_LIMIT_MACROS__
/* limit of integer type capable of holding object pointer... */
# define INTPTR_MIN        LLONG_MIN
# define INTPTR_MAX        LLONG_MAX
# define UINTPTR_MAX       ULLONG_MAX
#endif

#else                               /* NetWare */

typedef int32_t            intptr_t;
typedef uint32_t           uintptr_t;

#ifdef __INCLUDE_LIMIT_MACROS__
/* limit of integer type capable of holding object pointer... */
# define INTPTR_MIN        LONG_MIN
# define INTPTR_MAX        LONG_MAX
# define UINTPTR_MAX       ULONG_MAX
#endif

#endif

/* maximum-width integer types... */
typedef int64_t            intmax_t;
typedef uint64_t           uintmax_t;

#ifdef __INCLUDE_LIMIT_MACROS__
/* macros for maximum-width integer constants... */
# define INTMAX_C(value)   value ## LL
# define UINTMAX_C(value)  value ## ULL

/* limits for other integer types... */
# define PTRDIFF_MIN       LONG_MIN
# define PTRDIFF_MAX       LONG_MAX
# define SIG_ATOMIC_MIN    INT_MIN
# define SIG_ATOMIC_MAX    INT_MAX
# define SIZE_MAX          65535
# define WCHAR_MIN         0
# define WCHAR_MAX         65535
# define WINT_MIN          (-32768)
# define WINT_MAX          65535
#endif

#endif
