#ifndef __stdio_h__
#define __stdio_h__
/*============================================================================
=  Novell Software Development Kit
=
=  Copyright (C) 1999-2002 Novell, Inc. All Rights Reserved.
=
=  This work is subject to U.S. and international copyright laws and treaties.
=  Use and redistribution of this work is subject  to  the  license  agreement
=  accompanying  the  software  development kit (SDK) that contains this work.
=  However, no part of this work may be revised and/or  modified  without  the
=  prior  written consent of Novell, Inc. Any use or exploitation of this work
=  without authorization could subject the perpetrator to criminal  and  civil
=  liability. 
=
=  Source(s): ISO/IEC (ANSI) 9899:1990; ISO/IEC (POSIX) 9845:1996; Common
=
=  stdio.h
==============================================================================
*/
#include <stdarg.h>
#include <stddef.h>

/* miscellaneous definitions                                               */
#define EOF          (-1)
#define BUFSIZ       8096     /* default buffer size--change with setbuf() */
#define FOPEN_MAX    1024     /* at least this many FILEs available        */
#define FILENAME_MAX 1024     /* maximum characters in any path name       */

/* values for argument 'flags' to setvbuf()... */
#define _IONBF       0x0010   /* unbuffered (e.g.: stdout and stderr)      */
#define _IOLBF       0x0020   /* line buffered (e.g.: stdin)               */
#define _IOFBF       0x0040   /* fully buffered (most files)               */

/* values for fseek()'s whence argument                                    */
#define SEEK_SET     0        /* add 'offset' to beginning of file         */
#define SEEK_CUR     1        /* add 'offset' to current position in file  */
#define SEEK_END     2        /* add 'offset' to end of file               */

/* definitions for tmpnam() and tmpfil()                                   */
#define TMP_MAX      1000000  /* "T-000000.TMP" to "T-999999.TMP"          */
#define L_tmpnam     36
#define P_tmpdir     "sys:/tmp"

struct _iobuf;                /* file stream structure                     */
typedef struct _iobuf   FILE; /* FILE type definition (result is opaque)   */

typedef long      fpos_t;

#ifndef __ANSIC__
typedef off64_t   fpos64_t;
#endif


#ifdef __cplusplus
extern "C" {
#endif

void     clearerr ( FILE * );
int      fclose   ( FILE * );
int      feof     ( FILE * );
int      ferror   ( FILE * );
int      fflush   ( FILE * );
int      fgetc    ( FILE * );
int      fgetpos  ( FILE *, fpos_t * );
char    *fgets    ( char *, int, FILE * );
FILE    *fopen    ( const char * restrict, const char * restrict );
int      fprintf  ( FILE * restrict, const char * restrict, ... );
int      fputc    ( int, FILE * );
int      fputs    ( const char * restrict, FILE * restrict );
size_t   fread    ( void * restrict, size_t, size_t, FILE * restrict );
FILE    *freopen  ( const char * restrict, const char * restrict,
                          FILE * restrict );
int      fscanf   ( FILE * restrict, const char * restrict, ... );
int      fseek    ( FILE *fp, long offset, int whence );
int      fsetpos  ( FILE *, const fpos_t * );
long     ftell    ( FILE * );
size_t   fwrite   ( const void * restrict, size_t, size_t,
                          FILE * restrict );
int      getc     ( FILE * );
int      getchar  ( void );
char    *gets     ( char * );
void     perror   ( const char * );
int      printf   ( const char * restrict, ... );
int      putc     ( int, FILE * );
int      putchar  ( int );
int      puts     ( const char * );
int      remove   ( const char * );
int      rename   ( const char *, const char * );
void     rewind   ( FILE * );
int      scanf    ( const char * restrict, ... );
void     setbuf   ( FILE * restrict, char * restrict );
int      setvbuf  ( FILE * restrict, char * restrict, int, size_t );
int      sprintf  ( char * restrict, const char * restrict, ... );
int      snprintf ( char * restrict, size_t n, const char * restrict, ... );
int      sscanf   ( const char * restrict, const char * restrict, ... );
FILE    *tmpfile  ( void );
char    *tmpnam   ( char * );
int      ungetc   ( int, FILE * );
int      vfprintf ( FILE * restrict, const char * restrict, va_list );
int      vfscanf  ( FILE * restrict, const char * restrict, va_list );
int      vprintf  ( const char * restrict, va_list );
int      vscanf   ( const char * restrict, va_list );
int      vsnprintf( char * restrict, size_t n, const char * restrict, va_list );
int      vsprintf ( char * restrict, const char * restrict, va_list );
int      vsscanf  ( const char * restrict, const char * restrict, va_list );

/* functions underlying macro support... */
FILE   **___stdin ( void );
FILE   **___stdout( void );
FILE   **___stderr( void );
FILE   **___cin   ( void );
FILE   **___cout  ( void );

#ifndef __ANSIC__
/* POSIX-defined and other additions... */
FILE    *fdopen          ( int, const char * restrict );
int      fileno          ( FILE * );
void     flockfile       ( FILE * );
int      ftrylockfile    ( FILE * );
void     funlockfile     ( FILE * );
int      getc_unlocked   ( FILE * );
int      getchar_unlocked( void );
int      pclose          ( FILE *stream );
FILE    *popen           ( const char *command, const char *mode );
int      putc_unlocked   ( int c, FILE * );
int      putchar_unlocked( int c );
char    *tempnam         ( const char *dirpath, const char *prefix );

/* nonstandard (transitional) addtions for 64-bit file I/O... */
int      fgetpos64( FILE *, fpos64_t * );
int      fseek64  ( FILE *fp, fpos64_t offset, int whence );
int      fsetpos64( FILE *, const fpos64_t * );
off64_t  ftell64  ( FILE * );

#ifndef _POSIX_SOURCE
/* hard-wired console I/O support (cannot be redirected)... */
int      cgetc    ( void );
char    *cgets    ( char * );
int      cprintf  ( const char *, ... );
int      cputc    ( int );
int      cputs    ( const char * );
int      cscanf   ( const char * restrict, ... );
int      vcprintf ( const char * restrict, va_list );
int      vcscanf  ( const char * restrict, va_list );
#endif
#endif

#ifdef __cplusplus
}
#endif


/* defined as macros in both C and C++... */
#define stdin     (*___stdin())
#define stdout    (*___stdout())
#define stderr    (*___stderr())
#define cstdin    (*___cin())
#define cstdout   (*___cout())


#ifdef __cplusplus
inline int getc( FILE *fp )        { return fgetc(fp);       }
inline int putc( int c, FILE *fp ) { return fputc(c, fp);    }
inline int getchar( void )         { return getc(stdin);     }
inline int putchar( int c )        { return putc(c, stdout); }
#else
# define getc(fp)    fgetc(fp)
# define getchar()   getc(stdin)
# define putc(c, fp) fputc((c), (fp))
# define putchar(c)  putc((c), stdout)
#endif

/* UNIX 98/POSIX.1-2002 defined additions */
#define fseeko       fseek
#define ftello       ftell
#define fseeko64     fseek64
#define ftello64     ftell64


#endif
